/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.text.NumberFormat;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.coverage.CellFormat;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.GridTile;
import org.apache.sis.gui.coverage.GridTileCache;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;

@DefaultProperty(value="image")
public class GridView
extends Control {
    static final int MIN_CELL_SIZE = 1;
    static final String OUT_OF_BOUNDS = "";
    private ImageLoader loader;
    public final ObjectProperty<RenderedImage> imageProperty;
    private int width;
    private int height;
    private int minX;
    private int minY;
    private int numXTiles;
    private int tileWidth;
    private int tileHeight;
    private int tileGridXOffset;
    private int tileGridYOffset;
    private final GridTileCache tiles;
    private GridTile lastTile;
    public final IntegerProperty bandProperty = new BandProperty();
    public final DoubleProperty headerWidth;
    public final DoubleProperty cellWidth;
    public final DoubleProperty cellHeight;
    public final DoubleProperty cellSpacing;
    public final ObjectProperty<Paint> headerBackground;
    private final NumberFormat headerFormat;
    final CellFormat cellFormat;
    final StatusBar statusBar;

    public GridView() {
        this(null);
    }

    GridView(RecentReferenceSystems recentReferenceSystems) {
        this.imageProperty = new SimpleObjectProperty((Object)this, "image");
        this.headerWidth = new SimpleDoubleProperty((Object)this, "headerWidth", 60.0);
        this.cellWidth = new SimpleDoubleProperty((Object)this, "cellWidth", 60.0);
        this.cellHeight = new SimpleDoubleProperty((Object)this, "cellHeight", 20.0);
        this.cellSpacing = new SimpleDoubleProperty((Object)this, "cellSpacing", 4.0);
        this.headerBackground = new SimpleObjectProperty((Object)this, "headerBackground", (Object)Color.GAINSBORO);
        this.headerFormat = NumberFormat.getIntegerInstance();
        this.cellFormat = new CellFormat(this);
        this.statusBar = new StatusBar(recentReferenceSystems, new MapCanvas[0]);
        this.tiles = new GridTileCache();
        this.tileWidth = 1;
        this.tileHeight = 1;
        this.setMinSize(120.0, 40.0);
        this.imageProperty.addListener((observableValue, renderedImage, renderedImage2) -> this.onImageSpecified((RenderedImage)renderedImage2));
    }

    public final RenderedImage getImage() {
        return (RenderedImage)this.imageProperty.get();
    }

    public final void setImage(RenderedImage renderedImage) {
        this.imageProperty.set((Object)renderedImage);
    }

    public void setImage(ImageRequest imageRequest) {
        if (imageRequest == null) {
            this.setImage((RenderedImage)null);
        } else {
            ImageLoader imageLoader = this.loader;
            this.loader = null;
            if (imageLoader != null) {
                imageLoader.cancel();
            }
            this.loader = new ImageLoader(imageRequest, true);
            BackgroundThreads.execute((Runnable)((Object)this.loader));
        }
    }

    public final int getBand() {
        return this.bandProperty.get();
    }

    public final void setBand(int n) {
        this.bandProperty.set(n);
    }

    private void onImageSpecified(RenderedImage renderedImage) {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
        this.tiles.clear();
        this.lastTile = null;
        this.width = 0;
        this.height = 0;
        if (renderedImage != null) {
            this.minX = renderedImage.getMinX();
            this.minY = renderedImage.getMinY();
            this.width = renderedImage.getWidth();
            this.height = renderedImage.getHeight();
            this.numXTiles = renderedImage.getNumXTiles();
            this.tileWidth = Math.max(1, renderedImage.getTileWidth());
            this.tileHeight = Math.max(1, renderedImage.getTileHeight());
            this.tileGridXOffset = Math.subtractExact(renderedImage.getTileGridXOffset(), this.minX);
            this.tileGridYOffset = Math.subtractExact(renderedImage.getTileGridYOffset(), this.minY);
            this.cellFormat.dataTypeisInteger = false;
            SampleModel sampleModel = renderedImage.getSampleModel();
            if (sampleModel != null) {
                int n = sampleModel.getNumBands();
                if (this.getBand() >= n) {
                    ((BandProperty)this.bandProperty).setNoCheck(n - 1);
                }
                this.cellFormat.dataTypeisInteger = ImageUtilities.isIntegerType((SampleModel)sampleModel);
            }
            this.cellFormat.configure(renderedImage, this.getBand());
        }
        this.contentChanged(true);
    }

    final void contentChanged(boolean bl) {
        Skin skin = this.getSkin();
        if (skin instanceof GridViewSkin) {
            ((GridViewSkin)skin).contentChanged(bl);
        }
    }

    final double getContentWidth() {
        double d = GridView.getSizeValue(this.cellWidth);
        return (double)this.width * d + GridView.getSizeValue(this.headerWidth) + Math.max(d, 20.0);
    }

    static double getSizeValue(DoubleProperty doubleProperty) {
        double d = doubleProperty.get();
        return d >= 1.0 ? d : 1.0;
    }

    final int getImageHeight() {
        return this.height;
    }

    final Rectangle getTileBounds(int n, int n2) {
        return new Rectangle(n * this.tileWidth + this.tileGridXOffset, n2 * this.tileHeight + this.tileGridYOffset, this.tileWidth, this.tileHeight);
    }

    final int toTileY(int n) {
        return Math.floorDiv(Math.subtractExact(n, this.tileGridYOffset), this.tileHeight);
    }

    final String getSampleValue(int n, int n2, int n3) {
        Object object;
        if (n2 < 0 || n2 >= this.height || n3 < 0 || n3 >= this.width) {
            return OUT_OF_BOUNDS;
        }
        int n4 = Math.floorDiv(Math.subtractExact(n3, this.tileGridXOffset), this.tileWidth);
        Object object2 = this.lastTile;
        if (object2 == null || ((GridTile)object2).tileX != n4 || ((GridTile)object2).tileY != n) {
            object = new GridTile(n4, n, this.numXTiles);
            object2 = (GridTile)this.tiles.putIfAbsent(object, object);
            if (object2 == null) {
                object2 = object;
            }
            this.lastTile = object2;
        }
        if ((object = ((GridTile)object2).tile()) == null) {
            ((GridTile)object2).load(this);
            return null;
        }
        return this.cellFormat.format((Raster)object, Math.addExact(n3, this.minX), Math.addExact(n2, this.minY), this.getBand());
    }

    final String formatHeaderValue(int n, boolean bl) {
        if (n >= 0 && n < (bl ? this.height : this.width)) {
            return this.cellFormat.format(this.headerFormat, (long)n + (long)(bl ? this.minY : this.minX));
        }
        return OUT_OF_BOUNDS;
    }

    public final Optional<StringProperty> cellFormatPattern() {
        return this.cellFormat.hasPattern() ? Optional.of(this.cellFormat) : Optional.empty();
    }

    final void formatCoordinates(int n, int n2) {
        this.statusBar.setLocalCoordinates(this.minX + n, this.minY + n2);
    }

    protected final Skin<GridView> createDefaultSkin() {
        return new GridViewSkin(this);
    }

    private final class BandProperty
    extends IntegerPropertyBase {
        private BandProperty() {
        }

        public Object getBean() {
            return GridView.this;
        }

        public String getName() {
            return "band";
        }

        public void set(int n) {
            SampleModel sampleModel;
            RenderedImage renderedImage = GridView.this.getImage();
            if (renderedImage != null && (sampleModel = renderedImage.getSampleModel()) != null) {
                ArgumentChecks.ensureBetween("band", 0, sampleModel.getNumBands() - 1, n);
                GridView.this.cellFormat.configure(renderedImage, n);
            } else {
                ArgumentChecks.ensurePositive("band", n);
            }
            super.set(n);
            GridView.this.contentChanged(false);
        }

        final void setNoCheck(int n) {
            super.set(Math.max(n, 0));
        }
    }

    private final class ImageLoader
    extends Task<RenderedImage> {
        private final ImageRequest request;
        private final boolean converted;

        ImageLoader(ImageRequest imageRequest, boolean bl) {
            this.request = imageRequest;
            this.converted = bl;
        }

        protected RenderedImage call() throws DataStoreException {
            return this.request.load((FutureTask<?>)((Object)this), this.converted);
        }

        protected void succeeded() {
            GridView.this.loader = null;
            this.terminated(this.request.getCoverage().get());
            GridView.this.setImage((RenderedImage)this.getValue());
            this.request.configure(GridView.this.statusBar);
        }

        protected void failed() {
            this.terminated(null);
            GridView.this.setImage((RenderedImage)null);
            GridCoverageResource gridCoverageResource = this.request.resource;
            GridView gridView = GridView.this;
            if (gridCoverageResource instanceof StoreListeners) {
                ExceptionReporter.canNotReadFile((Node)gridView, ((StoreListeners)gridCoverageResource).getSourceName(), this.getException());
            } else {
                ExceptionReporter.canNotUseResource((Node)gridView, this.getException());
            }
        }

        protected void cancelled() {
            this.terminated(null);
        }

        private void terminated(GridCoverage gridCoverage) {
            CoverageExplorer coverageExplorer = this.request.listener;
            this.request.listener = null;
            if (coverageExplorer != null) {
                coverageExplorer.onCoverageLoaded(gridCoverage, (Resource)this.request.resource);
            }
        }
    }
}

