/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import javafx.concurrent.Task;
import org.apache.sis.gui.coverage.GridError;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.internal.gui.BackgroundThreads;

final class GridTile {
    final int tileX;
    final int tileY;
    private final int hashCode;
    private Raster tile;
    private GridError error;
    private boolean loading;

    GridTile(int n, int n2, int n3) {
        this.tileX = n;
        this.tileY = n2;
        this.hashCode = n + n2 * n3;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof GridTile) {
            GridTile gridTile = (GridTile)object;
            return this.tileX == gridTile.tileX && this.tileY == gridTile.tileY;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.tileX + ", " + this.tileY + "]";
    }

    final Raster tile() {
        return this.tile;
    }

    final boolean clearTile() {
        if (this.loading) {
            return false;
        }
        this.tile = null;
        return this.error == null;
    }

    final void clear() {
        this.tile = null;
        this.error = null;
        this.loading = false;
    }

    final void load(final GridView gridView) {
        if (!this.loading && this.error == null) {
            this.loading = true;
            final RenderedImage renderedImage = gridView.getImage();
            BackgroundThreads.execute((Runnable)new Task<Raster>(){

                protected Raster call() {
                    return renderedImage.getTile(GridTile.this.tileX, GridTile.this.tileY);
                }

                protected void succeeded() {
                    GridTile.this.clear();
                    if (gridView.getImage() == renderedImage) {
                        GridTile.this.tile = (Raster)this.getValue();
                        gridView.contentChanged(false);
                    }
                }

                protected void failed() {
                    GridTile.this.clear();
                    if (gridView.getImage() == renderedImage) {
                        GridTile.this.error = new GridError(gridView, GridTile.this, this.getException());
                        ((GridViewSkin)gridView.getSkin()).errorOccurred(GridTile.this.error);
                    }
                }

                protected void cancelled() {
                    GridTile.this.clear();
                }
            });
        }
    }
}

