/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.lang.ref.Reference;
import java.util.Collection;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.coverage.BandRangeTable;
import org.apache.sis.gui.coverage.BandSelectionListener;
import org.apache.sis.gui.coverage.Controls;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.resources.Vocabulary;

final class GridControls
extends Controls {
    private final GridView view;
    private final Accordion controls;
    private final TableView<SampleDimension> sampleDimensions;

    GridControls(RecentReferenceSystems recentReferenceSystems, Vocabulary vocabulary) {
        this.view = new GridView(recentReferenceSystems);
        this.sampleDimensions = new BandRangeTable(this.view.cellFormat).create(vocabulary);
        this.sampleDimensions.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new BandSelectionListener(this.view.bandProperty));
        this.view.bandProperty.addListener((observableValue, number, number2) -> this.onBandSpecified((Number)number2));
        Label label = GridControls.labelOfGroup(vocabulary, (short)178, this.sampleDimensions, true);
        VBox vBox = new VBox(new Node[]{label, this.sampleDimensions});
        GridPane gridPane = Styles.createControlGrid(0, GridControls.label(vocabulary, (short)224, (Control)GridControls.createSlider(this.view.cellWidth, 30.0, 200.0)), GridControls.label(vocabulary, (short)98, (Control)GridControls.createSlider(this.view.cellHeight, 10.0, 50.0)), GridControls.label(vocabulary, (short)85, this.view.cellFormat.createEditor()));
        Styles.setAllRowToSameHeight(gridPane);
        label = new VBox(new Node[]{GridControls.labelOfGroup(vocabulary, (short)24, (Region)gridPane, true), gridPane});
        this.controls = new Accordion(new TitledPane[]{new TitledPane(vocabulary.getString((short)38), (Node)vBox), new TitledPane(vocabulary.getString((short)67), (Node)label)});
        this.controls.setExpandedPane((TitledPane)this.controls.getPanes().get(0));
    }

    private static Slider createSlider(DoubleProperty doubleProperty, double d, double d2) {
        Slider slider = new Slider(d, d2, doubleProperty.getValue().doubleValue());
        doubleProperty.bind((ObservableValue)slider.valueProperty());
        slider.setShowTickMarks(false);
        return slider;
    }

    private void onBandSpecified(Number number) {
        this.sampleDimensions.getSelectionModel().clearAndSelect(number.intValue());
    }

    @Override
    final void coverageChanged(GridCoverage gridCoverage, Reference<Resource> reference) {
        ObservableList observableList = this.sampleDimensions.getItems();
        if (gridCoverage != null) {
            observableList.setAll((Collection)gridCoverage.getSampleDimensions());
            this.sampleDimensions.getSelectionModel().clearAndSelect(this.view.getBand());
        } else {
            observableList.clear();
        }
    }

    @Override
    final Region view() {
        return this.view;
    }

    @Override
    final Control controls() {
        return this.controls;
    }
}

