/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.logging.LogRecord;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javax.measure.Quantity;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.gui.coverage.ImagePropertyExplorer;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.RenderingData;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.MapCanvasAWT;
import org.apache.sis.gui.map.StatusBar;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.coverage.j2d.TileErrorHandler;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.processing.image.Isolines;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.Units;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

@DefaultProperty(value="coverage")
public class CoverageCanvas
extends MapCanvasAWT {
    private static final int OVERFLOW_SAFETY_MARGIN = 10000000;
    static final boolean TRACE = false;
    public final ObjectProperty<GridCoverage> coverageProperty;
    public final ObjectProperty<GridExtent> sliceExtentProperty;
    public final ObjectProperty<Interpolation> interpolationProperty;
    private RenderingData data = new RenderingData(report -> {
        this.errorReport = report.getDescription();
    });
    private final Map<Stretching, RenderedImage> derivedImages = new EnumMap<Stretching, RenderedImage>(Stretching.class);
    private RenderedImage resampledImage;
    private ImagePropertyExplorer propertyExplorer;
    StatusBar statusBar;
    private volatile LogRecord errorReport;
    private Reference<Resource> originator;
    IsolineRenderer isolines;

    public CoverageCanvas() {
        this(Locale.getDefault());
    }

    CoverageCanvas(Locale locale) {
        super(locale);
        this.coverageProperty = new SimpleObjectProperty((Object)this, "coverage");
        this.sliceExtentProperty = new SimpleObjectProperty((Object)this, "sliceExtent");
        this.interpolationProperty = new SimpleObjectProperty((Object)this, "interpolation", (Object)this.data.processor.getInterpolation());
        this.coverageProperty.addListener((observableValue, gridCoverage, gridCoverage2) -> this.onImageSpecified());
        this.sliceExtentProperty.addListener((observableValue, gridExtent, gridExtent2) -> this.onImageSpecified());
        this.interpolationProperty.addListener((observableValue, interpolation, interpolation2) -> this.onInterpolationSpecified((Interpolation)interpolation2));
        this.imageMargin.set((Object)new Insets(100.0));
    }

    final ImagePropertyExplorer createPropertyExplorer() {
        this.propertyExplorer = new ImagePropertyExplorer(this.getLocale(), (ObjectProperty<Background>)this.fixedPane.backgroundProperty());
        this.propertyExplorer.setImage(this.resampledImage, this.getVisibleImageBounds());
        return this.propertyExplorer;
    }

    final Region getView() {
        return this.fixedPane;
    }

    final void setOriginator(Reference<Resource> reference) {
        this.originator = reference;
    }

    public final GridCoverage getCoverage() {
        return (GridCoverage)this.coverageProperty.get();
    }

    public final void setCoverage(GridCoverage gridCoverage) {
        assert (Platform.isFxApplicationThread());
        this.coverageProperty.set((Object)gridCoverage);
    }

    public final GridExtent getSliceExtent() {
        return (GridExtent)this.sliceExtentProperty.get();
    }

    public final void setSliceExtent(GridExtent gridExtent) {
        assert (Platform.isFxApplicationThread());
        this.sliceExtentProperty.set((Object)gridExtent);
    }

    public final Interpolation getInterpolation() {
        return (Interpolation)this.interpolationProperty.get();
    }

    public final void setInterpolation(Interpolation interpolation) {
        assert (Platform.isFxApplicationThread());
        this.interpolationProperty.set((Object)interpolation);
    }

    final Function<Category, Color[]> getCategoryColors() {
        return this.data.processor.getCategoryColors();
    }

    final void setCategoryColors(Function<Category, Color[]> function) {
        this.data.processor.setCategoryColors(function);
        this.resampledImage = null;
        this.requestRepaint();
    }

    final void setBackground(javafx.scene.paint.Color color) {
        this.fixedPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectiveCRS(CoordinateReferenceSystem coordinateReferenceSystem, DirectPosition directPosition) throws RenderException {
        Long l = LogHandler.loadingStart(this.originator);
        try {
            super.setObjectiveCRS(coordinateReferenceSystem, directPosition);
        }
        finally {
            LogHandler.loadingStop(l);
        }
        this.clearIsolines();
    }

    @Override
    public void setGridGeometry(GridGeometry gridGeometry) throws RenderException {
        Long l = LogHandler.loadingStart(this.originator);
        try {
            super.setGridGeometry(gridGeometry);
        }
        finally {
            LogHandler.loadingStop(l);
        }
        this.clearIsolines();
    }

    private void onImageSpecified() {
        final GridCoverage gridCoverage = this.getCoverage();
        if (gridCoverage == null) {
            this.clear();
        } else {
            final GridExtent gridExtent = this.getSliceExtent();
            BackgroundThreads.execute((Runnable)new Task<RenderedImage>(){
                private GridGeometry imageGeometry;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected RenderedImage call() throws FactoryException {
                    Long l = LogHandler.loadingStart(CoverageCanvas.this.originator);
                    try {
                        RenderedImage renderedImage = gridCoverage.render(gridExtent);
                        Object object = renderedImage.getProperty("org.apache.sis.GridGeometry");
                        this.imageGeometry = object instanceof GridGeometry ? (GridGeometry)object : new ImageRenderer(gridCoverage, gridExtent).getImageGeometry(2);
                        RenderedImage renderedImage2 = renderedImage;
                        return renderedImage2;
                    }
                    finally {
                        LogHandler.loadingStop(l);
                    }
                }

                protected void failed() {
                    Throwable throwable = this.getException();
                    CoverageCanvas.this.errorOccurred(throwable);
                    ExceptionReporter.canNotUseResource((Node)CoverageCanvas.this.fixedPane, throwable);
                }

                protected void succeeded() {
                    CoverageCanvas.this.setRawImage((RenderedImage)this.getValue(), this.imageGeometry, gridCoverage.getSampleDimensions());
                }
            });
        }
    }

    private void setRawImage(RenderedImage renderedImage, GridGeometry gridGeometry, List<SampleDimension> list) {
        this.clearError();
        this.clearIsolines();
        this.resampledImage = null;
        this.derivedImages.clear();
        this.data.setImage(renderedImage, gridGeometry, list);
        Envelope envelope = null;
        if (gridGeometry != null && gridGeometry.isDefined(2)) {
            envelope = gridGeometry.getEnvelope();
        }
        this.setObjectiveBounds(envelope);
        this.requestRepaint();
    }

    private void clearIsolines() {
        if (this.isolines != null) {
            this.isolines.clear();
        }
    }

    private void onInterpolationSpecified(Interpolation interpolation) {
        this.data.processor.setInterpolation(interpolation);
        this.resampledImage = null;
        this.requestRepaint();
    }

    @Override
    protected MapCanvasAWT.Renderer createRenderer() {
        return this.data.isEmpty() ? null : new Worker(this);
    }

    private void cacheRenderingData(Worker worker) {
        Object object;
        this.data = worker.data;
        this.derivedImages.put(this.data.selectedDerivative, worker.recoloredImage);
        this.resampledImage = worker.resampledImage;
        if (this.propertyExplorer != null) {
            this.propertyExplorer.setImage(this.resampledImage, worker.getVisibleImageBounds());
        }
        if (this.statusBar != null) {
            object = this.resampledImage.getProperty("org.apache.sis.PositionalAccuracy");
            Quantity<Length> quantity = null;
            if (object instanceof Quantity[]) {
                for (Quantity quantity2 : (Quantity[])object) {
                    if (!Units.isLinear(quantity2.getUnit())) continue;
                    quantity = quantity2.asType(Length.class);
                    quantity = GUIUtilities.shorter(quantity, quantity.getUnit().getConverterTo(Units.METRE).convert(quantity.getValue().doubleValue()));
                    break;
                }
            }
            this.statusBar.setLowestAccuracy(quantity);
        }
        if ((object = this.errorReport) != null) {
            this.errorReport = null;
            this.errorOccurred(((LogRecord)object).getThrown());
        }
    }

    private Rectangle getVisibleImageBounds() {
        Envelope2D envelope2D = this.getDisplayBounds();
        if (envelope2D != null) {
            try {
                AffineTransform affineTransform = this.data.getTransform(this.getObjectiveToDisplay());
                return (Rectangle)AffineTransforms2D.inverseTransform((AffineTransform)affineTransform, (Rectangle2D)envelope2D, (Rectangle2D)new Rectangle());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                CoverageCanvas.unexpectedException(noninvertibleTransformException);
            }
        }
        return null;
    }

    private Rectangle2D getAreaOfInterest() throws TransformException {
        Envelope2D envelope2D = this.getDisplayBounds();
        if (envelope2D == null) {
            return null;
        }
        return Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.getObjectiveToDisplay().inverse()), (Rectangle2D)envelope2D, null);
    }

    final void setStyling(Stretching stretching) {
        if (this.data.selectedDerivative != stretching) {
            this.data.selectedDerivative = stretching;
            this.resampledImage = null;
            this.requestRepaint();
        }
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.gui"), CoverageCanvas.class, "render", exception);
    }

    @Override
    protected void clear() {
        this.setRawImage(null, null, null);
        super.clear();
    }

    private static void trace(String string, Object ... objectArray) {
    }

    public String toString() {
        if (!Platform.isFxApplicationThread()) {
            return super.toString();
        }
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder(1000);
        TableAppender tableAppender = new TableAppender(stringBuilder);
        tableAppender.setMultiLinesCells(true);
        try {
            Rectangle rectangle;
            tableAppender.nextLine('\u2550');
            this.getGridGeometry().getGeographicExtent().ifPresent(geographicBoundingBox -> tableAppender.append(String.format("Canvas geographic bounding box (\u03bb,\u0278):%nMax: % 10.5f\u00b0  % 10.5f\u00b0%nMin: % 10.5f\u00b0  % 10.5f\u00b0", geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getNorthBoundLatitude(), geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude())).appendHorizontalSeparator());
            Rectangle2D rectangle2D = this.getAreaOfInterest();
            DirectPosition directPosition = this.getPointOfInterest(true);
            if (rectangle2D != null && directPosition != null) {
                tableAppender.append(String.format("A/P of interest in objective CRS (x,y):%nMax: %, 16.4f  %, 16.4f%nPOI: %, 16.4f  %, 16.4f%nMin: %, 16.4f  %, 16.4f%n", rectangle2D.getMaxX(), rectangle2D.getMaxY(), directPosition.getOrdinate(0), directPosition.getOrdinate(1), rectangle2D.getMinX(), rectangle2D.getMinY())).appendHorizontalSeparator();
            }
            if ((rectangle = this.data.objectiveToData(rectangle2D)) != null) {
                tableAppender.append("Extent in source coverage:").append(string).append(String.valueOf(new GridExtent(rectangle))).append(string).nextLine();
            }
            tableAppender.nextLine('\u2550');
            tableAppender.flush();
        }
        catch (IOException | RenderException | TransformException throwable) {
            stringBuilder.append(throwable).append(string);
        }
        return stringBuilder.toString();
    }

    private static final class Worker
    extends MapCanvasAWT.Renderer {
        private final RenderingData data;
        private final CoordinateReferenceSystem objectiveCRS;
        private final LinearTransform objectiveToDisplay;
        private final Envelope2D displayBounds;
        private Rectangle2D objectiveAOI;
        private final DirectPosition objectivePOI;
        private RenderedImage recoloredImage;
        private RenderedImage resampledImage;
        private RenderedImage prefetchedImage;
        private AffineTransform resampledToDisplay;
        private final Reference<Resource> originator;
        private IsolineRenderer.Snapshot[] isolines;

        Worker(CoverageCanvas coverageCanvas) {
            Insets insets;
            this.originator = coverageCanvas.originator;
            this.data = coverageCanvas.data.clone();
            this.objectiveCRS = coverageCanvas.getObjectiveCRS();
            this.objectiveToDisplay = coverageCanvas.getObjectiveToDisplay();
            this.displayBounds = coverageCanvas.getDisplayBounds();
            this.objectivePOI = coverageCanvas.getPointOfInterest(true);
            this.recoloredImage = coverageCanvas.derivedImages.get((Object)this.data.selectedDerivative);
            if (this.data.validateCRS(this.objectiveCRS)) {
                this.resampledImage = coverageCanvas.resampledImage;
            }
            if ((insets = (Insets)coverageCanvas.imageMargin.get()) != null) {
                this.displayBounds.x -= insets.getLeft();
                this.displayBounds.width += insets.getLeft() + insets.getRight();
                this.displayBounds.y -= insets.getTop();
                this.displayBounds.height += insets.getTop() + insets.getBottom();
            }
            if (coverageCanvas.isolines != null) {
                try {
                    this.isolines = coverageCanvas.isolines.prepare();
                    this.objectiveAOI = Shapes2D.transform((MathTransform2D)MathTransforms.bidimensional((MathTransform)this.objectiveToDisplay.inverse()), (Rectangle2D)this.displayBounds, null);
                }
                catch (TransformException transformException) {
                    CoverageCanvas.unexpectedException((Exception)((Object)transformException));
                }
            }
        }

        final Rectangle getVisibleImageBounds() {
            try {
                return (Rectangle)AffineTransforms2D.inverseTransform((AffineTransform)this.resampledToDisplay, (Rectangle2D)this.displayBounds, (Rectangle2D)new Rectangle());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                CoverageCanvas.unexpectedException(noninvertibleTransformException);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void render() throws Exception {
            Long l = LogHandler.loadingStart(this.originator);
            try {
                boolean bl;
                boolean bl2 = bl = this.resampledImage != null;
                if (bl) {
                    this.resampledToDisplay = this.data.getTransform(this.objectiveToDisplay);
                    boolean bl3 = bl = (this.resampledToDisplay.getType() & 0xFFFFFFFE) == 0;
                    if (bl) {
                        boolean bl4 = bl = Math.max(Math.abs(this.resampledToDisplay.getTranslateX()), Math.abs(this.resampledToDisplay.getTranslateY())) < 2.137483647E9;
                    }
                }
                if (!bl) {
                    if (this.recoloredImage == null) {
                        this.recoloredImage = this.data.recolor();
                    }
                    this.resampledImage = this.data.resampleAndConvert(this.recoloredImage, this.objectiveCRS, this.objectiveToDisplay, this.objectivePOI);
                    this.resampledToDisplay = this.data.getTransform(this.objectiveToDisplay);
                }
                Future<Isolines[]> future = this.data.generate(this.isolines);
                this.prefetchedImage = this.data.prefetch(this.resampledImage, this.resampledToDisplay, this.displayBounds);
                if (future != null) {
                    IsolineRenderer.complete(this.isolines, future);
                }
            }
            finally {
                LogHandler.loadingStop(l);
            }
        }

        @Override
        protected void paint(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            if (this.prefetchedImage instanceof TileErrorHandler.Executor) {
                ((TileErrorHandler.Executor)this.prefetchedImage).execute(() -> graphics2D.drawRenderedImage(this.prefetchedImage, this.resampledToDisplay), new TileErrorHandler(this.data.processor.getErrorHandler(), CoverageCanvas.class, "paint"));
            } else {
                graphics2D.drawRenderedImage(this.prefetchedImage, this.resampledToDisplay);
            }
            if (this.isolines != null) {
                AffineTransform affineTransform = graphics2D.getTransform();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(this.data.getDataPixelSize(this.objectivePOI) / 8.0f));
                graphics2D.transform((AffineTransform)this.objectiveToDisplay);
                for (IsolineRenderer.Snapshot snapshot : this.isolines) {
                    snapshot.paint(graphics2D, this.objectiveAOI);
                }
                graphics2D.setTransform(affineTransform);
                graphics2D.setStroke(stroke);
            }
        }

        @Override
        protected boolean commit(MapCanvas mapCanvas) {
            ((CoverageCanvas)mapCanvas).cacheRenderingData(this);
            if (this.isolines != null) {
                for (IsolineRenderer.Snapshot snapshot : this.isolines) {
                    snapshot.commit();
                }
            }
            return super.commit(mapCanvas);
        }
    }
}

