/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.OptionalInt;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.internal.gui.RecentChoices;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.util.Numbers;

final class CellFormat
extends SimpleStringProperty {
    private static final String SYMBOL_NaN = "\u2b1a";
    private String classicFormatPattern;
    private final NumberFormat cellFormat = NumberFormat.getInstance();
    private final FieldPosition formatField = new FieldPosition(0);
    private final StringBuffer buffer = new StringBuffer();
    private double lastValue;
    private String lastValueAsText;
    boolean dataTypeisInteger;
    private boolean isAdjusting;

    CellFormat(GridView gridView) {
        super((Object)gridView, "cellFormatPattern");
        this.updatePropertyValue();
    }

    final boolean hasPattern() {
        return this.cellFormat instanceof DecimalFormat;
    }

    private void updatePropertyValue() {
        if (this.cellFormat instanceof DecimalFormat) {
            super.setValue(((DecimalFormat)this.cellFormat).toLocalizedPattern());
        }
    }

    public void setValue(String string) {
        if (this.cellFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.cellFormat).applyLocalizedPattern(string);
            this.updatePropertyValue();
            ((GridView)((Object)this.getBean())).contentChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPatternSelected(ComboBox<String> comboBox, String string) {
        if (!this.isAdjusting) {
            boolean bl;
            String string2;
            try {
                this.isAdjusting = true;
                this.setValue(string);
                string2 = null;
                bl = false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = illegalArgumentException.getLocalizedMessage();
                bl = true;
            }
            finally {
                this.isAdjusting = false;
            }
            Tooltip tooltip = null;
            if (string2 != null) {
                tooltip = comboBox.getTooltip();
                if (tooltip != null) {
                    tooltip.setText(string2);
                } else {
                    tooltip = new Tooltip(string2);
                    tooltip.setShowDelay(Duration.seconds((double)0.1));
                }
            }
            comboBox.setTooltip(tooltip);
            comboBox.getEditor().pseudoClassStateChanged(Styles.ERROR, bl);
        }
    }

    final ComboBox<String> createEditor() {
        if (!this.hasPattern()) {
            return null;
        }
        int n = this.cellFormat.getMinimumFractionDigits();
        int n2 = this.cellFormat.getMaximumFractionDigits();
        Object[] objectArray = new String[n2 + 2];
        objectArray[n2 + 1] = this.getValue();
        this.cellFormat.setMinimumFractionDigits(n2);
        for (int i = n2; i >= 0; --i) {
            this.cellFormat.setMaximumFractionDigits(i);
            objectArray[i] = ((DecimalFormat)this.cellFormat).toLocalizedPattern();
        }
        this.cellFormat.setMinimumFractionDigits(n);
        this.cellFormat.setMaximumFractionDigits(n2);
        ComboBox comboBox = new ComboBox();
        comboBox.setEditable(true);
        comboBox.getItems().setAll(objectArray);
        comboBox.getSelectionModel().selectFirst();
        comboBox.getSelectionModel().selectedItemProperty().addListener((observableValue, string, string2) -> this.onPatternSelected((ComboBox<String>)comboBox, (String)string2));
        this.addListener((observableValue, string, string2) -> RecentChoices.setInList(comboBox, string2));
        return comboBox;
    }

    final void configure(RenderedImage renderedImage, int n) {
        if (this.dataTypeisInteger) {
            this.cellFormat.setMaximumFractionDigits(0);
        } else {
            int n2 = CellFormat.getFractionDigits(renderedImage, n).orElse(1);
            if (n2 > 6 || n2 < -9) {
                if (this.cellFormat instanceof DecimalFormat) {
                    if (this.classicFormatPattern == null) {
                        DecimalFormat decimalFormat = (DecimalFormat)this.cellFormat;
                        this.classicFormatPattern = decimalFormat.toPattern();
                        decimalFormat.applyPattern("0.000E00");
                    }
                    n2 = 3;
                }
            } else if (this.classicFormatPattern != null) {
                ((DecimalFormat)this.cellFormat).applyPattern(this.classicFormatPattern);
                this.classicFormatPattern = null;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.cellFormat.setMinimumFractionDigits(n2);
            this.cellFormat.setMaximumFractionDigits(n2);
        }
        this.buffer.setLength(0);
        this.formatCell(this.lastValue);
        this.updatePropertyValue();
    }

    private static OptionalInt getFractionDigits(RenderedImage renderedImage, int n) {
        double d;
        Object object = renderedImage.getProperty("org.apache.sis.SampleResolution");
        if (object != null && Numbers.isNumber(object.getClass().getComponentType()) && n < Array.getLength(object) && (d = Math.abs(((Number)Array.get(object, n)).doubleValue())) > 0.0 && d <= Double.MAX_VALUE) {
            return OptionalInt.of(DecimalFunctions.fractionDigitsForDelta(d, false));
        }
        return OptionalInt.empty();
    }

    final String format(Raster raster, int n, int n2, int n3) {
        this.buffer.setLength(0);
        if (this.dataTypeisInteger) {
            int n4 = raster.getSample(n, n2, n3);
            double d = n4;
            if (Double.doubleToRawLongBits(d) != Double.doubleToRawLongBits(this.lastValue)) {
                this.lastValueAsText = this.cellFormat.format(n4, this.buffer, this.formatField).toString();
                this.lastValue = d;
            }
        } else {
            double d = raster.getSampleDouble(n, n2, n3);
            if (Double.doubleToRawLongBits(d) != Double.doubleToRawLongBits(this.lastValue)) {
                this.formatCell(d);
                this.lastValue = d;
            }
        }
        return this.lastValueAsText;
    }

    private void formatCell(double d) {
        this.lastValueAsText = Double.isNaN(d) ? SYMBOL_NaN : this.cellFormat.format(d, this.buffer, this.formatField).toString();
    }

    final String format(Number number) {
        this.buffer.setLength(0);
        return this.cellFormat.format(number, this.buffer, this.formatField).toString();
    }

    final String format(NumberFormat numberFormat, long l) {
        this.buffer.setLength(0);
        return numberFormat.format(l, this.buffer, this.formatField).toString();
    }
}

