/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Optional;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.gui.coverage.CellFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.GenericName;

final class BandRangeTable
implements Callback<TableColumn<SampleDimension, Number>, TableCell<SampleDimension, Number>> {
    private static final String NAME = "name";
    private static final String MINIMUM = "minimum";
    private static final String MAXIMUM = "maximum";
    private static final String UNITS = "units";
    private static final int NUM_VISIBLE_ROW = 5;
    private final CellFormat cellFormat;

    BandRangeTable(CellFormat cellFormat) {
        this.cellFormat = cellFormat;
    }

    TableView<SampleDimension> create(Vocabulary vocabulary) {
        TableView tableView = new TableView();
        tableView.setPrefHeight(150.0);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableView.getColumns().setAll((Object[])new TableColumn[]{BandRangeTable.createStringColumn(vocabulary, (short)139, NAME), this.createNumberColumn(vocabulary, (short)133, MINIMUM), this.createNumberColumn(vocabulary, (short)127, MAXIMUM), BandRangeTable.createStringColumn(vocabulary, (short)206, UNITS)});
        return tableView;
    }

    private static TableColumn<SampleDimension, String> createStringColumn(Vocabulary vocabulary, short s, String string) {
        TableColumn tableColumn = new TableColumn(vocabulary.getString(s));
        tableColumn.setCellValueFactory(BandRangeTable::getStringValue);
        tableColumn.setId(string);
        return tableColumn;
    }

    private TableColumn<SampleDimension, Number> createNumberColumn(Vocabulary vocabulary, short s, String string) {
        TableColumn tableColumn = new TableColumn(vocabulary.getString(s));
        tableColumn.setCellValueFactory(this::getNumberValue);
        tableColumn.setCellFactory((Callback)this);
        tableColumn.setId(string);
        return tableColumn;
    }

    public TableCell<SampleDimension, Number> call(TableColumn<SampleDimension, Number> tableColumn) {
        return new Numeric(this.cellFormat);
    }

    private static ObservableValue<String> getStringValue(TableColumn.CellDataFeatures<SampleDimension, String> cellDataFeatures) {
        Optional<GenericName> optional;
        SampleDimension sampleDimension = (SampleDimension)cellDataFeatures.getValue();
        switch (cellDataFeatures.getTableColumn().getId()) {
            case "name": {
                optional = Optional.ofNullable(sampleDimension.getName());
                break;
            }
            case "units": {
                optional = sampleDimension.getUnits();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return optional.map(Object::toString).map(ReadOnlyObjectWrapper::new).orElse(null);
    }

    private ObservableValue<Number> getNumberValue(TableColumn.CellDataFeatures<SampleDimension, Number> cellDataFeatures) {
        Optional<Number> optional;
        Optional optional2 = ((SampleDimension)cellDataFeatures.getValue()).getSampleRange();
        switch (cellDataFeatures.getTableColumn().getId()) {
            case "minimum": {
                optional = optional2.map(Range::getMinValue);
                break;
            }
            case "maximum": {
                optional = optional2.map(Range::getMaxValue);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return optional.map(ReadOnlyObjectWrapper::new).orElse(null);
    }

    private static final class Numeric
    extends TableCell<SampleDimension, Number> {
        private final CellFormat cellFormat;

        Numeric(CellFormat cellFormat) {
            this.cellFormat = cellFormat;
            this.setAlignment(Pos.CENTER_RIGHT);
        }

        public void updateItem(Number number, boolean bl) {
            this.setText(bl || number == null ? "" : this.cellFormat.format(number));
        }
    }
}

