/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml.stream;

import javax.xml.bind.JAXBException;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.apache.sis.internal.storage.xml.stream.StaxDataStoreProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.MarshallerPool;

abstract class StaxStreamIO
implements AutoCloseable {
    protected final StaxDataStore owner;
    AutoCloseable stream;
    private MarshallerPool jaxb;

    StaxStreamIO(StaxDataStore staxDataStore) {
        ArgumentChecks.ensureNonNull("owner", (Object)staxDataStore);
        this.owner = staxDataStore;
    }

    final MarshallerPool getMarshallerPool() throws JAXBException {
        if (this.jaxb == null) {
            StaxDataStoreProvider staxDataStoreProvider = this.owner.getProvider();
            if (staxDataStoreProvider != null) {
                this.jaxb = staxDataStoreProvider.getMarshallerPool();
            }
            if (this.jaxb == null) {
                throw new JAXBException(this.errors().getString((short)86));
            }
        }
        return this.jaxb;
    }

    @Override
    public void close() throws Exception {
        AutoCloseable autoCloseable = this.stream;
        this.stream = null;
        if (autoCloseable != null && this.owner.canClose(autoCloseable)) {
            autoCloseable.close();
        }
    }

    protected final Errors errors() {
        return Errors.getResources(this.owner.getLocale());
    }
}

