/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

enum Type {
    UNDEFINED(7, 1, false){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            throw new UnsupportedOperationException(this.name());
        }
    }
    ,
    BYTE(6, 1, false){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readByte();
            for (long i = 1L; i < l; ++i) {
                2.ensureSingleton(l2, channelDataInput.readByte(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readBytes(n);
        }
    }
    ,
    UBYTE(1, 1, true){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readUnsignedByte();
            for (long i = 1L; i < l; ++i) {
                3.ensureSingleton(l2, channelDataInput.readUnsignedByte(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readBytes(n);
        }
    }
    ,
    SHORT(8, 2, false){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readShort();
            for (long i = 1L; i < l; ++i) {
                4.ensureSingleton(l2, channelDataInput.readShort(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readShorts(n);
        }
    }
    ,
    USHORT(3, 2, true){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readUnsignedShort();
            for (long i = 1L; i < l; ++i) {
                5.ensureSingleton(l2, channelDataInput.readUnsignedShort(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readShorts(n);
        }
    }
    ,
    INT(9, 4, false){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readInt();
            for (long i = 1L; i < l; ++i) {
                6.ensureSingleton(l2, channelDataInput.readInt(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readInts(n);
        }
    }
    ,
    UINT(4, 4, true){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readUnsignedInt();
            for (long i = 1L; i < l; ++i) {
                7.ensureSingleton(l2, channelDataInput.readUnsignedInt(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readInts(n);
        }
    }
    ,
    LONG(17, 8, false){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readLong();
            for (long i = 1L; i < l; ++i) {
                8.ensureSingleton(l2, channelDataInput.readLong(), l);
            }
            return l2;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readLongs(n);
        }
    }
    ,
    ULONG(16, 8, true){

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            long l2 = channelDataInput.readLong();
            for (long i = 1L; i < l; ++i) {
                9.ensureSingleton(l2, channelDataInput.readLong(), l);
            }
            if (l2 >= 0L) {
                return l2;
            }
            throw new ArithmeticException(this.canNotConvert(Long.toUnsignedString(l2)));
        }

        @Override
        public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
            return Numerics.toUnsignedDouble((long)this.readLong(channelDataInput, l));
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readLongs(n);
        }
    }
    ,
    FLOAT(11, 4, false){

        private float readFloat(ChannelDataInput channelDataInput, long l) throws IOException {
            float f = channelDataInput.readFloat();
            for (long i = 1L; i < l; ++i) {
                10.ensureSingleton(f, channelDataInput.readFloat(), l);
            }
            return f;
        }

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            float f = this.readFloat(channelDataInput, l);
            long l2 = (long)f;
            if ((float)l2 == f) {
                return l2;
            }
            throw new ArithmeticException(this.canNotConvert(Float.toString(f)));
        }

        @Override
        public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
            return DecimalFunctions.floatToDouble((float)this.readFloat(channelDataInput, l));
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readFloats(n);
        }
    }
    ,
    DOUBLE(12, 8, false){

        @Override
        public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
            double d = channelDataInput.readDouble();
            for (long i = 1L; i < l; ++i) {
                11.ensureSingleton(d, channelDataInput.readDouble(), l);
            }
            return d;
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return channelDataInput.readDoubles(n);
        }
    }
    ,
    RATIONAL(10, 8, false){

        @Override
        public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
            double d = (double)channelDataInput.readInt() / (double)channelDataInput.readInt();
            for (long i = 1L; i < l; ++i) {
                12.ensureSingleton(d, (double)channelDataInput.readInt() / (double)channelDataInput.readInt(), l);
            }
            return d;
        }
    }
    ,
    URATIONAL(5, 8, true){

        @Override
        public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
            double d = (double)channelDataInput.readUnsignedInt() / (double)channelDataInput.readUnsignedInt();
            for (long i = 1L; i < l; ++i) {
                13.ensureSingleton(d, (double)channelDataInput.readUnsignedInt() / (double)channelDataInput.readUnsignedInt(), l);
            }
            return d;
        }
    }
    ,
    ASCII(2, 1, false){

        @Override
        public String[] readString(ChannelDataInput channelDataInput, long l, Charset charset) throws IOException {
            byte[] byArray = channelDataInput.readBytes(Math.toIntExact(l));
            Object[] objectArray = new String[1];
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                if (n >= objectArray.length) {
                    objectArray = (String[])Arrays.copyOf(objectArray, 2 * n);
                }
                objectArray[n++] = new String(byArray, n2, i - n2, charset);
            }
            return (String[])ArraysExt.resize((Object[])objectArray, (int)n);
        }

        private String readString(ChannelDataInput channelDataInput, long l) throws IOException {
            String[] stringArray = this.readString(channelDataInput, l, StandardCharsets.US_ASCII);
            String string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                if (string.equals(stringArray[i])) continue;
                throw new IllegalArgumentException(Errors.format((short)133, (Object)1, (Object)l));
            }
            return string;
        }

        @Override
        public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
            return Long.parseLong(this.readString(channelDataInput, l));
        }

        @Override
        public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
            return Double.parseDouble(this.readString(channelDataInput, l));
        }

        @Override
        public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
            return this.readString(channelDataInput, n, StandardCharsets.US_ASCII);
        }
    };

    final int code;
    final int size;
    final boolean isUnsigned;
    private static final Type[] FROM_CODES;

    private Type(int n2, int n3, boolean bl) {
        this.code = n2;
        this.size = n3;
        this.isUnsigned = bl;
    }

    static Type valueOf(int n) {
        return n >= 0 && n < FROM_CODES.length ? FROM_CODES[n] : null;
    }

    static String toString(long l, long l2) {
        return "" + l + '/' + l2;
    }

    static void ensureSingleton(long l, long l2, long l3) {
        if (l != l2) {
            throw new IllegalArgumentException(Errors.format((short)133, (Object)1, (Object)l3));
        }
    }

    static void ensureSingleton(double d, double d2, long l) {
        if (Double.doubleToLongBits(d) != Double.doubleToLongBits(d2)) {
            throw new IllegalArgumentException(Errors.format((short)133, (Object)1, (Object)l));
        }
    }

    final String canNotConvert(String string) {
        return Errors.format((short)8, (Object)string, (Object)this.name());
    }

    public final short readShort(ChannelDataInput channelDataInput, long l) throws IOException {
        long l2 = this.readLong(channelDataInput, l);
        if (l2 >= -32768L && l2 <= 32767L) {
            return (short)l2;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toString(l2)));
    }

    public final int readInt(ChannelDataInput channelDataInput, long l) throws IOException {
        long l2 = this.readLong(channelDataInput, l);
        if (l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
            return (int)l2;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toString(l2)));
    }

    public final long readUnsignedLong(ChannelDataInput channelDataInput, long l) throws IOException {
        long l2 = this.readLong(channelDataInput, l);
        if (l2 >= 0L) {
            return l2;
        }
        throw new ArithmeticException(this.canNotConvert(Long.toUnsignedString(l2)));
    }

    public long readLong(ChannelDataInput channelDataInput, long l) throws IOException {
        double d = this.readDouble(channelDataInput, l);
        long l2 = (long)d;
        if ((double)l2 == d) {
            return l2;
        }
        throw new ArithmeticException(this.canNotConvert(Double.toString(d)));
    }

    public double readDouble(ChannelDataInput channelDataInput, long l) throws IOException {
        return this.readLong(channelDataInput, l);
    }

    public String[] readString(ChannelDataInput channelDataInput, long l, Charset charset) throws IOException {
        String[] stringArray = new String[Math.toIntExact(l)];
        for (int i = 0; i < stringArray.length; ++i) {
            double d = this.readDouble(channelDataInput, 1L);
            long l2 = (long)d;
            stringArray[i] = (double)l2 == d ? String.valueOf(l2) : String.valueOf(d);
        }
        return stringArray;
    }

    public Object readArray(ChannelDataInput channelDataInput, int n) throws IOException {
        throw new UnsupportedOperationException(this.name());
    }

    public final Vector readVector(ChannelDataInput channelDataInput, long l) throws IOException {
        return Vector.create((Object)this.readArray(channelDataInput, Math.toIntExact(l)), (boolean)this.isUnsigned);
    }

    static {
        FROM_CODES = new Type[19];
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        for (int i = 0; i < n; ++i) {
            Type type;
            Type.FROM_CODES[type.code] = type = typeArray[i];
        }
        Type.FROM_CODES[13] = UINT;
        Type.FROM_CODES[18] = ULONG;
    }
}

