/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.util.Version;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="GeoTIFF", fileSuffixes={"tiff", "tif"}, capabilities={Capability.READ})
public class GeoTiffStoreProvider
extends DataStoreProvider {
    private static final String MIME_TYPE = "image/tiff";
    private static final Version VERSION = new Version("6.0");
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor("GeoTIFF");

    @Override
    public String getShortName() {
        return "GeoTIFF";
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        boolean bl;
        ByteBuffer byteBuffer = storageConnector.getStorageAs(ByteBuffer.class);
        if (byteBuffer == null) return ProbeResult.UNSUPPORTED_STORAGE;
        if (byteBuffer.remaining() < 4) {
            return ProbeResult.INSUFFICIENT_BYTES;
        }
        int n = byteBuffer.position();
        short s = byteBuffer.getShort(n);
        boolean bl2 = bl = s == 19789;
        if (!bl) {
            if (s != 18761) return ProbeResult.UNSUPPORTED_STORAGE;
        }
        ByteOrder byteOrder = byteBuffer.order();
        try {
            byteBuffer.order(bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            switch (byteBuffer.getShort(n + 2)) {
                case 42: 
                case 43: {
                    ProbeResult probeResult = new ProbeResult(true, MIME_TYPE, VERSION);
                    return probeResult;
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
        finally {
            byteBuffer.order(byteOrder);
        }
    }

    @Override
    public DataStore open(StorageConnector storageConnector) throws DataStoreException {
        return new GeoTiffStore(this, storageConnector);
    }
}

