/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.util.Arrays;
import java.util.Locale;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.RasterFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.TiledGridCoverage;
import org.apache.sis.internal.storage.TiledGridResource;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.HyperRectangleReader;
import org.apache.sis.internal.storage.io.Region;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.ReversedBitsChannel;
import org.apache.sis.util.Localized;

class DataSubset
extends TiledGridCoverage
implements Localized {
    final DataCube source;
    private final Vector tileOffsets;
    private final Vector tileByteCounts;
    private final int numTiles;
    protected final int numBanks;
    protected final int sourcePixelStride;
    protected final int targetPixelStride;
    private static final Closeable NOOP = () -> {};

    DataSubset(DataCube dataCube, TiledGridResource.Subset subset) throws DataStoreException {
        super(subset);
        int n;
        this.source = dataCube;
        this.numTiles = Math.toIntExact(dataCube.getNumTiles());
        Vector[] vectorArray = dataCube.getTileArrayInfo();
        this.tileOffsets = vectorArray[0];
        this.tileByteCounts = vectorArray[1];
        if (this.model instanceof BandedSampleModel) {
            this.numBanks = this.model.getNumBands();
            this.targetPixelStride = 1;
            this.sourcePixelStride = 1;
            n = this.includedBands != null ? this.includedBands[this.includedBands.length - 1] : this.numBanks - 1;
        } else {
            n = 0;
            this.numBanks = 1;
            this.sourcePixelStride = dataCube.getNumBands();
            this.targetPixelStride = this.model.getNumBands();
        }
        int n2 = this.tileOffsets.size();
        if (n >= n2 / this.numTiles) {
            throw new DataStoreContentException(dataCube.reader.errors().getString((short)74, (Object)"tileOffsets", (Object)((n + 1) * this.numTiles), (Object)n2));
        }
    }

    @Override
    public final Locale getLocale() {
        return this.source.getLocale();
    }

    @Override
    protected final String getDisplayName() {
        return this.source.filename();
    }

    protected final DataType getDataType() {
        return DataType.forDataBufferType(this.model.getDataType());
    }

    protected final int getBankCapacity(int n) {
        int n2 = Numerics.ceilDiv((int)Math.multiplyExact(this.model.getWidth(), this.targetPixelStride), (int)n);
        return Math.multiplyExact(n2, this.model.getHeight());
    }

    final ChannelDataInput input() throws IOException {
        ChannelDataInput channelDataInput = this.source.reader.input;
        if (this.source.isBitOrderReversed()) {
            channelDataInput = ReversedBitsChannel.wrap(channelDataInput);
        }
        return channelDataInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final WritableRaster[] readTiles(TiledGridCoverage.AOI aOI) throws IOException, DataStoreException {
        int[] nArray = this.sourcePixelStride == 1 ? this.includedBands : null;
        WritableRaster[] writableRasterArray = new WritableRaster[aOI.tileCountInQuery];
        Object[] objectArray = new Tile[aOI.tileCountInQuery];
        int n = 0;
        boolean bl = false;
        DataStore dataStore = this.source.getSynchronizationLock();
        synchronized (dataStore) {
            WritableRaster[] writableRasterArray2;
            do {
                if ((writableRasterArray2 = aOI.getCachedTile()) != null) {
                    writableRasterArray[aOI.getIndexInResultArray()] = writableRasterArray2;
                    continue;
                }
                objectArray[n++] = new Tile(aOI, this.tileOffsets, nArray, this.numTiles);
            } while (aOI.next());
            if (n != 0) {
                Arrays.sort(objectArray, 0, n);
                writableRasterArray2 = (WritableRaster[])new long[2];
                long[] lArray = new long[2];
                int[] nArray2 = new int[2];
                Point object = new Point();
                long[] lArray2 = new long[this.numBanks];
                long[] lArray3 = new long[this.numBanks];
                try (Closeable closeable = this.createInflater();){
                    for (int i = 0; i < n; ++i) {
                        Object object2 = objectArray[i];
                        if (((TiledGridCoverage.Snapshot)object2).getRegionInsideTile((long[])writableRasterArray2, lArray, nArray2, 2)) {
                            object.x = ((Tile)object2).originX;
                            object.y = ((Tile)object2).originY;
                            ((Tile)object2).copyTileInfo(this.tileOffsets, lArray2, nArray, this.numTiles);
                            ((Tile)object2).copyTileInfo(this.tileByteCounts, lArray3, nArray, this.numTiles);
                            for (int j = 0; j < lArray2.length; ++j) {
                                lArray2[j] = Math.addExact(lArray2[j], this.source.reader.origin);
                            }
                            WritableRaster writableRaster = this.readSlice(lArray2, lArray3, (long[])writableRasterArray2, lArray, nArray2, object);
                            writableRasterArray[((Tile)object2).indexInResultArray] = ((TiledGridCoverage.Snapshot)object2).cache(writableRaster);
                            continue;
                        }
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            int n2 = 0;
            for (WritableRaster writableRaster : writableRasterArray) {
                if (writableRaster == null) continue;
                writableRasterArray[n2++] = writableRaster;
            }
            return Arrays.copyOf(writableRasterArray, n2);
        }
        return writableRasterArray;
    }

    Closeable createInflater() {
        return NOOP;
    }

    WritableRaster readSlice(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int[] nArray, Point point) throws IOException, DataStoreException {
        DataType dataType = this.getDataType();
        int n = dataType.size();
        long l = Math.subtractExact(lArray4[0], lArray3[0]);
        long l2 = Math.subtractExact(lArray4[1], lArray3[1]);
        long l3 = Numerics.ceilDiv((long)(l * l2 * (long)this.sourcePixelStride * (long)n), (long)8L);
        long[] lArray5 = new long[]{JDK9.multiplyFull((int)this.sourcePixelStride, (int)this.getTileSize(0)), this.getTileSize(1)};
        assert (this.sourcePixelStride == 1 || nArray[0] == 1);
        lArray3[0] = lArray3[0] * (long)this.sourcePixelStride;
        lArray4[0] = lArray4[0] * (long)this.sourcePixelStride;
        HyperRectangleReader hyperRectangleReader = new HyperRectangleReader(ImageUtilities.toNumberEnum(dataType.toDataBufferType()), this.input());
        Region region = new Region(lArray5, lArray3, lArray4, nArray);
        Buffer[] bufferArray = new Buffer[this.numBanks];
        for (int i = 0; i < this.numBanks; ++i) {
            if (i < lArray2.length && l3 > lArray2[i]) {
                throw new DataStoreContentException(this.source.reader.resources().getString((short)28, l3, lArray2[i]));
            }
            hyperRectangleReader.setOrigin(lArray[i]);
            assert (this.model.getSampleSize(i) == n);
            Buffer buffer = hyperRectangleReader.readAsBuffer(region, this.getBankCapacity(1));
            this.fillRemainingRows(buffer);
            bufferArray[i] = buffer;
        }
        DataBuffer dataBuffer = RasterFactory.wrap(dataType, bufferArray);
        return WritableRaster.createWritableRaster(this.model, dataBuffer, point);
    }

    final void fillRemainingRows(Buffer buffer) {
        int n;
        int n2;
        if (this.fillValue != null && (n2 = buffer.limit()) != (n = buffer.capacity())) {
            Vector.create((Object)buffer.limit(n), (boolean)ImageUtilities.isUnsignedType(this.model)).fill(n2, n, this.fillValue);
            buffer.limit(n);
        }
    }

    private static final class Tile
    extends TiledGridCoverage.Snapshot
    implements Comparable<Tile> {
        private final long byteOffset;

        Tile(TiledGridCoverage.AOI aOI, Vector vector, int[] nArray, int n) {
            super(aOI);
            int n2 = this.indexInTileVector;
            if (nArray != null) {
                n2 += nArray[0] * n;
            }
            this.byteOffset = vector.longValue(n2);
        }

        final void copyTileInfo(Vector vector, long[] lArray, int[] nArray, int n) {
            for (int i = 0; i < lArray.length; ++i) {
                int n2 = this.indexInTileVector + n * (nArray != null ? nArray[i] : i);
                lArray[i] = vector.longValue(n2);
            }
        }

        @Override
        public int compareTo(Tile tile) {
            return Long.compare(this.byteOffset, tile.byteOffset);
        }
    }
}

