/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.inflater.PredictorChannel;

abstract class HorizontalPredictor
extends PredictorChannel {
    private final int sampleSizeM1;
    protected final int pixelStride;
    private final int scanlineStride;
    private int column;

    HorizontalPredictor(CompressionChannel compressionChannel, int n, int n2, int n3) {
        super(compressionChannel);
        this.sampleSizeM1 = n3 - 1;
        this.pixelStride = n * n3;
        this.scanlineStride = Math.multiplyExact(n2, this.pixelStride);
    }

    static HorizontalPredictor create(CompressionChannel compressionChannel, DataType dataType, int n, int n2) {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return new Shorts(compressionChannel, n, n2);
            }
            case BYTE: {
                return new Bytes(compressionChannel, n, n2);
            }
            case INT: {
                return new Integers(compressionChannel, n, n2);
            }
            case FLOAT: {
                return new Floats(compressionChannel, n, n2);
            }
            case DOUBLE: {
                return new Doubles(compressionChannel, n, n2);
            }
        }
        return null;
    }

    @Override
    public void setInput(long l, long l2) throws IOException {
        super.setInput(l, l2);
        this.column = 0;
    }

    @Override
    protected int uncompress(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3 = byteBuffer.position() - this.sampleSizeM1;
        int n4 = n;
        while (n4 < n3) {
            n2 = n4;
            int n5 = Math.min(n4 + (this.scanlineStride - this.column), n3);
            int n6 = Math.min(n4 + this.pixelStride, n5);
            if (this.column < this.pixelStride) {
                n4 += Math.min(this.pixelStride - this.column, n5 - n4);
            }
            n4 = this.applyOnRow(byteBuffer, n2, n4, n6, n5);
            this.column += n4 - n2;
            if (this.column < this.scanlineStride) continue;
            this.column = 0;
        }
        n2 = n4 - n;
        if (n2 >= this.pixelStride) {
            this.saveLastPixel(byteBuffer, n4 - this.pixelStride);
        } else {
            this.saveLastPixel(byteBuffer, this.pixelStride - n2, n, n2);
        }
        return n4;
    }

    abstract int applyOnRow(ByteBuffer var1, int var2, int var3, int var4, int var5);

    abstract void saveLastPixel(ByteBuffer var1, int var2);

    abstract void saveLastPixel(ByteBuffer var1, int var2, int var3, int var4);

    private static final class Shorts
    extends HorizontalPredictor {
        private final short[] previousColumns;

        Shorts(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 2);
            this.previousColumns = new short[n];
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
            while (n2 < n3) {
                byteBuffer.putShort(n2, (short)(byteBuffer.getShort(n2) + this.previousColumns[n2 - n]));
                n2 += 2;
            }
            while (n2 < n4) {
                byteBuffer.putShort(n2, (short)(byteBuffer.getShort(n2) + byteBuffer.getShort(n2 - this.pixelStride)));
                n2 += 2;
            }
            return n2;
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n) {
            for (int i = 0; i < this.previousColumns.length; ++i) {
                this.previousColumns[i] = byteBuffer.getShort(n);
                n += 2;
            }
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2, int n3) {
            System.arraycopy(this.previousColumns, n /= 2, this.previousColumns, 0, n3 /= 2);
            n3 += n;
            while (n < n3) {
                this.previousColumns[n++] = byteBuffer.get(n2);
                n2 += 2;
            }
        }
    }

    private static final class Bytes
    extends HorizontalPredictor {
        private final byte[] previousColumns;

        Bytes(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 1);
            this.previousColumns = new byte[n];
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
            while (n2 < n3) {
                byteBuffer.put(n2, (byte)(byteBuffer.get(n2) + this.previousColumns[n2 - n]));
                ++n2;
            }
            while (n2 < n4) {
                byteBuffer.put(n2, (byte)(byteBuffer.get(n2) + byteBuffer.get(n2 - this.pixelStride)));
                ++n2;
            }
            return n2;
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n) {
            JDK9.get((ByteBuffer)byteBuffer, (int)n, (byte[])this.previousColumns);
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2, int n3) {
            System.arraycopy(this.previousColumns, n, this.previousColumns, 0, n3);
            JDK9.get((ByteBuffer)byteBuffer, (int)n2, (byte[])this.previousColumns, (int)n, (int)n3);
        }
    }

    private static final class Integers
    extends HorizontalPredictor {
        private final int[] previousColumns;

        Integers(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 4);
            this.previousColumns = new int[n];
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
            while (n2 < n3) {
                byteBuffer.putInt(n2, byteBuffer.getInt(n2) + this.previousColumns[n2 - n]);
                n2 += 4;
            }
            while (n2 < n4) {
                byteBuffer.putInt(n2, byteBuffer.getInt(n2) + byteBuffer.getInt(n2 - this.pixelStride));
                n2 += 4;
            }
            return n2;
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n) {
            for (int i = 0; i < this.previousColumns.length; ++i) {
                this.previousColumns[i] = byteBuffer.getInt(n);
                n += 4;
            }
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2, int n3) {
            System.arraycopy(this.previousColumns, n /= 4, this.previousColumns, 0, n3 /= 4);
            n3 += n;
            while (n < n3) {
                this.previousColumns[n++] = byteBuffer.get(n2);
                n2 += 4;
            }
        }
    }

    private static final class Floats
    extends HorizontalPredictor {
        private final float[] previousColumns;

        Floats(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 4);
            this.previousColumns = new float[n];
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
            while (n2 < n3) {
                byteBuffer.putFloat(n2, byteBuffer.getFloat(n2) + this.previousColumns[n2 - n]);
                n2 += 4;
            }
            while (n2 < n4) {
                byteBuffer.putFloat(n2, byteBuffer.getFloat(n2) + byteBuffer.getFloat(n2 - this.pixelStride));
                n2 += 4;
            }
            return n2;
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n) {
            for (int i = 0; i < this.previousColumns.length; ++i) {
                this.previousColumns[i] = byteBuffer.getFloat(n);
                n += 4;
            }
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2, int n3) {
            System.arraycopy(this.previousColumns, n /= 4, this.previousColumns, 0, n3 /= 4);
            n3 += n;
            while (n < n3) {
                this.previousColumns[n++] = byteBuffer.get(n2);
                n2 += 4;
            }
        }
    }

    private static final class Doubles
    extends HorizontalPredictor {
        private final double[] previousColumns;

        Doubles(CompressionChannel compressionChannel, int n, int n2) {
            super(compressionChannel, n, n2, 8);
            this.previousColumns = new double[n];
        }

        @Override
        int applyOnRow(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
            while (n2 < n3) {
                byteBuffer.putDouble(n2, byteBuffer.getDouble(n2) + this.previousColumns[n2 - n]);
                n2 += 8;
            }
            while (n2 < n4) {
                byteBuffer.putDouble(n2, byteBuffer.getDouble(n2) + byteBuffer.getDouble(n2 - this.pixelStride));
                n2 += 8;
            }
            return n2;
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n) {
            for (int i = 0; i < this.previousColumns.length; ++i) {
                this.previousColumns[i] = byteBuffer.getDouble(n);
                n += 8;
            }
        }

        @Override
        void saveLastPixel(ByteBuffer byteBuffer, int n, int n2, int n3) {
            System.arraycopy(this.previousColumns, n /= 8, this.previousColumns, 0, n3 /= 8);
            n3 += n;
            while (n < n3) {
                this.previousColumns[n++] = byteBuffer.get(n2);
                n2 += 8;
            }
        }
    }
}

