/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

abstract class Observable {
    private Map<String, PropertyChangeListener[]> listeners;

    Observable() {
    }

    public final void addPropertyChangeListener(String string2, PropertyChangeListener propertyChangeListener) {
        ArgumentChecks.ensureNonEmpty("propertyName", string2);
        ArgumentChecks.ensureNonNull("listener", propertyChangeListener);
        if (this.listeners == null) {
            this.listeners = new HashMap<String, PropertyChangeListener[]>(4);
        }
        this.listeners.compute(string2, (string, propertyChangeListenerArray) -> {
            PropertyChangeListener[] propertyChangeListenerArray2;
            if (propertyChangeListenerArray != null) {
                propertyChangeListenerArray2 = ArraysExt.append(propertyChangeListenerArray, propertyChangeListener);
            } else {
                PropertyChangeListener[] propertyChangeListenerArray3 = new PropertyChangeListener[1];
                propertyChangeListenerArray2 = propertyChangeListenerArray3;
                propertyChangeListenerArray3[0] = propertyChangeListener;
            }
            return propertyChangeListenerArray2;
        });
    }

    public final void removePropertyChangeListener(String string2, PropertyChangeListener propertyChangeListener) {
        ArgumentChecks.ensureNonEmpty("propertyName", string2);
        ArgumentChecks.ensureNonNull("listener", propertyChangeListener);
        if (this.listeners != null) {
            this.listeners.computeIfPresent(string2, (string, propertyChangeListenerArray) -> {
                int n = ((PropertyChangeListener[])propertyChangeListenerArray).length;
                while (--n >= 0) {
                    if (propertyChangeListenerArray[n] != propertyChangeListener) continue;
                    if (((PropertyChangeListener[])propertyChangeListenerArray).length != 1) {
                        return ArraysExt.remove(propertyChangeListenerArray, n, 1);
                    }
                    return null;
                }
                return propertyChangeListenerArray;
            });
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (this.listeners != null && (propertyChangeListenerArray = this.listeners.get(string)) != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener[] propertyChangeListenerArray;
        ArgumentChecks.ensureNonNull("event", propertyChangeEvent);
        if (this.listeners != null && (propertyChangeListenerArray = this.listeners.get(propertyChangeEvent.getPropertyName())) != null) {
            for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    final boolean hasListener(String string) {
        return this.listeners != null && this.listeners.containsKey(string);
    }
}

