/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Metadata readers for some format used in Earth observation (Landsat, MODIS).
 * This package includes mapping from the following formats to ISO 19115 metadata:
 *
 * <table class="sis">
 *   <caption>Earth observation formats</caption>
 *   <tr>
 *     <th>Format</th>
 *     <th>Provider</th>
 *     <th>Apache SIS notes</th>
 *   </tr><tr>
 *     <td>Landsat 8 level 1</td>
 *     <td>U.S. Geological Survey (USGS)</td>
 *     <td><a href="doc-files/LandsatMetadata.html">Mapping from/to ISO 19115</a></td>
 *   </tr>
 * </table>
 *
 * @author  Thi Phuong Hao Nguyen (VNSC)
 * @author  Minh Chinh Vu (VNSC)
 * @version 0.8
 * @since   0.8
 * @module
 */
package org.apache.sis.storage.earthobservation;
