/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import org.apache.sis.xml.TransformVersion;

class TransformingNamespaces
implements NamespaceContext {
    final NamespaceContext context;
    final TransformVersion version;

    static NamespaceContext asXML(NamespaceContext context, TransformVersion version) {
        if (context != null) {
            context = context instanceof Inverse && ((Inverse)context).version == version ? ((Inverse)context).context : new TransformingNamespaces(context, version);
        }
        return context;
    }

    static NamespaceContext asJAXB(NamespaceContext context, TransformVersion version) {
        if (context != null) {
            context = context.getClass() == TransformingNamespaces.class && ((TransformingNamespaces)context).version == version ? ((TransformingNamespaces)context).context : new Inverse(context, version);
        }
        return context;
    }

    private TransformingNamespaces(NamespaceContext context, TransformVersion version) {
        this.context = context;
        this.version = version;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.version.exportNS(this.context.getNamespaceURI(prefix));
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String p = this.context.getPrefix(this.version.importNS(namespaceURI));
        if (p != null) {
            return p;
        }
        Iterator<Map.Entry<String, String>> it = this.version.exports();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (!namespaceURI.equals(e.getValue()) || (p = this.context.getPrefix(e.getKey())) == null) continue;
            return p;
        }
        return this.context.getPrefix(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return new Prefixes(this.context, this.version.exports(), namespaceURI);
    }

    private static final class Prefixes
    implements Iterator<String> {
        private final String namespaceURI;
        private final NamespaceContext context;
        private final Iterator<Map.Entry<String, String>> exports;
        private Iterator<String> prefixes;
        private String next;

        Prefixes(NamespaceContext context, Iterator<Map.Entry<String, String>> exports, String namespaceURI) {
            this.context = context;
            this.exports = exports;
            this.namespaceURI = namespaceURI;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.prefixes == null) {
                    if (!this.exports.hasNext()) {
                        return false;
                    }
                    Map.Entry<String, String> e = this.exports.next();
                    if (!this.namespaceURI.equals(e.getValue())) continue;
                    this.prefixes = this.context.getPrefixes(e.getKey());
                }
                if (this.prefixes.hasNext()) {
                    this.next = this.prefixes.next();
                    continue;
                }
                this.prefixes = null;
            }
            return true;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String n = this.next;
            this.next = null;
            return n;
        }
    }

    private static final class Inverse
    extends TransformingNamespaces {
        Inverse(NamespaceContext context, TransformVersion version) {
            super(context, version);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.version.importNS(this.context.getNamespaceURI(prefix));
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.context.getPrefix(this.version.exportNS(namespaceURI));
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return this.context.getPrefixes(this.version.exportNS(namespaceURI));
        }
    }
}

