/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.bind.JAXBContext;

enum Implementation {
    INTERNAL("com.sun.xml.internal.bind.indentString"),
    ENDORSED("com.sun.xml.bind.indentString"),
    OTHER(null);

    private static final String ENDORSED_PREFIX = "com.sun.xml.bind.";
    private static final String INTERNAL_PREFIX = "com.sun.xml.internal.bind.";
    final String indentKey;

    private Implementation(String indentKey) {
        this.indentKey = indentKey;
    }

    public static Implementation detect(JAXBContext context) {
        if (context != null) {
            String classname = context.getClass().getName();
            if (classname.startsWith(INTERNAL_PREFIX)) {
                return INTERNAL;
            }
            if (classname.startsWith(ENDORSED_PREFIX)) {
                return ENDORSED;
            }
        }
        return OTHER;
    }

    boolean filterProperty(String key) {
        return this.indentKey != null || !key.startsWith(ENDORSED_PREFIX);
    }

    static String toInternal(String key) {
        if (key.startsWith(ENDORSED_PREFIX)) {
            StringBuilder buffer = new StringBuilder(key.length() + 10);
            key = buffer.append(INTERNAL_PREFIX).append(key, ENDORSED_PREFIX.length(), key.length()).toString();
        }
        return key;
    }
}

