/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.resources;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

final class Loader
extends ResourceBundle.Control {
    private static final String EXTENSION = "utf";
    private static final List<String> FORMATS = Collections.singletonList("apache-sis.utf");
    public static final Loader INSTANCE = new Loader();

    private Loader() {
    }

    @Override
    public List<String> getFormats(String baseName) {
        return FORMATS;
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        return false;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        Class<?> classe;
        try {
            classe = Class.forName(baseName, true, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        String classname = classe.getSimpleName();
        URL resources = classe.getResource(this.toResourceName(this.toBundleName(classname, locale), EXTENSION));
        try {
            return (ResourceBundle)classe.getDeclaredConstructor(URL.class).newInstance(resources);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw (InstantiationException)new InstantiationException(e.toString()).initCause(e);
        }
    }
}

