/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Locales;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.AbstractInternationalString;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.util.InternationalString;

public class DefaultInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 3663160836923279819L;
    private Map<Locale, String> localeMap;
    private transient Set<Locale> localeSet;

    public DefaultInternationalString() {
        this.localeMap = Collections.emptyMap();
    }

    public DefaultInternationalString(String string) {
        this.localeMap = string != null ? Collections.singletonMap(Locale.ROOT, string) : Collections.emptyMap();
    }

    public DefaultInternationalString(Map<Locale, String> strings) {
        if (Containers.isNullOrEmpty(strings)) {
            this.localeMap = Collections.emptyMap();
        } else {
            Iterator<Map.Entry<Locale, String>> it = strings.entrySet().iterator();
            Map.Entry<Locale, String> entry = it.next();
            this.localeMap = !it.hasNext() ? Collections.singletonMap(entry.getKey(), entry.getValue()) : new LinkedHashMap<Locale, String>(strings);
        }
        boolean nullMapKey = this.localeMap.containsKey(null);
        if (nullMapKey || this.localeMap.containsValue(null)) {
            throw new IllegalArgumentException(Errors.format(nullMapKey ? (short)115 : 116));
        }
    }

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("locale", locale);
        ArgumentChecks.ensureNonNull("string", string);
        switch (this.localeMap.size()) {
            case 0: {
                this.localeMap = Collections.singletonMap(locale, string);
                this.localeSet = null;
                this.defaultValue = null;
                return;
            }
            case 1: {
                this.localeMap = new LinkedHashMap<Locale, String>(this.localeMap);
                this.localeSet = null;
            }
        }
        String old = this.localeMap.put(locale, string);
        if (old != null) {
            this.localeMap.put(locale, old);
            if (string.equals(old)) {
                return;
            }
            throw new IllegalArgumentException(Errors.format((short)164, locale));
        }
        this.defaultValue = null;
    }

    final void add(Locale locale, CharSequence string) throws IllegalArgumentException {
        boolean i18n = string instanceof InternationalString;
        this.add(locale, i18n ? ((InternationalString)string).toString(locale) : string.toString());
        if (i18n && !(string instanceof SimpleInternationalString)) {
            LogRecord record = Messages.getResources(null).getLogRecord(Level.WARNING, (short)25);
            record.setSourceClassName("org.apache.sis.util.iso.Types");
            record.setSourceMethodName("toInternationalString");
            record.setLoggerName("org.apache.sis.util");
            Logging.getLogger("org.apache.sis.util").log(record);
        }
    }

    public synchronized Set<Locale> getLocales() {
        Set<Locale> locales = this.localeSet;
        if (locales == null) {
            locales = this.localeMap.keySet();
            if (this.localeMap instanceof HashMap) {
                locales = Collections.unmodifiableSet(locales);
            }
            this.localeSet = locales;
        }
        return locales;
    }

    private String getString(Locale locale) {
        while (locale != null) {
            String text = this.localeMap.get(locale);
            if (text != null) {
                return text;
            }
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (!variant.isEmpty()) {
                locale = new Locale(language, country);
                continue;
            }
            if (country.isEmpty()) break;
            locale = new Locale(language);
        }
        return null;
    }

    @Override
    public synchronized String toString(Locale locale) {
        String text = this.getString(locale);
        if (text == null && (text = this.localeMap.get(Locale.ROOT)) == null) {
            Locale fallback = Locale.US;
            if (fallback != locale && (text = this.getString(fallback)) != null) {
                return text;
            }
            fallback = Locale.getDefault();
            if (fallback != locale && fallback != Locale.US && (text = this.getString(fallback)) != null) {
                return text;
            }
            Iterator<String> it = this.localeMap.values().iterator();
            if (it.hasNext()) {
                text = it.next();
            }
        }
        return text;
    }

    public synchronized boolean isSubsetOf(Object candidate) {
        if (candidate instanceof InternationalString) {
            InternationalString string = (InternationalString)candidate;
            for (Map.Entry<Locale, String> entry : this.localeMap.entrySet()) {
                Locale locale = entry.getKey();
                String text = entry.getValue();
                if (text.equals(string.toString(locale))) continue;
                return false;
            }
        } else if (candidate instanceof CharSequence) {
            String string = candidate.toString();
            for (String text : this.localeMap.values()) {
                if (text.equals(string)) continue;
                return false;
            }
        } else {
            if (candidate instanceof Map) {
                Map map = (Map)candidate;
                return map.entrySet().containsAll(this.localeMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            DefaultInternationalString that = (DefaultInternationalString)object;
            return Objects.equals(this.localeMap, that.localeMap);
        }
        return false;
    }

    public synchronized int hashCode() {
        return this.localeMap.hashCode() ^ 0x77EF49CB;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = this.localeMap.size();
        if (size == 0) {
            return;
        }
        Map.Entry[] entries = new Map.Entry[size];
        entries = this.localeMap.entrySet().toArray(entries);
        if (size == 1) {
            Map.Entry entry = entries[0];
            this.localeMap = Collections.singletonMap(Locales.unique((Locale)entry.getKey()), (String)entry.getValue());
        } else {
            this.localeMap.clear();
            for (Map.Entry entry : entries) {
                this.localeMap.put(Locales.unique((Locale)entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

