/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.util.InternationalString;

public class TableColumn<V>
implements CheckedContainer<V> {
    public static final TableColumn<CharSequence> NAME = new Constant<CharSequence>("NAME", CharSequence.class, 72);
    public static final TableColumn<String> IDENTIFIER = new Constant<String>("IDENTIFIER", String.class, 47);
    public static final TableColumn<Integer> INDEX = new Constant<Integer>("INDEX", Integer.class, 51);
    public static final TableColumn<Class<?>> TYPE = new Constant<Class>("TYPE", Class.class, 105);
    public static final TableColumn<Object> VALUE = new Constant<Object>("VALUE", Object.class, 111);
    public static final TableColumn<CharSequence> VALUE_AS_TEXT = new Constant<CharSequence>("VALUE_AS_TEXT", CharSequence.class, 111);
    public static final TableColumn<Number> VALUE_AS_NUMBER = new Constant<Number>("VALUE_AS_NUMBER", Number.class, 111);
    public static final TableColumn<CharSequence> REMARKS = new Constant<CharSequence>("REMARKS", CharSequence.class, 88);
    static final Map<TableColumn<?>, Integer> NAME_MAP = Collections.singletonMap(NAME, 0);
    private final Class<V> type;
    CharSequence header;

    protected TableColumn() {
        this.type = null;
    }

    TableColumn(Class<V> type) {
        this.type = type;
    }

    public TableColumn(Class<V> type, CharSequence header) {
        this.type = type;
        ArgumentChecks.ensureNonNull("type", this.type);
        this.header = header;
        ArgumentChecks.ensureNonNull("header", this.header);
    }

    public synchronized InternationalString getHeader() {
        CharSequence t = this.header;
        if (t == null || t instanceof InternationalString) {
            return (InternationalString)t;
        }
        SimpleInternationalString i18n = new SimpleInternationalString(t.toString());
        this.header = i18n;
        return i18n;
    }

    @Override
    public final Class<V> getElementType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.getHeader());
    }

    private static final class Constant<V>
    extends TableColumn<V>
    implements Serializable {
        private static final long serialVersionUID = -3460868641711391888L;
        private final String field;
        private final transient short resourceKey;

        Constant(String field, Class<V> type, short header) {
            super(type);
            this.field = field;
            this.resourceKey = header;
        }

        @Override
        public synchronized InternationalString getHeader() {
            InternationalString i18n = (InternationalString)this.header;
            if (i18n == null) {
                i18n = Vocabulary.formatInternational(this.resourceKey);
                this.header = i18n;
            }
            return i18n;
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                return TableColumn.class.getField(this.field).get(null);
            }
            catch (ReflectiveOperationException cause) {
                throw (InvalidObjectException)new InvalidObjectException(cause.toString()).initCause(cause);
            }
        }
    }
}

