/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

public class RangeSet<E extends Comparable<? super E>>
extends AbstractSet<Range<E>>
implements CheckedContainer<Range<E>>,
SortedSet<Range<E>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7493555225994855486L;
    protected final Class<E> elementType;
    private final byte elementCode;
    protected final boolean isMinIncluded;
    protected final boolean isMaxIncluded;
    private Object array;
    private transient int length;
    private transient int modCount;

    protected RangeSet(Class<E> elementType, boolean isMinIncluded, boolean isMaxIncluded) {
        ArgumentChecks.ensureNonNull("elementType", elementType);
        assert (Comparable.class.isAssignableFrom(elementType)) : elementType;
        this.elementType = elementType;
        this.elementCode = Numbers.getEnumConstant(elementType);
        this.isMinIncluded = isMinIncluded;
        this.isMaxIncluded = isMaxIncluded;
        if (!isMinIncluded && !isMaxIncluded) {
            throw new IllegalArgumentException("Open intervals are not yet supported.");
        }
    }

    public static <E extends Comparable<? super E>> RangeSet<E> create(Class<E> elementType, boolean isMinIncluded, boolean isMaxIncluded) {
        ArgumentChecks.ensureNonNull("elementType", elementType);
        if (Number.class.isAssignableFrom(elementType)) {
            return new Numeric<E>(elementType, isMinIncluded, isMaxIncluded);
        }
        return new RangeSet<E>(elementType, isMinIncluded, isMaxIncluded);
    }

    @Override
    public final Class<Range<E>> getElementType() {
        return Range.class;
    }

    @Override
    public Comparator<Range<E>> comparator() {
        return Compare.INSTANCE;
    }

    @Override
    public void clear() {
        if (this.array instanceof Object[]) {
            Arrays.fill((Object[])this.array, 0, this.length, null);
        }
        this.length = 0;
        ++this.modCount;
    }

    @Override
    public int size() {
        assert ((this.length & 1) == 0);
        return this.length >>> 1;
    }

    private void reallocate() {
        if (this.length == 0) {
            this.array = null;
        } else {
            Object oldArray = this.array;
            this.array = Array.newInstance(oldArray.getClass().getComponentType(), this.length);
            System.arraycopy(oldArray, 0, this.array, 0, this.length);
        }
    }

    public final void trimToSize() {
        if (this.array != null && Array.getLength(this.array) != this.length) {
            this.reallocate();
            assert (this.isSorted());
        }
    }

    private void insertAt(int lower, E minValue, E maxValue) {
        Object oldArray = this.array;
        int capacity = Array.getLength(oldArray);
        if (this.length + 2 > capacity) {
            this.array = Array.newInstance(oldArray.getClass().getComponentType(), 2 * Math.max(capacity, 8));
            System.arraycopy(oldArray, 0, this.array, 0, lower);
        }
        System.arraycopy(oldArray, lower, this.array, lower + 2, this.length - lower);
        Array.set(this.array, lower, minValue);
        Array.set(this.array, lower + 1, maxValue);
        this.length += 2;
        ++this.modCount;
    }

    private void removeAt(int lower, int upper) {
        int oldLength = this.length;
        System.arraycopy(this.array, upper, this.array, lower, oldLength - upper);
        this.length -= upper - lower;
        if (this.array instanceof Object[]) {
            Arrays.fill((Object[])this.array, this.length, oldLength, null);
        }
        ++this.modCount;
    }

    private boolean isSorted() {
        if (this.array == null) {
            return true;
        }
        boolean strict = this.isMinIncluded | this.isMaxIncluded;
        switch (this.elementCode) {
            case 9: {
                return ArraysExt.isSorted((double[])this.array, strict);
            }
            case 8: {
                return ArraysExt.isSorted((float[])this.array, strict);
            }
            case 6: {
                return ArraysExt.isSorted((long[])this.array, strict);
            }
            case 5: {
                return ArraysExt.isSorted((int[])this.array, strict);
            }
            case 4: {
                return ArraysExt.isSorted((short[])this.array, strict);
            }
            case 3: {
                return ArraysExt.isSorted((byte[])this.array, strict);
            }
            case 2: {
                return ArraysExt.isSorted((char[])this.array, strict);
            }
        }
        return ArraysExt.isSorted((Comparable[])((Comparable[])this.array), (boolean)strict);
    }

    final int binarySearch(E value, int lower, int upper) {
        switch (this.elementCode) {
            case 9: {
                return Arrays.binarySearch((double[])this.array, lower, upper, (Double)value);
            }
            case 8: {
                return Arrays.binarySearch((float[])this.array, lower, upper, ((Float)value).floatValue());
            }
            case 6: {
                return Arrays.binarySearch((long[])this.array, lower, upper, (Long)value);
            }
            case 5: {
                return Arrays.binarySearch((int[])this.array, lower, upper, (Integer)value);
            }
            case 4: {
                return Arrays.binarySearch((short[])this.array, lower, upper, (Short)value);
            }
            case 3: {
                return Arrays.binarySearch((byte[])this.array, lower, upper, (Byte)value);
            }
            case 2: {
                return Arrays.binarySearch((char[])this.array, lower, upper, ((Character)value).charValue());
            }
        }
        return Arrays.binarySearch((Object[])this.array, lower, upper, value);
    }

    private static <E extends Comparable<? super E>> void ensureOrdered(E minValue, E maxValue) {
        if (minValue.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException(Errors.format((short)60, minValue, maxValue));
        }
    }

    @Override
    public boolean add(Range<E> range) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("range", range);
        if (range.isEmpty()) {
            return false;
        }
        if (range.isMinIncluded() != this.isMinIncluded || range.isMaxIncluded() != this.isMaxIncluded) {
            throw new IllegalArgumentException(Errors.format((short)45, "range", range));
        }
        return this.add(range.getMinValue(), range.getMaxValue());
    }

    public boolean add(E minValue, E maxValue) throws IllegalArgumentException {
        int n;
        ArgumentChecks.ensureNonNull("minValue", minValue);
        ArgumentChecks.ensureNonNull("maxValue", maxValue);
        if (this.array == null) {
            RangeSet.ensureOrdered(minValue, maxValue);
            Class<Object> type = this.elementType;
            if (type != Boolean.class) {
                type = Numbers.wrapperToPrimitive(type);
            }
            this.array = Array.newInstance(type, 8);
            Array.set(this.array, 0, minValue);
            Array.set(this.array, 1, maxValue);
            this.length = 2;
            ++this.modCount;
            return true;
        }
        int modCountChk = this.modCount;
        int i0 = this.binarySearch(minValue, 0, this.length);
        int i1 = this.binarySearch(maxValue, i0 >= 0 ? i0 : ~i0, this.length);
        if (i0 < 0 && ((i0 ^= 0xFFFFFFFF) & 1) == 0) {
            if (i0 == ~i1) {
                RangeSet.ensureOrdered(minValue, maxValue);
                this.insertAt(i0, minValue, maxValue);
                return true;
            }
            Array.set(this.array, i0, minValue);
            ++this.modCount;
        }
        i0 &= 0xFFFFFFFE;
        if (i1 < 0 && ((i1 ^= 0xFFFFFFFF) & 1) == 0) {
            Array.set(this.array, --i1, maxValue);
            ++this.modCount;
        }
        i1 |= 1;
        assert (this.getValue(i0).compareTo(maxValue) <= 0);
        assert (this.getValue(i1).compareTo(minValue) >= 0);
        if ((n = i1 - ++i0) != 0) {
            this.removeAt(i0, i1);
        }
        assert (Array.getLength(this.array) >= this.length && (this.length & 1) == 0) : this.length;
        return modCountChk != this.modCount;
    }

    @Override
    public boolean remove(Object object) {
        Range range;
        if (object instanceof Range && (range = (Range)object).getElementType() == this.elementType) {
            if (range.isMinIncluded() == this.isMaxIncluded || range.isMaxIncluded() == this.isMinIncluded) {
                throw new IllegalArgumentException(Errors.format((short)45, "object", range));
            }
            return this.remove(range.getMinValue(), range.getMaxValue());
        }
        return false;
    }

    public boolean remove(E minValue, E maxValue) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("minValue", minValue);
        ArgumentChecks.ensureNonNull("maxValue", maxValue);
        if (this.length == 0) {
            return false;
        }
        RangeSet.ensureOrdered(minValue, maxValue);
        int i0 = this.binarySearch(minValue, 0, this.length);
        int i1 = this.binarySearch(maxValue, i0 >= 0 ? i0 : ~i0, this.length);
        if (i0 < 0) {
            i0 ^= 0xFFFFFFFF;
        }
        if (i1 < 0) {
            i1 ^= 0xFFFFFFFF;
        }
        if ((i0 & 1) == 0) {
            if ((i1 & 1) == 0) {
                this.removeAt(i0, i1);
            } else {
                this.removeAt(i0, i1 & 0xFFFFFFFE);
                Array.set(this.array, i0, maxValue);
            }
        } else if ((i1 & 1) == 0) {
            this.removeAt(i0 + 1, i1);
            Array.set(this.array, i0, minValue);
        } else if (i0 == i1) {
            this.insertAt(i1 + 1, maxValue, this.getValue(i1));
            Array.set(this.array, i0, minValue);
        } else {
            int di = i1 - i0;
            assert (di >= 2) : di;
            if (di > 2) {
                this.removeAt(i0 + 1, i1 & 0xFFFFFFFE);
            }
            Array.set(this.array, i0, minValue);
            Array.set(this.array, i0 + 1, maxValue);
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        Range range;
        if (object instanceof Range && (range = (Range)object).getElementType() == this.elementType) {
            return this.contains(range, false);
        }
        return false;
    }

    public boolean contains(Range<E> range, boolean exact) {
        ArgumentChecks.ensureNonNull("range", range);
        if (exact) {
            int index;
            if (range.isMinIncluded() && !range.isMaxIncluded() && (index = this.binarySearch(range.getMinValue(), 0, this.length)) >= 0 && (index & 1) == 0) {
                return this.getValue(index + 1).compareTo(range.getMaxValue()) == 0;
            }
        } else if (!range.isEmpty()) {
            int lower = this.binarySearch(range.getMinValue(), 0, this.length);
            if (lower < 0 ? ((lower ^= 0xFFFFFFFF) & 1) == 0 : (lower & 1) == 0 && !this.isMinIncluded && range.isMinIncluded()) {
                return false;
            }
            int upper = this.binarySearch(range.getMaxValue(), lower, this.length);
            if (upper < 0 ? ((upper ^= 0xFFFFFFFF) & 1) == 0 : (upper & 1) != 0 && !this.isMaxIncluded && range.isMaxIncluded()) {
                return false;
            }
            return upper - lower <= 1;
        }
        return false;
    }

    @Override
    public Range<E> first() throws NoSuchElementException {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.getRange(0);
    }

    @Override
    public Range<E> last() throws NoSuchElementException {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.getRange(this.length - 2);
    }

    public SortedSet<Range<E>> intersect(Range<E> subRange) {
        ArgumentChecks.ensureNonNull("subRange", subRange);
        return new SubSet(subRange);
    }

    @Override
    public SortedSet<Range<E>> subSet(Range<E> lower, Range<E> upper) {
        ArgumentChecks.ensureNonNull("lower", lower);
        ArgumentChecks.ensureNonNull("upper", upper);
        E maxValue = upper.getMinValue();
        if (maxValue == null) {
            throw new IllegalArgumentException(Errors.format((short)45, "upper", upper));
        }
        return this.intersect(new Range<E>(this.elementType, lower.getMinValue(), lower.isMinIncluded(), maxValue, !upper.isMinIncluded()));
    }

    @Override
    public SortedSet<Range<E>> headSet(Range<E> upper) {
        ArgumentChecks.ensureNonNull("upper", upper);
        E maxValue = upper.getMinValue();
        if (maxValue == null) {
            throw new IllegalArgumentException(Errors.format((short)45, "upper", upper));
        }
        return this.intersect(new Range<Object>((Class<Object>)this.elementType, null, false, maxValue, !upper.isMinIncluded()));
    }

    @Override
    public SortedSet<Range<E>> tailSet(Range<E> lower) {
        ArgumentChecks.ensureNonNull("lower", lower);
        return this.intersect(new Range<Object>((Class<Object>)this.elementType, lower.getMinValue(), lower.isMinIncluded(), null, false));
    }

    @Override
    public Iterator<Range<E>> iterator() {
        return new Iter(this.length);
    }

    public int indexOfRange(E value) {
        int index = this.binarySearch(value, 0, this.length);
        if (index < 0 ? ((index ^= 0xFFFFFFFF) & 1) == 0 : !((index & 1) != 0 ? this.isMaxIncluded : this.isMinIncluded)) {
            return -1;
        }
        return index /= 2;
    }

    public long getMinLong(int index) throws IndexOutOfBoundsException, ClassCastException {
        if ((index *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getLong(this.array, index);
    }

    public double getMinDouble(int index) throws IndexOutOfBoundsException, ClassCastException {
        if ((index *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getDouble(this.array, index);
    }

    public long getMaxLong(int index) throws IndexOutOfBoundsException, ClassCastException {
        if ((index *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getLong(this.array, index + 1);
    }

    public double getMaxDouble(int index) throws IndexOutOfBoundsException, ClassCastException {
        if ((index *= 2) >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return Array.getDouble(this.array, index + 1);
    }

    final E getValue(int index) {
        assert (index >= 0 && index < this.length) : index;
        return (E)((Comparable)this.elementType.cast(Array.get(this.array, index)));
    }

    final Range<E> getRange(int index) {
        return this.newRange(this.getValue(index), this.getValue(index + 1));
    }

    protected Range<E> newRange(E lower, E upper) {
        return new Range<E>(this.elementType, lower, this.isMinIncluded, upper, this.isMaxIncluded);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RangeSet) {
            RangeSet that = (RangeSet)object;
            if (this.length != that.length || this.elementType != that.elementType || this.isMinIncluded != that.isMinIncluded || this.isMaxIncluded != that.isMaxIncluded) {
                return false;
            }
            this.trimToSize();
            that.trimToSize();
            Object a1 = this.array;
            Object a2 = that.array;
            switch (this.elementCode) {
                case 9: {
                    return Arrays.equals((double[])a1, (double[])a2);
                }
                case 8: {
                    return Arrays.equals((float[])a1, (float[])a2);
                }
                case 6: {
                    return Arrays.equals((long[])a1, (long[])a2);
                }
                case 5: {
                    return Arrays.equals((int[])a1, (int[])a2);
                }
                case 4: {
                    return Arrays.equals((short[])a1, (short[])a2);
                }
                case 3: {
                    return Arrays.equals((byte[])a1, (byte[])a2);
                }
                case 2: {
                    return Arrays.equals((char[])a1, (char[])a2);
                }
            }
            return Arrays.equals((Object[])a1, (Object[])a2);
        }
        return super.equals(object);
    }

    public RangeSet<E> clone() {
        RangeSet set;
        try {
            set = (RangeSet)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
        set.reallocate();
        return set;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.array != null) {
            this.length = Array.getLength(this.array);
            assert (this.isSorted());
        }
    }

    private static final class Numeric<E extends Number>
    extends RangeSet<E> {
        private static final long serialVersionUID = 5603640102714482527L;

        Numeric(Class<E> elementType, boolean isMinIncluded, boolean isMaxIncluded) {
            super(elementType, isMinIncluded, isMaxIncluded);
        }

        @Override
        protected Range<E> newRange(E lower, E upper) {
            return new NumberRange<E>(this.elementType, lower, this.isMinIncluded, upper, this.isMaxIncluded);
        }
    }

    private class Iter
    implements Iterator<Range<E>> {
        int modCount;
        final int upper;
        int position;
        boolean canRemove;

        Iter(int upper) {
            this.upper = upper;
            this.modCount = RangeSet.this.modCount;
        }

        @Override
        public final boolean hasNext() {
            return this.position < this.upper;
        }

        @Override
        public Range<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Range range = RangeSet.this.getRange(this.position);
            if (RangeSet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.position += 2;
            this.canRemove = true;
            return range;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (RangeSet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            RangeSet.this.removeAt(this.position - 2, this.position);
            this.modCount = RangeSet.this.modCount;
            this.canRemove = false;
        }
    }

    private final class SubIter
    extends Iter {
        private final Range<E> subRange;
        private final int lower;

        SubIter(Range<E> subRange, int lower, int upper) {
            super(upper);
            this.subRange = subRange;
            this.lower = lower;
            this.position = lower;
        }

        private boolean isFirstOrLast() {
            return this.position <= this.lower + 2 || this.position >= this.upper;
        }

        @Override
        public Range<E> next() {
            Range range = super.next();
            if (this.isFirstOrLast()) {
                range = this.subRange.intersect(range);
            }
            return range;
        }

        @Override
        public void remove() {
            if (this.isFirstOrLast()) {
                super.remove();
                return;
            }
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (RangeSet.this.modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            RangeSet.this.remove(this.subRange.intersect(RangeSet.this.getRange(this.position - 2)));
            this.canRemove = false;
        }
    }

    private final class SubSet
    extends AbstractSet<Range<E>>
    implements SortedSet<Range<E>>,
    Serializable {
        private static final long serialVersionUID = 3093791428299754372L;
        private Range<E> subRange;
        private transient int lower;
        private transient int upper;
        private transient int modCount;

        SubSet(Range<E> subRange) {
            this.subRange = subRange;
            if (subRange.isEmpty()) {
                throw new IllegalArgumentException(Errors.format((short)45, "subRange", subRange));
            }
            this.modCount = RangeSet.this.modCount - 1;
        }

        private void updateBounds() {
            if (this.modCount != RangeSet.this.modCount) {
                int lower = 0;
                int upper = RangeSet.this.length;
                Object minValue = this.subRange.getMinValue();
                Object maxValue = this.subRange.getMaxValue();
                if (minValue != null) {
                    lower = RangeSet.this.binarySearch(minValue, 0, upper);
                    if (lower < 0) {
                        lower ^= 0xFFFFFFFF;
                    }
                    lower &= 0xFFFFFFFE;
                }
                if (maxValue != null) {
                    if ((upper = RangeSet.this.binarySearch(maxValue, lower, upper)) < 0) {
                        upper ^= 0xFFFFFFFF;
                    }
                    upper = upper + 1 & 0xFFFFFFFE;
                }
                this.lower = lower;
                this.upper = upper;
                this.modCount = RangeSet.this.modCount;
            }
        }

        @Override
        public Comparator<Range<E>> comparator() {
            return RangeSet.this.comparator();
        }

        @Override
        public void clear() {
            RangeSet.this.remove(this.subRange);
        }

        @Override
        public int size() {
            this.updateBounds();
            return this.upper - this.lower >> 1;
        }

        @Override
        public boolean add(Range<E> range) {
            boolean changed = RangeSet.this.add(range);
            this.subRange = this.subRange.union(range);
            return changed;
        }

        @Override
        public boolean remove(Object object) {
            Range range;
            if (object instanceof Range && (range = (Range)object).getElementType() == RangeSet.this.elementType) {
                object = this.subRange.intersect(range);
            }
            return RangeSet.this.remove(object);
        }

        @Override
        public boolean contains(Object object) {
            Range range;
            if (object instanceof Range && (range = (Range)object).getElementType() == RangeSet.this.elementType && !this.subRange.contains(range)) {
                return false;
            }
            return RangeSet.this.contains(object);
        }

        @Override
        public Range<E> first() {
            this.updateBounds();
            if (this.lower == this.upper) {
                throw new NoSuchElementException();
            }
            return this.subRange.intersect(RangeSet.this.getRange(this.lower));
        }

        @Override
        public Range<E> last() {
            this.updateBounds();
            if (this.lower == this.upper) {
                throw new NoSuchElementException();
            }
            return this.subRange.intersect(RangeSet.this.getRange(this.upper - 2));
        }

        @Override
        public SortedSet<Range<E>> subSet(Range<E> fromElement, Range<E> toElement) {
            fromElement = this.subRange.intersect(fromElement);
            toElement = this.subRange.intersect(toElement);
            return RangeSet.this.subSet(fromElement, toElement);
        }

        @Override
        public SortedSet<Range<E>> headSet(Range<E> toElement) {
            toElement = this.subRange.intersect(toElement);
            return RangeSet.this.headSet(toElement);
        }

        @Override
        public SortedSet<Range<E>> tailSet(Range<E> fromElement) {
            fromElement = this.subRange.intersect(fromElement);
            return RangeSet.this.tailSet(fromElement);
        }

        @Override
        public Iterator<Range<E>> iterator() {
            this.updateBounds();
            return new SubIter(this.subRange, this.lower, this.upper);
        }
    }

    private static final class Compare<E extends Comparable<? super E>>
    implements Comparator<Range<E>>,
    Serializable {
        private static final long serialVersionUID = 8688450091923783564L;
        static final Compare INSTANCE = new Compare();

        private Compare() {
        }

        @Override
        public int compare(Range<E> r1, Range<E> r2) {
            boolean included;
            int cmin = r1.getMinValue().compareTo(r2.getMinValue());
            int cmax = r1.getMaxValue().compareTo(r2.getMaxValue());
            if (cmin == 0) {
                included = r1.isMinIncluded();
                if (r2.isMinIncluded() != included) {
                    int n = cmin = included ? -1 : 1;
                }
            }
            if (cmax == 0) {
                included = r1.isMaxIncluded();
                if (r2.isMaxIncluded() != included) {
                    int n = cmax = included ? 1 : -1;
                }
            }
            if (cmin == cmax) {
                return cmax;
            }
            if (cmin == 0) {
                return cmax;
            }
            if (cmax == 0) {
                return cmin;
            }
            throw new IllegalArgumentException(Errors.format((short)132, r1, r2));
        }

        Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

