/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.sis.internal.system.DelayedExecutor;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.collection.CacheEntries;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

public class Cache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, Object> map;
    private final Map<K, Integer> costs;
    private long totalCost;
    private final long costLimit;
    private final boolean soft;
    private volatile boolean isKeyCollisionAllowed;
    private volatile transient Set<Map.Entry<K, V>> entries;

    public Cache() {
        this(12, 100L, false);
    }

    public Cache(int initialCapacity, long costLimit, boolean soft) {
        ArgumentChecks.ensureStrictlyPositive("initialCapacity", initialCapacity);
        ArgumentChecks.ensurePositive("costLimit", costLimit);
        initialCapacity = Containers.hashMapCapacity(initialCapacity);
        this.map = new ConcurrentHashMap<K, Object>(initialCapacity);
        this.costs = new LinkedHashMap<K, Integer>((int)Math.min((long)initialCapacity, costLimit), 0.75f, true);
        this.costLimit = costLimit;
        this.soft = soft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, Integer> map = this.costs;
        synchronized (map) {
            this.map.clear();
            this.costs.clear();
            this.totalCost = 0L;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V get(Object key) {
        return Cache.valueOf(this.map.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCreate(K key, Callable<? extends V> creator) throws Exception {
        V value = this.peek(key);
        if (value == null) {
            Handler<V> handler = this.lock(key);
            try {
                value = handler.peek();
                if (value == null) {
                    value = creator.call();
                }
            }
            finally {
                handler.putAndUnlock(value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> creator) {
        V value = this.peek(key);
        if (value == null) {
            Handler<V> handler = this.lock(key);
            try {
                value = handler.peek();
                if (value == null) {
                    value = creator.apply(key);
                }
            }
            finally {
                handler.putAndUnlock(value);
            }
        }
        return value;
    }

    static boolean isReservedType(Object value) {
        return value instanceof Handler || value instanceof Reference;
    }

    private static void ensureValidType(Object value) throws IllegalArgumentException {
        if (Cache.isReservedType(value)) {
            throw new IllegalArgumentException(Errors.format((short)42, "value", value.getClass()));
        }
    }

    private static <V> V valueOf(Object value) {
        if (value instanceof Reference) {
            return (V)((Reference)value).get();
        }
        if (value instanceof Handler) {
            return (V)((Supplier)value).get();
        }
        return (V)value;
    }

    private static <V> V immediateValueOf(Object value) {
        if (value instanceof Reference) {
            return (V)((Reference)value).get();
        }
        if (value instanceof Handler) {
            return null;
        }
        return (V)value;
    }

    final void notifyChange(K key, V value) {
        DelayedExecutor.schedule(new Strong(key, value));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            return null;
        }
        Cache.ensureValidType(value);
        Object previous = this.map.putIfAbsent(key, value);
        if (previous == null) {
            this.notifyChange(key, value);
        }
        return Cache.valueOf(previous);
    }

    @Override
    public V put(K key, V value) {
        Object previous;
        Cache.ensureValidType(value);
        Object v = previous = value != null ? this.map.put(key, value) : this.map.remove(key);
        if (previous != value) {
            this.notifyChange(key, value);
        }
        return Cache.immediateValueOf(previous);
    }

    @Override
    public V replace(K key, V value) {
        Object previous;
        Cache.ensureValidType(value);
        Object object = previous = value != null ? this.map.replace(key, value) : this.map.remove(key);
        if (previous != null) {
            this.notifyChange(key, value);
        }
        return Cache.immediateValueOf(previous);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean done;
        Cache.ensureValidType(newValue);
        if (oldValue != null) {
            done = newValue != null ? this.map.replace(key, oldValue, newValue) : this.map.remove(key, oldValue);
        } else {
            boolean bl = done = newValue != null && this.map.putIfAbsent(key, newValue) == null;
        }
        if (done) {
            this.notifyChange(key, newValue);
        }
        return done;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> remapping) {
        ReplaceAdapter adapter = new ReplaceAdapter(remapping);
        this.map.replaceAll(adapter);
        Deferred.notifyChanges(this, adapter.changes);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remapping) {
        ReplaceAdapter adapter = new ReplaceAdapter(remapping);
        Object value = this.map.computeIfPresent(key, adapter);
        Deferred.notifyChanges(this, adapter.changes);
        return Cache.valueOf(value);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remapping) {
        ReplaceAdapter adapter = new ReplaceAdapter(remapping);
        Object value = this.map.compute(key, adapter);
        Deferred.notifyChanges(this, adapter.changes);
        return Cache.valueOf(value);
    }

    @Override
    public V merge(final K key, V value, final BiFunction<? super V, ? super V, ? extends V> remapping) {
        Cache.ensureValidType(value);
        final class Adapter
        implements BiFunction<Object, Object, Object> {
            Deferred<K, V> changes;

            Adapter() {
            }

            @Override
            public Object apply(Object oldValue, Object givenValue) {
                Object toReplace = Cache.valueOf(oldValue);
                Object newValue = remapping.apply(toReplace, Cache.valueOf(givenValue));
                Cache.ensureValidType(newValue);
                if (newValue != toReplace) {
                    this.changes = new Deferred(key, newValue, this.changes);
                }
                return newValue;
            }
        }
        Adapter adapter = new Adapter();
        Object newValue = this.map.merge(key, value, adapter);
        Deferred.notifyChanges(this, adapter.changes);
        return Cache.valueOf(newValue);
    }

    @Override
    public V remove(Object key) {
        Object oldValue = this.map.remove(key);
        if (oldValue != null) {
            this.notifyChange(key, null);
        }
        return Cache.immediateValueOf(oldValue);
    }

    @Override
    public boolean remove(Object key, Object oldValue) {
        boolean done = this.map.remove(key, oldValue);
        if (done) {
            this.notifyChange(key, null);
        }
        return done;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public V peek(K key) {
        Object value = this.map.get(key);
        if (value instanceof Handler) {
            return null;
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            Object result = ref.get();
            if (result != null && this.map.replace(key, ref, result)) {
                ref.clear();
                this.notifyChange(key, result);
            }
            return (V)result;
        }
        Object result = value;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler<V> lock(K key) {
        Object value;
        Work handler = new Work(key);
        boolean unlock = true;
        handler.lock.lock();
        try {
            while (true) {
                if ((value = this.map.putIfAbsent(key, handler)) == null) {
                    unlock = false;
                    Work work = handler;
                    return work;
                }
                if (!(value instanceof Reference)) {
                    break;
                }
                Reference ref = (Reference)value;
                Object result = ref.get();
                if (result != null) {
                    if (this.map.replace(key, ref, result)) {
                        ref.clear();
                        this.notifyChange(key, result);
                    }
                    Simple simple = new Simple(result);
                    return simple;
                }
                if (!this.map.replace(key, ref, handler)) continue;
                unlock = false;
                Work work = handler;
                return work;
            }
        }
        finally {
            if (unlock) {
                handler.lock.unlock();
            }
        }
        if (value instanceof Handler) {
            Work work = (Work)value;
            if (work.lock.isHeldByCurrentThread()) {
                if (this.isKeyCollisionAllowed()) {
                    return new Simple<Object>(null);
                }
                throw new IllegalStateException(Errors.format((short)123, key));
            }
            return work.new Work.Wait();
        }
        assert (!Cache.isReservedType(value)) : value;
        Object result = value;
        return new Simple<Object>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void adjustReferences(K key, V value) {
        int cost = value != null ? this.cost(value) : 0;
        Map<K, Integer> map = this.costs;
        synchronized (map) {
            Integer old = this.costs.put(key, cost);
            if (old != null) {
                cost -= old.intValue();
            }
            if ((this.totalCost += (long)cost) > this.costLimit) {
                Iterator<Map.Entry<K, Integer>> it = this.costs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<K, Integer> entry = it.next();
                    K oldKey = entry.getKey();
                    Object oldValue = this.map.get(oldKey);
                    if (oldValue != null && !Cache.isReservedType(oldValue)) {
                        Reference ref;
                        Reference reference = ref = this.soft ? new Soft(this.map, oldKey, oldValue) : new Weak(this.map, oldKey, oldValue);
                        if (!this.map.replace(oldKey, oldValue, ref)) {
                            ref.clear();
                        }
                    }
                    it.remove();
                    if ((this.totalCost -= (long)entry.getValue().intValue()) > this.costLimit) continue;
                    break;
                }
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entries;
        return es != null ? es : (this.entries = new CacheEntries(this.map.entrySet()));
    }

    public boolean isKeyCollisionAllowed() {
        return this.isKeyCollisionAllowed;
    }

    public void setKeyCollisionAllowed(boolean allowed) {
        this.isKeyCollisionAllowed = allowed;
    }

    protected int cost(V value) {
        return 1;
    }

    private static final class Weak<K, V>
    extends WeakReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Weak(ConcurrentMap<K, Object> map, K key, V value) {
            super(value, ReferenceQueueConsumer.QUEUE);
            this.map = map;
            this.key = key;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    private static final class Soft<K, V>
    extends SoftReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Soft(ConcurrentMap<K, Object> map, K key, V value) {
            super(value, ReferenceQueueConsumer.QUEUE);
            this.map = map;
            this.key = key;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    final class Work
    extends DelayedRunnable.Immediate
    implements Handler<V>,
    Supplier<V> {
        final ReentrantLock lock = new ReentrantLock();
        final K key;
        private V value;

        Work(K key) {
            this.key = key;
        }

        @Override
        public V get() {
            if (this.lock.isHeldByCurrentThread()) {
                return null;
            }
            this.lock.lock();
            Object v = this.value;
            this.lock.unlock();
            return v;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V result) throws IllegalStateException {
            boolean done;
            try {
                if (Cache.isReservedType(result)) {
                    throw new IllegalArgumentException(Errors.format((short)42, "result", result.getClass()));
                }
                this.value = result;
                done = result != null ? Cache.this.map.replace(this.key, this, result) : Cache.this.map.remove(this.key, this);
            }
            finally {
                this.lock.unlock();
            }
            if (done) {
                DelayedExecutor.schedule(this);
            } else if (!Cache.this.isKeyCollisionAllowed()) {
                throw new IllegalStateException(Errors.format((short)75, this.key));
            }
        }

        @Override
        public void run() {
            Object value = this.value;
            if (value != null) {
                Cache.this.adjustReferences(this.key, value);
            }
        }

        final class Wait
        implements Handler<V> {
            Wait() {
            }

            @Override
            public V peek() {
                return Work.this.get();
            }

            @Override
            public void putAndUnlock(V result) throws IllegalStateException {
                if (result != null && !Cache.this.isKeyCollisionAllowed() && result != Work.this.get()) {
                    throw new IllegalStateException(Errors.format((short)75, Work.this.key));
                }
            }
        }
    }

    private final class Simple<V>
    implements Handler<V> {
        private final V value;

        Simple(V value) {
            this.value = value;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V result) throws IllegalStateException {
            if (result != this.value && !Cache.this.isKeyCollisionAllowed()) {
                throw new IllegalStateException(Errors.format((short)75, "<unknown>"));
            }
        }
    }

    public static interface Handler<V> {
        public V peek();

        public void putAndUnlock(V var1) throws IllegalStateException;
    }

    private final class Strong
    extends DelayedRunnable.Immediate {
        private final K key;
        private final V value;

        Strong(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void run() {
            Cache.this.adjustReferences(this.key, this.value);
        }
    }

    private static final class Deferred<K, V> {
        private final K key;
        private final V value;
        private final Deferred<K, V> next;

        Deferred(K key, V value, Deferred<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        static <K, V> void notifyChanges(Cache<K, V> cache, Deferred<K, V> entry) {
            while (entry != null) {
                cache.notifyChange(entry.key, entry.value);
                entry = entry.next;
            }
        }
    }

    private final class ReplaceAdapter
    implements BiFunction<K, Object, Object> {
        private Deferred<K, V> changes;
        private final BiFunction<? super K, ? super V, ? extends V> remapping;

        ReplaceAdapter(BiFunction<? super K, ? super V, ? extends V> remapping) {
            this.remapping = remapping;
        }

        @Override
        public Object apply(K key, Object oldValue) {
            Object toReplace = Cache.valueOf(oldValue);
            Object newValue = this.remapping.apply(key, toReplace);
            Cache.ensureValidType(newValue);
            if (newValue != toReplace) {
                this.changes = new Deferred(key, newValue, this.changes);
            }
            return newValue;
        }
    }
}

