/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.Containers;
import org.opengis.annotation.UML;

public final class Classes
extends Static {
    private static final Class<Object>[] EMPTY_ARRAY = new Class[0];
    private static final String[] EXCLUDES = new String[]{"clone", "getClass", "hashCode", "toString", "toWKT"};

    private Classes() {
    }

    public static Class<?> changeArrayDimension(Class<?> element, int change) {
        if (change != 0 && element != null) {
            if (change < 0) {
                while ((element = element.getComponentType()) != null && ++change != 0) {
                }
            } else if (element != Void.TYPE) {
                StringBuilder buffer = new StringBuilder();
                do {
                    buffer.insert(0, '[');
                } while (--change != 0);
                if (element.isPrimitive()) {
                    buffer.append(Numbers.getInternal(element));
                } else if (element.isArray()) {
                    buffer.append(element.getName());
                } else {
                    buffer.append('L').append(element.getName()).append(';');
                }
                String name = buffer.toString();
                try {
                    element = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw new TypeNotPresentException(name, e);
                }
            }
        }
        return element;
    }

    public static Class<?> boundOfParameterizedProperty(Field field) {
        return Classes.getActualTypeArgument(field.getGenericType());
    }

    public static Class<?> boundOfParameterizedProperty(Method method) {
        Type[] parameters;
        Class<?> c = Classes.getActualTypeArgument(method.getGenericReturnType());
        if (c == null && (parameters = method.getGenericParameterTypes()) != null && parameters.length == 1) {
            c = Classes.getActualTypeArgument(parameters[0]);
        }
        return c;
    }

    private static Class<?> getActualTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] p = ((ParameterizedType)type).getActualTypeArguments();
            while (p != null && p.length == 1) {
                type = p[0];
                if (type instanceof WildcardType) {
                    p = ((WildcardType)type).getUpperBounds();
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                int dimension = 0;
                while (type instanceof GenericArrayType) {
                    type = ((GenericArrayType)type).getGenericComponentType();
                    ++dimension;
                }
                if (!(type instanceof Class)) break;
                return Classes.changeArrayDimension((Class)type, dimension);
            }
        }
        return null;
    }

    public static <T> Class<? extends T> getClass(T object) {
        return object != null ? object.getClass() : null;
    }

    private static <T> Set<Class<? extends T>> getClasses(Iterable<? extends T> objects) {
        LinkedHashSet<Class<T>> types = new LinkedHashSet<Class<T>>();
        for (T object : objects) {
            types.add(Classes.getClass(object));
        }
        return types;
    }

    public static <T> Class<? super T> getStandardType(Class<T> type) {
        for (Class<T> candidate : Classes.getAllInterfaces(type)) {
            if (!candidate.isAnnotationPresent(UML.class)) continue;
            return candidate;
        }
        for (Class<T> candidate = type; candidate != null; candidate = candidate.getSuperclass()) {
            if (!Modifier.isPublic(candidate.getModifiers()) || candidate.getName().startsWith("org.apache.sis.internal.")) continue;
            return candidate;
        }
        return type;
    }

    public static <T> Class<? super T>[] getAllInterfaces(Class<T> type) {
        Set<Class<?>> interfaces = Classes.getInterfaceSet(type);
        return interfaces != null ? interfaces.toArray(new Class[interfaces.size()]) : EMPTY_ARRAY;
    }

    static Set<Class<?>> getInterfaceSet(Class<?> type) {
        Set<Class<?>> interfaces = null;
        while (type != null) {
            interfaces = Classes.getInterfaceSet(type, interfaces);
            type = type.getSuperclass();
        }
        return interfaces;
    }

    private static Set<Class<?>> getInterfaceSet(Class<?> type, Set<Class<?>> addTo) {
        Class<?>[] interfaces;
        for (Class<?> candidate : interfaces = type.getInterfaces()) {
            if (addTo == null) {
                addTo = new LinkedHashSet(Containers.hashMapCapacity(interfaces.length));
            }
            if (!addTo.add(candidate)) continue;
            Classes.getInterfaceSet(candidate, addTo);
        }
        return addTo;
    }

    public static <T> Class<? extends T>[] getLeafInterfaces(Class<?> type, Class<T> baseInterface) {
        int count = 0;
        Class<Object>[] types = EMPTY_ARRAY;
        while (type != null) {
            Class<?>[] candidates;
            block1: for (Class<Object> clazz : candidates = type.getInterfaces()) {
                if (baseInterface != null && !baseInterface.isAssignableFrom(clazz)) continue;
                for (int i = 0; i < count; ++i) {
                    Class<Object> old = types[i];
                    if (clazz.isAssignableFrom(old)) continue block1;
                    if (!old.isAssignableFrom(clazz)) continue;
                    types[i] = clazz;
                    continue block1;
                }
                if (types == EMPTY_ARRAY) {
                    types = candidates;
                }
                if (count >= types.length) {
                    types = Arrays.copyOf(types, types.length + candidates.length);
                }
                types[count++] = clazz;
            }
            type = type.getSuperclass();
        }
        return ArraysExt.resize(types, count);
    }

    public static Class<?> findSpecializedClass(Iterable<?> objects) {
        Set<Class<?>> types = Classes.getClasses(objects);
        types.remove(null);
        Iterator<Class<?>> it = types.iterator();
        block0: while (it.hasNext()) {
            Class<?> candidate = it.next();
            for (Class<?> type : types) {
                if (candidate == type || !candidate.isAssignableFrom(type)) continue;
                it.remove();
                continue block0;
            }
        }
        return Classes.common(types);
    }

    private static Class<?> common(Set<Class<?>> types) {
        Iterator<Class<?>> it = types.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Class<?> type = it.next();
        while (it.hasNext()) {
            type = Classes.findCommonClass(type, it.next());
        }
        return type;
    }

    public static Class<?> findCommonClass(Iterable<?> objects) {
        Set<Class<?>> types = Classes.getClasses(objects);
        types.remove(null);
        return Classes.common(types);
    }

    public static Class<?> findCommonClass(Class<?> c1, Class<?> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        do {
            if (c1.isAssignableFrom(c2)) {
                return c1;
            }
            if (c2.isAssignableFrom(c1)) {
                return c2;
            }
            c1 = c1.getSuperclass();
            c2 = c2.getSuperclass();
        } while (c1 != null && c2 != null);
        return Object.class;
    }

    public static Set<Class<?>> findCommonInterfaces(Class<?> c1, Class<?> c2) {
        Set<Class<Class<?>>> interfaces = Classes.getInterfaceSet(c1);
        Set<Class<?>> buffer = Classes.getInterfaceSet(c2);
        if (interfaces == null || buffer == null) {
            return Collections.emptySet();
        }
        interfaces.retainAll(buffer);
        Iterator<Class<?>> it = interfaces.iterator();
        while (it.hasNext()) {
            Class<?> candidate = it.next();
            buffer.clear();
            Classes.getInterfaceSet(candidate, buffer);
            if (!interfaces.removeAll(buffer)) continue;
            it = interfaces.iterator();
        }
        return interfaces;
    }

    public static boolean implementSameInterfaces(Class<?> object1, Class<?> object2, Class<?> baseInterface) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = Classes.getLeafInterfaces(object1, baseInterface);
        Class<?>[] c2 = Classes.getLeafInterfaces(object2, baseInterface);
        int n = c2.length;
        for (Class<?> c : c1) {
            int j;
            block4: {
                j = n;
                while (--j >= 0) {
                    if (c != c2[j]) continue;
                    break block4;
                }
                return false;
            }
            System.arraycopy(c2, j + 1, c2, j, --n - j);
        }
        return n == 0;
    }

    public static String getShortName(Class<?> classe) {
        if (classe == null) {
            return "<*>";
        }
        while (classe.isAnonymousClass()) {
            classe = classe.getSuperclass();
        }
        String name = classe.getSimpleName();
        Class<?> enclosing = classe.getEnclosingClass();
        if (enclosing != null) {
            name = Classes.getShortName(enclosing) + '.' + name;
        }
        return name;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    public static boolean isAssignableToAny(Class<?> type, Class<?> ... allowedTypes) {
        if (type != null) {
            if (allowedTypes == null) {
                return true;
            }
            for (Class<?> candidate : allowedTypes) {
                if (candidate == null || !candidate.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPossibleGetter(Method method) {
        return method.getReturnType() != Void.TYPE && method.getParameterCount() == 0 && !method.isSynthetic() && !ArraysExt.contains(EXCLUDES, method.getName());
    }
}

