/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

@StoreMetadata(formatName="SQL", capabilities={Capability.READ})
public class SQLStoreProvider
extends DataStoreProvider {
    static final String NAME = "SQL";
    static final String TABLES = "tables";
    private static final ParameterDescriptor<DataSource> SOURCE_PARAM;
    private static final ParameterDescriptor<GenericName[]> TABLES_PARAM;
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR;
    private static volatile NameSpace tableNS;

    public static GenericName createTableName(String catalog, String schemaPattern, String tablePattern) {
        int numParts;
        ArgumentChecks.ensureNonNull("tablePattern", tablePattern);
        if (catalog != null) {
            numParts = 3;
            if (schemaPattern == null) {
                schemaPattern = "%";
            }
        } else {
            numParts = schemaPattern != null && !schemaPattern.equals("%") ? 2 : 1;
        }
        CharSequence[] names = new String[numParts];
        int i = 0;
        switch (numParts) {
            default: {
                throw new AssertionError(numParts);
            }
            case 3: {
                names[i++] = catalog;
            }
            case 2: {
                names[i++] = schemaPattern;
            }
            case 1: 
        }
        names[i] = tablePattern;
        NameFactory factory = DefaultFactories.forBuildin(NameFactory.class);
        NameSpace ns = tableNS;
        if (ns == null) {
            HashMap<String, String> properties = new HashMap<String, String>(4);
            properties.put("separator", ".");
            properties.put("separator.head", ":");
            tableNS = ns = factory.createNameSpace((GenericName)factory.createLocalName(null, (CharSequence)"database"), properties);
        }
        return factory.createGenericName(ns, names);
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        block10: {
            DataSource ds = connector.getStorageAs(DataSource.class);
            if (ds != null) {
                ProbeResult probeResult;
                block9: {
                    Connection c = ds.getConnection();
                    try {
                        probeResult = ProbeResult.SUPPORTED;
                        if (c == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (c != null) {
                                try {
                                    c.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            String state = e.getSQLState();
                            if ("08001".equals(state) && "3D000".equals(state)) break block10;
                            throw new DataStoreException(e);
                        }
                    }
                    c.close();
                }
                return probeResult;
            }
        }
        return ProbeResult.UNSUPPORTED_STORAGE;
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new SQLStore(this, connector, SQLStoreProvider.createTableName(null, null, "%"));
    }

    @Override
    public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameters", parameters);
        try {
            Parameters p = Parameters.castOrWrap(parameters);
            StorageConnector connector = new StorageConnector(p.getValue(SOURCE_PARAM));
            GenericName[] tableNames = p.getValue(TABLES_PARAM);
            return new SQLStore(this, connector, tableNames);
        }
        catch (UnconvertibleObjectException | ParameterNotFoundException e) {
            throw new IllegalOpenParameterException(e.getMessage(), e);
        }
    }

    static {
        ParameterBuilder builder = new ParameterBuilder();
        SOURCE_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName("location")).setRequired(true).setDescription((CharSequence)Resources.formatInternational((short)1))).create(DataSource.class, null);
        TABLES_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName(TABLES)).setRequired(true).setDescription((CharSequence)Resources.formatInternational((short)2))).create(GenericName[].class, null);
        OPEN_DESCRIPTOR = ((ParameterBuilder)builder.addName(NAME)).createGroup(new GeneralParameterDescriptor[]{SOURCE_PARAM, TABLES_PARAM});
    }
}

