/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.sql.SQLStoreProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;

public class SQLStore
extends DataStore
implements Aggregate {
    private static final String[] NAME_GETTERS = new String[]{"getDescription", "getDataSourceName", "getDatabaseName", "getUrl", "getURL"};
    private final DataSource source;
    private Database model;
    private final GenericName[] tableNames;
    private Metadata metadata;

    protected SQLStore(SQLStoreProvider provider, StorageConnector connector, GenericName ... tableNames) throws DataStoreException {
        super(provider, connector);
        this.source = connector.getStorageAs(DataSource.class);
        ArgumentChecks.ensureNonNull("tableNames", tableNames);
        tableNames = (GenericName[])tableNames.clone();
        for (int i = 0; i < tableNames.length; ++i) {
            GenericName name = tableNames[i];
            ArgumentChecks.ensureNonNullElement("tableNames", i, tableNames);
            int depth = name.depth();
            if (depth >= 1 && depth <= 3) continue;
            throw new IllegalNameException(Resources.format((short)3, name));
        }
        this.tableNames = tableNames;
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        if (this.provider == null) {
            return Optional.empty();
        }
        ParameterValueGroup pg = this.provider.getOpenParameters().createValue();
        pg.parameter("location").setValue((Object)this.source);
        pg.parameter("tables").setValue((Object)this.tableNames);
        return Optional.of(pg);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    private synchronized Database model() throws DataStoreException {
        if (this.model == null) {
            try (Connection c = this.source.getConnection();){
                this.model = new Database(this, c, this.source, this.tableNames, this.listeners);
            }
            catch (SQLException e) {
                throw new DataStoreException(Exceptions.unwrap(e));
            }
        }
        return this.model;
    }

    private Database model(Connection c) throws DataStoreException, SQLException {
        if (this.model == null) {
            this.model = new Database(this, c, this.source, this.tableNames, this.listeners);
        }
        return this.model;
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder builder = new MetadataBuilder();
            builder.addSpatialRepresentation(SpatialRepresentationType.TEXT_TABLE);
            try (Connection c = this.source.getConnection();){
                Database model = this.model(c);
                if (model.hasGeometry) {
                    builder.addSpatialRepresentation(SpatialRepresentationType.VECTOR);
                }
                model.listTables(c.getMetaData(), builder);
            }
            catch (SQLException e) {
                throw new DataStoreException(Exceptions.unwrap(e));
            }
            for (String c : NAME_GETTERS) {
                try {
                    String name;
                    Method method = this.source.getClass().getMethod(c, new Class[0]);
                    if (method.getReturnType() != String.class || (name = (String)method.invoke((Object)this.source, new Object[0])) == null || (name = name.trim()).isEmpty()) continue;
                    builder.addTitle(name);
                    break;
                }
                catch (NoSuchMethodException | SecurityException method) {
                }
                catch (ReflectiveOperationException e) {
                    throw new DataStoreException(Exceptions.unwrap(e));
                }
            }
            this.metadata = builder.build(true);
        }
        return this.metadata;
    }

    public Collection<Resource> components() throws DataStoreException {
        return this.model().tables();
    }

    @Override
    public Resource findResource(String identifier) throws DataStoreException {
        return this.model().findTable(this, identifier);
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    @Override
    public void close() throws DataStoreException {
    }
}

