/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.RasterResource;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.netcdf.MetadataReader;
import org.apache.sis.storage.netcdf.NetcdfStoreProvider;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public class NetcdfStore
extends DataStore
implements Aggregate {
    private final Decoder decoder;
    private final URI location;
    private Metadata metadata;
    private List<Resource> components;

    public NetcdfStore(NetcdfStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.location = connector.getStorageAs(URI.class);
        Path path = connector.getStorageAs(Path.class);
        try {
            this.decoder = NetcdfStoreProvider.decoder(this.listeners, connector);
        }
        catch (IOException | ArithmeticException e) {
            throw new DataStoreException(e);
        }
        if (this.decoder == null) {
            throw new UnsupportedStorageException(super.getLocale(), "NetCDF", connector.getStorage(), connector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.decoder.location = path;
        String id = this.decoder.stringValue("id");
        if (id == null || (id = id.trim()).isEmpty()) {
            id = this.decoder.getFilename();
        }
        if (id != null) {
            DefaultNameFactory f = this.decoder.nameFactory;
            this.decoder.namespace = f.createNameSpace((GenericName)f.createLocalName(null, id), null);
        }
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    public synchronized Version getConventionVersion() throws DataStoreException {
        for (CharSequence value : CharSequences.split(this.decoder.stringValue("Conventions"), ',')) {
            if (!CharSequences.regionMatches(value, 0, "CF-", true)) continue;
            return new Version(value.subSequence(3, value.length()).toString());
        }
        return null;
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        NameSpace namespace = this.decoder.namespace;
        return namespace != null ? Optional.of(namespace.name()) : Optional.empty();
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                MetadataReader reader = new MetadataReader(this.decoder);
                this.metadata = reader.read();
            }
            catch (IOException | ArithmeticException e) {
                throw new DataStoreException(e);
            }
        }
        return this.metadata;
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                Resource[] resources = this.decoder.getDiscreteSampling();
                List<Resource> grids = RasterResource.create(this.decoder, this);
                if (!grids.isEmpty()) {
                    grids.addAll(UnmodifiableArrayList.wrap(resources));
                    resources = grids.toArray(new Resource[grids.size()]);
                }
                this.components = UnmodifiableArrayList.wrap(resources);
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
        return this.components;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.metadata = null;
        try {
            this.decoder.close();
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
    }

    @Override
    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.decoder);
    }
}

