/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.internal.storage.AbstractGridResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.geotiff.Compression;
import org.apache.sis.storage.geotiff.GridGeometryBuilder;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.DateType;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

final class ImageFileDirectory
extends AbstractGridResource {
    private static final byte TILE = 1;
    private static final byte STRIP = 2;
    private static final byte SIGNED = 1;
    private static final byte UNSIGNED = 0;
    private static final byte FLOAT = 3;
    private final Reader reader;
    private final GenericName identifier;
    boolean hasDeferredEntries;
    private long imageWidth = -1L;
    private long imageHeight = -1L;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private Vector tileOffsets;
    private Vector tileByteCounts;
    private byte tileTagFamily;
    private boolean isPlanar;
    private byte sampleFormat;
    private boolean reverseBitsOrder;
    private short bitsPerSample;
    private short samplesPerPixel;
    private Vector extraSamples;
    private byte photometricInterpretation = (byte)-1;
    private Vector colorMap;
    private short cellWidth = (short)-1;
    private short cellHeight = (short)-1;
    private Vector minValues;
    private Vector maxValues;
    private boolean isMinSpecified;
    private boolean isMaxSpecified;
    private double resolution = Double.NaN;
    private Unit<Length> resolutionUnit = Units.INCH;
    private Compression compression;
    private GridGeometryBuilder referencing;
    private List<SampleDimension> sampleDimensions;

    private GridGeometryBuilder referencing() {
        if (this.referencing == null) {
            this.referencing = new GridGeometryBuilder(this.reader);
        }
        return this.referencing;
    }

    ImageFileDirectory(Reader reader, int index) {
        super(reader.owner.listeners());
        this.reader = reader;
        this.identifier = reader.nameFactory.createLocalName(reader.owner.identifier, (CharSequence)String.valueOf(index + 1));
    }

    private ChannelDataInput input() {
        return this.reader.input;
    }

    private String filename() {
        return this.input().filename;
    }

    private Charset encoding() {
        return this.reader.owner.encoding;
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    Object addEntry(short tag, Type type, long count) throws IOException, ParseException, DataStoreException {
        block0 : switch (tag) {
            case 284: {
                int value = type.readInt(this.input(), count);
                switch (value) {
                    case 1: {
                        this.isPlanar = false;
                        break block0;
                    }
                    case 2: {
                        this.isPlanar = true;
                        break block0;
                    }
                }
                return value;
            }
            case 256: {
                this.imageWidth = type.readUnsignedLong(this.input(), count);
                break;
            }
            case 257: {
                this.imageHeight = type.readUnsignedLong(this.input(), count);
                break;
            }
            case 322: {
                this.setTileTagFamily((byte)1);
                this.tileWidth = type.readInt(this.input(), count);
                break;
            }
            case 323: {
                this.setTileTagFamily((byte)1);
                this.tileHeight = type.readInt(this.input(), count);
                break;
            }
            case 278: {
                this.setTileTagFamily((byte)2);
                this.tileHeight = type.readInt(this.input(), count);
                break;
            }
            case 324: {
                this.setTileTagFamily((byte)1);
                this.tileOffsets = type.readVector(this.input(), count);
                break;
            }
            case 273: {
                this.setTileTagFamily((byte)2);
                this.tileOffsets = type.readVector(this.input(), count);
                break;
            }
            case 325: {
                this.setTileTagFamily((byte)1);
                this.tileByteCounts = type.readVector(this.input(), count);
                break;
            }
            case 279: {
                this.setTileTagFamily((byte)2);
                this.tileByteCounts = type.readVector(this.input(), count);
                break;
            }
            case 259: {
                long value = type.readLong(this.input(), count);
                this.compression = Compression.valueOf(value);
                if (this.compression != null) break;
                return value;
            }
            case 266: {
                int value = type.readInt(this.input(), count);
                switch (value) {
                    case 1: {
                        this.reverseBitsOrder = false;
                        break block0;
                    }
                    case 2: {
                        this.reverseBitsOrder = true;
                        break block0;
                    }
                }
                return value;
            }
            case 339: {
                int value = type.readInt(this.input(), count);
                switch (value) {
                    default: {
                        return value;
                    }
                    case 1: {
                        this.sampleFormat = 0;
                        break block0;
                    }
                    case 2: {
                        this.sampleFormat = 1;
                        break block0;
                    }
                    case 3: {
                        this.sampleFormat = (byte)3;
                        break block0;
                    }
                    case 4: 
                }
                this.warning(Level.WARNING, (short)25, this.filename());
                break;
            }
            case 258: {
                Vector values = type.readVector(this.input(), count);
                this.bitsPerSample = values.shortValue(0);
                int length = values.size();
                for (int i = 1; i < length; ++i) {
                    if (values.shortValue(i) == this.bitsPerSample) continue;
                    throw new DataStoreContentException(this.reader.resources().getString((short)3, "BitsPerSample", this.filename(), values));
                }
                break;
            }
            case 277: {
                this.samplesPerPixel = type.readShort(this.input(), count);
                break;
            }
            case 338: {
                this.extraSamples = type.readVector(this.input(), count);
                break;
            }
            case 262: {
                short value = type.readShort(this.input(), count);
                if (value < 0 || value > 127) {
                    return value;
                }
                this.photometricInterpretation = (byte)value;
                break;
            }
            case 320: {
                this.colorMap = type.readVector(this.input(), count);
                break;
            }
            case 280: 
            case 340: {
                this.minValues = ImageFileDirectory.extremum(this.minValues, type.readVector(this.input(), count), false);
                this.isMinSpecified = true;
                break;
            }
            case 281: 
            case 341: {
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, type.readVector(this.input(), count), true);
                this.isMaxSpecified = true;
                break;
            }
            case 254: {
                break;
            }
            case 255: {
                break;
            }
            case -30801: {
                this.referencing().keyDirectory = type.readVector(this.input(), count);
                break;
            }
            case -30800: {
                this.referencing().numericParameters = type.readVector(this.input(), count);
                break;
            }
            case -30799: {
                CharSequence[] values = type.readString(this.input(), count, this.encoding());
                switch (values.length) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.referencing().asciiParameters = values[0];
                        break block0;
                    }
                }
                this.referencing().asciiParameters = String.join((CharSequence)"\u0000", values).concat("\u0000");
                break;
            }
            case 274: {
                break;
            }
            case -31272: {
                int n;
                Vector m = type.readVector(this.input(), count);
                switch (m.size()) {
                    case 6: 
                    case 9: {
                        n = 3;
                        break;
                    }
                    case 12: 
                    case 16: {
                        n = 4;
                        break;
                    }
                    default: {
                        return m;
                    }
                }
                this.referencing().setGridToCRS(m, n);
                break;
            }
            case -31986: {
                Vector m = type.readVector(this.input(), count);
                int size = m.size();
                if (size < 2 || size > 3) {
                    return m;
                }
                this.referencing().setScaleFactors(m);
                break;
            }
            case -31614: {
                this.referencing().modelTiePoints = type.readVector(this.input(), count);
                break;
            }
            case 270: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.addTitle(value);
                }
                break;
            }
            case 315: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.addAuthor(value);
                }
                break;
            }
            case -32104: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.parseLegalNotice(value);
                }
                break;
            }
            case 306: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.addCitationDate(this.reader.getDateFormat().parse(value), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
                }
                break;
            }
            case 316: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.addHostComputer(value);
                }
                break;
            }
            case 305: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.addSoftwareReference(value);
                }
                break;
            }
            case 271: {
                break;
            }
            case 272: {
                for (String value : type.readString(this.input(), count, this.encoding())) {
                    this.reader.metadata.addInstrument(null, value);
                }
                break;
            }
            case 282: 
            case 283: {
                double r = type.readDouble(this.input(), count);
                if (!Double.isNaN(this.resolution) && !(r > this.resolution)) break;
                this.resolution = r;
                break;
            }
            case 296: {
                short unit = type.readShort(this.input(), count);
                switch (unit) {
                    case 1: {
                        this.resolutionUnit = null;
                        break block0;
                    }
                    case 2: {
                        this.resolutionUnit = Units.INCH;
                        break block0;
                    }
                    case 3: {
                        this.resolutionUnit = Units.CENTIMETRE;
                        break block0;
                    }
                }
                return unit;
            }
            case 263: {
                short value = type.readShort(this.input(), count);
                switch (value) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (this.cellWidth < 0 && this.cellHeight < 0) break;
                        return null;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        return value;
                    }
                }
                this.cellWidth = this.cellHeight = (short)(-value);
                break;
            }
            case 264: {
                this.cellWidth = type.readShort(this.input(), count);
                break;
            }
            case 265: {
                this.cellHeight = type.readShort(this.input(), count);
                break;
            }
            case 288: 
            case 289: 
            case 290: 
            case 291: {
                this.warning(Level.FINE, (short)7, Tags.name(tag));
            }
        }
        return null;
    }

    private void setTileTagFamily(byte family) throws DataStoreContentException {
        if (this.tileTagFamily != family && this.tileTagFamily != 0) {
            throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
        }
        this.tileTagFamily = family;
    }

    private static Vector extremum(Vector a, Vector b, boolean max) {
        if (a != null) {
            int s = b.size();
            int i = a.size();
            if (i > s) {
                i = s;
                Vector t = a;
                a = b;
                b = t;
            }
            while (--i >= 0) {
                double va = a.doubleValue(i);
                double vb = b.doubleValue(i);
                if (!Double.isNaN(vb) && !(max ? va > vb : va < vb)) continue;
                b.set(i, va);
            }
        }
        return b;
    }

    private long pixelToByteCount(long value) {
        return (value = Math.multiplyExact(value, this.samplesPerPixel * this.bitsPerSample)) % 8L == 0L ? value / 8L : -1L;
    }

    private int computeTileSize(int knownSize) {
        int n = this.tileByteCounts.size();
        if (n != 0) {
            long count = this.tileByteCounts.longValue(0);
            int i = 0;
            do {
                if (++i != n) continue;
                long length = this.pixelToByteCount(knownSize);
                if (count % length != 0L) break;
                return Math.toIntExact(count / length);
            } while (this.tileByteCounts.longValue(i) == (long)n);
        }
        return -1;
    }

    final void validateMandatoryTags() throws DataStoreContentException {
        int actualCount;
        int missing;
        short byteCountsTag;
        short offsetsTag;
        if (this.imageWidth < 0L) {
            throw this.missingTag((short)256);
        }
        if (this.imageHeight < 0L) {
            throw this.missingTag((short)257);
        }
        switch (this.tileTagFamily) {
            case 2: {
                if (this.tileWidth < 0) {
                    this.tileWidth = Math.toIntExact(this.imageWidth);
                }
                if (this.tileHeight < 0) {
                    this.tileHeight = Math.toIntExact(this.imageHeight);
                }
                offsetsTag = 273;
                byteCountsTag = 279;
                break;
            }
            case 1: {
                offsetsTag = 324;
                byteCountsTag = 325;
                break;
            }
            default: {
                throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
            }
        }
        if (this.tileOffsets == null) {
            throw this.missingTag(offsetsTag);
        }
        if (this.samplesPerPixel == 0) {
            this.samplesPerPixel = 1;
            this.missingTag((short)277, 1L, false);
        }
        if (this.bitsPerSample == 0) {
            this.bitsPerSample = 1;
            this.missingTag((short)258, 1L, false);
        }
        if (this.colorMap != null) {
            this.ensureSameLength((short)320, (short)258, this.colorMap.size(), 3 * (1 << this.bitsPerSample));
        }
        if (this.sampleFormat != 3) {
            long maxValue;
            long minValue;
            if (this.sampleFormat == 0) {
                minValue = 0L;
                maxValue = -1L;
            } else {
                minValue = Long.MIN_VALUE;
                maxValue = Long.MAX_VALUE;
            }
            int shift = 64 - this.bitsPerSample;
            if (shift >= 0 && shift < 64 && (minValue >>>= shift) < (maxValue >>>= shift)) {
                this.minValues = ImageFileDirectory.extremum(this.minValues, Vector.createSequence(minValue, 0, this.samplesPerPixel), false);
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, Vector.createSequence(maxValue, 0, this.samplesPerPixel), true);
            }
        }
        int n = missing = !this.isPlanar && this.compression.equals((Object)Compression.NONE) ? 0 : 8;
        if (this.tileWidth < 0) {
            missing |= 1;
        }
        if (this.tileHeight < 0) {
            missing |= 2;
        }
        if (this.tileByteCounts == null) {
            missing |= 4;
        }
        switch (missing) {
            case 0: 
            case 8: {
                break;
            }
            case 1: {
                this.tileWidth = this.computeTileSize(this.tileHeight);
                this.missingTag((short)322, this.tileWidth, true);
                break;
            }
            case 2: {
                this.tileHeight = this.computeTileSize(this.tileWidth);
                this.missingTag((short)323, this.tileHeight, true);
                break;
            }
            case 4: {
                long tileByteCount = this.pixelToByteCount(Math.multiplyExact(this.tileWidth, this.tileHeight));
                long[] tileByteCountArray = new long[this.tileOffsets.size()];
                Arrays.fill(tileByteCountArray, tileByteCount);
                this.tileByteCounts = Vector.create(tileByteCountArray, true);
                this.missingTag(byteCountsTag, tileByteCount, true);
                break;
            }
            default: {
                short tag;
                switch (Integer.lowestOneBit(missing)) {
                    case 1: {
                        tag = 322;
                        break;
                    }
                    case 2: {
                        tag = 323;
                        break;
                    }
                    default: {
                        tag = byteCountsTag;
                    }
                }
                throw this.missingTag(tag);
            }
        }
        this.ensureSameLength(offsetsTag, byteCountsTag, this.tileOffsets.size(), this.tileByteCounts.size());
        long expectedCount = Math.multiplyExact(Math.addExact(this.imageWidth, (long)(this.tileWidth - 1)) / (long)this.tileWidth, Math.addExact(this.imageHeight, (long)(this.tileHeight - 1)) / (long)this.tileHeight);
        if (this.isPlanar) {
            expectedCount = Math.multiplyExact(expectedCount, (int)this.samplesPerPixel);
        }
        if ((long)(actualCount = Math.min(this.tileOffsets.size(), this.tileByteCounts.size())) != expectedCount) {
            throw new DataStoreContentException(this.reader.resources().getString((short)18, this.filename(), expectedCount, actualCount));
        }
        if (this.referencing != null && !this.referencing.validateMandatoryTags()) {
            throw this.missingTag((short)-31614);
        }
    }

    final void completeMetadata(MetadataBuilder metadata, Locale locale) throws DataStoreContentException, FactoryException {
        metadata.newCoverage(false);
        if (this.compression != null) {
            metadata.addCompression(this.compression.name().toLowerCase(locale));
        }
        int band = 0;
        while (band < this.samplesPerPixel) {
            metadata.newSampleDimension();
            metadata.setBitPerSample(this.bitsPerSample);
            if (this.isMinSpecified) {
                metadata.addMinimumSampleValue(this.minValues.doubleValue(Math.min(band, this.minValues.size() - 1)));
            }
            if (this.isMaxSpecified) {
                metadata.addMaximumSampleValue(this.maxValues.doubleValue(Math.min(band, this.maxValues.size() - 1)));
            }
            metadata.setBandIdentifier(++band);
        }
        if (!Double.isNaN(this.resolution) && this.resolutionUnit != null) {
            metadata.addResolution(this.resolutionUnit.getConverterTo(Units.METRE).convert(this.resolution));
        }
        switch (Math.min(this.cellWidth, this.cellHeight)) {
            case -1: {
                break;
            }
            case -3: {
                metadata.addProcessDescription((CharSequence)Resources.formatInternational((short)15));
                break;
            }
            default: {
                metadata.addProcessDescription((CharSequence)Resources.formatInternational((short)5, this.cellWidth >= 0 ? (int)this.cellWidth : 63, this.cellHeight >= 0 ? (int)this.cellHeight : 63));
            }
        }
        if (this.referencing != null) {
            this.getGridGeometry();
            this.referencing.completeMetadata(metadata);
        }
    }

    @Override
    protected void createMetadata(MetadataBuilder metadata) throws DataStoreException {
        super.createMetadata(metadata);
    }

    @Override
    public GridGeometry getGridGeometry() throws DataStoreContentException {
        if (this.referencing != null) {
            GridGeometry gridGeometry = this.referencing.gridGeometry;
            if (gridGeometry == null) {
                try {
                    gridGeometry = this.referencing.build(this.imageWidth, this.imageHeight);
                }
                catch (FactoryException e) {
                    throw new DataStoreContentException(this.reader.resources().getString((short)26, this.filename()), e);
                }
            }
            return gridGeometry;
        }
        return new GridGeometry(new GridExtent(this.imageWidth, this.imageHeight), null);
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreContentException {
        if (this.sampleDimensions == null) {
            SampleDimension[] dimensions = new SampleDimension[this.samplesPerPixel];
            SampleDimension.Builder builder = new SampleDimension.Builder();
            InternationalString name = Vocabulary.formatInternational((short)111);
            int band = 0;
            while (band < this.samplesPerPixel) {
                builder.addQualitative((CharSequence)name, this.minValues.get(Math.min(band, this.minValues.size() - 1)), this.maxValues.get(Math.min(band, this.maxValues.size() - 1)));
                dimensions[band++] = builder.setName(band).build();
                builder.clear();
            }
            this.sampleDimensions = UnmodifiableArrayList.wrap(dimensions);
        }
        return this.sampleDimensions;
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... range) throws DataStoreException {
        throw new DataStoreException("Not yet implemented.");
    }

    private void warning(Level level, short key, Object ... parameters) {
        LogRecord r = this.reader.resources().getLogRecord(level, key, parameters);
        this.reader.owner.warning(r);
    }

    private void ensureSameLength(short tag1, short tag2, int length1, int length2) {
        if (length1 != length2) {
            this.warning(Level.WARNING, (short)11, Tags.name(tag1), Tags.name(tag2), length1, length2);
        }
    }

    private void missingTag(short missing, long value, boolean computed) {
        this.warning(computed ? Level.WARNING : Level.FINE, computed ? (short)2 : 4, Tags.name(missing), value);
    }

    private DataStoreContentException missingTag(short missing) {
        return new DataStoreContentException(this.reader.resources().getString((short)13, this.filename(), Tags.name(missing)));
    }
}

