/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.util.Version;
import org.opengis.parameter.ParameterDescriptorGroup;

@StoreMetadata(formatName="GeoTIFF", fileSuffixes={"tiff", "tif"}, capabilities={Capability.READ})
public class GeoTiffStoreProvider
extends DataStoreProvider {
    private static final String MIME_TYPE = "image/tiff";
    private static final Version VERSION = new Version("6.0");
    private static final ParameterDescriptorGroup OPEN_DESCRIPTOR = URIDataStore.Provider.descriptor("GeoTIFF");

    @Override
    public String getShortName() {
        return "GeoTIFF";
    }

    @Override
    public ParameterDescriptorGroup getOpenParameters() {
        return OPEN_DESCRIPTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        boolean isBigEndian;
        ByteBuffer buffer = connector.getStorageAs(ByteBuffer.class);
        if (buffer == null) return ProbeResult.UNSUPPORTED_STORAGE;
        if (buffer.remaining() < 4) {
            return ProbeResult.INSUFFICIENT_BYTES;
        }
        int p = buffer.position();
        short order = buffer.getShort(p);
        boolean bl = isBigEndian = order == 19789;
        if (!isBigEndian) {
            if (order != 18761) return ProbeResult.UNSUPPORTED_STORAGE;
        }
        ByteOrder old = buffer.order();
        try {
            buffer.order(isBigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            switch (buffer.getShort(p + 2)) {
                case 42: 
                case 43: {
                    ProbeResult probeResult = new ProbeResult(true, MIME_TYPE, VERSION);
                    return probeResult;
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
        finally {
            buffer.order(old);
        }
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new GeoTiffStore(this, connector);
    }
}

