/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.util.ListOfUnknownSize;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.geotiff.GeoTiffStoreProvider;
import org.apache.sis.storage.geotiff.ImageFileDirectory;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class GeoTiffStore
extends DataStore
implements Aggregate {
    final Charset encoding;
    private Reader reader;
    private final URI location;
    final NameSpace identifier;
    private Metadata metadata;
    private List<GridCoverageResource> components;

    public GeoTiffStore(GeoTiffStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        Charset encoding = connector.getOption(OptionKey.ENCODING);
        this.encoding = encoding != null ? encoding : StandardCharsets.US_ASCII;
        ChannelDataInput input = connector.getStorageAs(ChannelDataInput.class);
        if (input == null) {
            throw new UnsupportedStorageException(super.getLocale(), "GeoTIFF", connector.getStorage(), connector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.location = connector.getStorageAs(URI.class);
        connector.closeAllExcept(input);
        try {
            this.reader = new Reader(this, input);
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        if (this.location != null) {
            NameFactory f = this.reader.nameFactory;
            String filename = IOUtilities.filenameWithoutExtension(input.filename);
            if (Numerics.isUnsignedInteger(filename)) {
                filename = filename + ".tiff";
            }
            this.identifier = f.createNameSpace((GenericName)f.createLocalName(null, (CharSequence)filename), null);
        } else {
            this.identifier = null;
        }
    }

    final StoreListeners listeners() {
        return this.listeners;
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return this.identifier != null ? Optional.of(this.identifier.name()) : Optional.empty();
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            Reader reader = this.reader();
            MetadataBuilder builder = reader.metadata;
            try {
                builder.setFormat("GeoTIFF");
            }
            catch (MetadataStoreException e) {
                builder.addFormatName("GeoTIFF");
                this.listeners.warning(e);
            }
            builder.addEncoding(this.encoding, MetadataBuilder.Scope.METADATA);
            builder.addResourceScope(ScopeCode.valueOf((String)"COVERAGE"), null);
            Locale locale = this.getLocale();
            int n = 0;
            try {
                ImageFileDirectory dir;
                while ((dir = reader.getImageFileDirectory(n++)) != null) {
                    dir.completeMetadata(builder, locale);
                }
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
            catch (ArithmeticException | FactoryException e) {
                throw new DataStoreContentException(this.getLocale(), "GeoTIFF", reader.input.filename, null).initCause(e);
            }
            this.getIdentifier().ifPresent(id -> builder.addTitleOrIdentifier(id.toString(), MetadataBuilder.Scope.ALL));
            builder.setISOStandards(true);
            this.metadata = builder.build(true);
        }
        return this.metadata;
    }

    private DataStoreException errorIO(IOException e) {
        return new DataStoreException(this.errors().getString((short)12, this.reader.input.filename), e);
    }

    private Reader reader() throws DataStoreException {
        Reader r = this.reader;
        if (r == null) {
            throw new DataStoreClosedException(this.getLocale(), "GeoTIFF", StandardOpenOption.READ);
        }
        return r;
    }

    public List<GridCoverageResource> components() throws DataStoreException {
        if (this.components == null) {
            this.components = new Components();
        }
        return this.components;
    }

    @Override
    public GridCoverageResource findResource(String sequence) throws DataStoreException {
        NumberFormatException cause;
        int index;
        try {
            index = Integer.parseInt(sequence);
            cause = null;
        }
        catch (NumberFormatException e) {
            index = 0;
            cause = e;
        }
        if (index > 0) {
            try {
                ImageFileDirectory image = this.reader().getImageFileDirectory(index - 1);
                if (image != null) {
                    return image;
                }
            }
            catch (IOException e) {
                throw this.errorIO(e);
            }
        }
        throw new IllegalNameException(StoreUtilities.resourceNotFound(this, sequence), cause);
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        Reader r = this.reader;
        this.reader = null;
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
    }

    final Errors errors() {
        return Errors.getResources(this.getLocale());
    }

    final void warning(String message, Exception exception) {
        this.listeners.warning(message, exception);
    }

    final void warning(LogRecord record) {
        record.setSourceClassName(GeoTiffStore.class.getName());
        record.setSourceMethodName("getMetadata");
        this.listeners.warning(record);
    }

    private final class Components
    extends ListOfUnknownSize<GridCoverageResource> {
        private int size = -1;

        private Components() {
        }

        @Override
        protected int sizeIfKnown() {
            return this.size;
        }

        @Override
        public int size() {
            if (this.size < 0) {
                this.size = super.size();
            }
            return this.size;
        }

        @Override
        protected boolean exists(int index) {
            return index >= 0 && this.getImageFileDirectory(index) != null;
        }

        @Override
        public GridCoverageResource get(int index) {
            GridCoverageResource image;
            if (index >= 0 && (image = this.getImageFileDirectory(index)) != null) {
                return image;
            }
            throw new IndexOutOfBoundsException(GeoTiffStore.this.errors().getString((short)71, index));
        }

        private GridCoverageResource getImageFileDirectory(int index) {
            try {
                return GeoTiffStore.this.reader().getImageFileDirectory(index);
            }
            catch (IOException e) {
                throw new BackingStoreException(GeoTiffStore.this.errorIO(e));
            }
            catch (DataStoreException e) {
                throw new BackingStoreException(e);
            }
        }
    }
}

