/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.earthobservation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.earthobservation.LandsatReader;
import org.apache.sis.storage.earthobservation.LandsatStoreProvider;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public class LandsatStore
extends DataStore {
    private Reader source;
    private final URI location;
    private Metadata metadata;
    private GenericName identifier;

    public LandsatStore(LandsatStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.location = connector.getStorageAs(URI.class);
        this.source = connector.getStorageAs(Reader.class);
        connector.closeAllExcept(this.source);
        if (this.source == null) {
            throw new UnsupportedStorageException(super.getLocale(), "Landsat", connector.getStorage(), connector.getOption(OptionKey.OPEN_OPTIONS));
        }
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    @Override
    public synchronized Optional<GenericName> getIdentifier() throws DataStoreException {
        if (this.identifier == null) {
            this.identifier = super.getIdentifier().orElse(null);
        }
        return Optional.ofNullable(this.identifier);
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            if (this.source == null) {
                throw new DataStoreClosedException(this.getLocale(), "Landsat", StandardOpenOption.READ);
            }
            try (BufferedReader reader = this.source instanceof BufferedReader ? (BufferedReader)this.source : new LineNumberReader(this.source);){
                this.source = null;
                LandsatReader parser = new LandsatReader(this.getDisplayName(), this.listeners);
                parser.read(reader);
                this.metadata = parser.getMetadata();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
            catch (FactoryException e) {
                throw new DataStoreReferencingException(e);
            }
        }
        return this.metadata;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.metadata = null;
    }
}

