/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class TranslationTransform
extends AbstractLinearTransform
implements ExtendedPrecisionMatrix {
    private static final long serialVersionUID = 7382503993222285134L;
    private final double[] offsets;
    private final double[] errors;

    TranslationTransform(int dimension, double offset) {
        this.offsets = new double[dimension];
        Arrays.fill(this.offsets, offset);
        this.errors = null;
    }

    TranslationTransform(double[] offsets) {
        this.offsets = (double[])offsets.clone();
        this.errors = null;
    }

    TranslationTransform(int size, double[] elements) {
        int n = size * size;
        int dim = size - 1;
        this.offsets = new double[dim];
        double[] errors = null;
        int lastError = -1;
        for (int i = 0; i < dim; ++i) {
            double e;
            int j = dim + i * size;
            this.offsets[i] = elements[j];
            if ((j += n) >= elements.length || (e = elements[j]) == 0.0) continue;
            if (errors == null) {
                errors = new double[dim];
            }
            errors[i] = e;
            lastError = i;
        }
        this.errors = ArraysExt.resize(errors, lastError + 1);
    }

    @Override
    public double[] getExtendedElements() {
        int dim = this.offsets.length;
        int numCol = this.getNumCol();
        int n = this.getNumRow() * numCol;
        double[] elements = new double[this.errors == null ? n : n << 1];
        for (int i = 0; i < dim; ++i) {
            int j = i * numCol;
            elements[j + i] = 1.0;
            elements[j += dim] = this.offsets[i];
            if (this.errors == null || i >= this.errors.length) continue;
            elements[j + n] = this.errors[i];
        }
        elements[n - 1] = 1.0;
        return elements;
    }

    @Override
    public int getSourceDimensions() {
        return this.offsets.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.offsets.length;
    }

    public double getElement(int row, int column) {
        int dim = this.offsets.length;
        ArgumentChecks.ensureBetween("row", 0, dim, row);
        ArgumentChecks.ensureBetween("column", 0, dim, column);
        if (column == row) {
            return 1.0;
        }
        if (column == dim) {
            return this.offsets[row];
        }
        return 0.0;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.offsets.length; ++i) {
            if (this.offsets[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, dim = this.offsets.length, dstOff, dim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = srcPts[srcOff++] + this.offsets[i];
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dim;
        if (srcPts == dstPts && IterationStrategy.suggest(srcOff, dim = this.offsets.length, dstOff, dim, numPts) != IterationStrategy.ASCENDING) {
            srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * dim);
            srcOff = 0;
        }
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + this.offsets[i]);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = (float)(srcPts[srcOff++] + this.offsets[i]);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            for (int i = 0; i < this.offsets.length; ++i) {
                dstPts[dstOff++] = (double)srcPts[srcOff++] + this.offsets[i];
            }
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        return Matrices.createIdentity(this.offsets.length);
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.offsets) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        TranslationTransform that = (TranslationTransform)object;
        return Arrays.equals(this.offsets, that.offsets) && Arrays.equals(this.errors, that.errors);
    }
}

