/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

final class PowerTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 4618931749313510016L;
    final double power;
    private PowerTransform1D inverse;

    protected PowerTransform1D(double power) {
        this.power = power;
    }

    public static MathTransform1D create(double power) {
        if (power == 1.0) {
            return IdentityTransform1D.INSTANCE;
        }
        if (power == 0.0) {
            return ConstantTransform1D.ONE;
        }
        return new PowerTransform1D(power);
    }

    @Override
    public MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new PowerTransform1D(1.0 / this.power);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public double derivative(double value) {
        return this.power * Math.pow(value, this.power - 1.0);
    }

    @Override
    public double transform(double value) {
        return Math.pow(value, this.power);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = Math.pow(srcPts[srcOff++], this.power);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = Math.pow(srcPts[--srcOff], this.power);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)Math.pow(srcPts[srcOff++], this.power);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)Math.pow(srcPts[--srcOff], this.power);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)Math.pow(srcPts[srcOff++], this.power);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = Math.pow(srcPts[srcOff++], this.power);
        }
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        if (other instanceof PowerTransform1D) {
            return PowerTransform1D.create(this.power + ((PowerTransform1D)other).power);
        }
        return super.tryConcatenate(applyOtherFirst, other, factory);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Double.hashCode(this.power);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            return Numerics.equals(this.power, ((PowerTransform1D)object).power);
        }
        return false;
    }
}

