/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameter;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ContextualParameters
extends Parameters
implements Serializable {
    private static final long serialVersionUID = 6769546741493459341L;
    private final ParameterDescriptorGroup descriptor;
    private Matrix normalize;
    private Matrix denormalize;
    private ParameterValue<?>[] values;
    private ContextualParameters inverse;
    private boolean isFrozen;

    public ContextualParameters(OperationMethod method) {
        ArgumentChecks.ensureNonNull("method", method);
        this.descriptor = method.getParameters();
        this.normalize = ContextualParameters.linear("sourceDimensions", method.getSourceDimensions());
        this.denormalize = ContextualParameters.linear("targetDimensions", method.getTargetDimensions());
        this.values = new ParameterValue[this.descriptor.descriptors().size()];
    }

    public ContextualParameters(ParameterDescriptorGroup descriptor, int srcDim, int tgtDim) {
        ArgumentChecks.ensureNonNull("descriptor", descriptor);
        ArgumentChecks.ensureStrictlyPositive("srcDim", srcDim);
        ArgumentChecks.ensureStrictlyPositive("tgtDim", tgtDim);
        this.descriptor = descriptor;
        this.normalize = Matrices.create(++srcDim, srcDim, ExtendedPrecisionMatrix.IDENTITY);
        this.denormalize = Matrices.create(++tgtDim, tgtDim, ExtendedPrecisionMatrix.IDENTITY);
        this.values = new ParameterValue[descriptor.descriptors().size()];
    }

    private ContextualParameters(ParameterDescriptorGroup desc, ContextualParameters forward) {
        this.descriptor = desc;
        this.normalize = forward.getMatrix(MatrixRole.INVERSE_DENORMALIZATION);
        this.denormalize = forward.getMatrix(MatrixRole.INVERSE_NORMALIZATION);
        this.values = forward.values;
        this.inverse = forward;
        this.isFrozen = true;
    }

    private static MatrixSIS linear(String name, Integer size) {
        if (size == null) {
            throw new IllegalArgumentException(Errors.format((short)89, name));
        }
        int n = size + 1;
        return Matrices.create(n, n, ExtendedPrecisionMatrix.IDENTITY);
    }

    final synchronized ContextualParameters inverse(ParameterDescriptorGroup desc) {
        if (this.inverse == null) {
            if (!this.isFrozen) {
                this.freeze();
            }
            this.inverse = new ContextualParameters(desc, this);
        }
        assert (this.inverse.descriptor == desc);
        return this.inverse;
    }

    public final ParameterDescriptorGroup getDescriptor() {
        return this.descriptor;
    }

    private void ensureModifiable() throws IllegalStateException {
        assert (Thread.holdsLock(this));
        if (this.isFrozen) {
            throw new IllegalStateException(Errors.format((short)153, this.getClass()));
        }
    }

    private MatrixSIS toMatrixSIS(Matrix m) {
        return this.isFrozen ? Matrices.unmodifiable(m) : (MatrixSIS)m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MatrixSIS getMatrix(MatrixRole role) {
        MatrixSIS m;
        ContextualParameters inverse;
        Matrix fallback;
        ContextualParameters contextualParameters = this;
        synchronized (contextualParameters) {
            switch (role) {
                default: {
                    throw new AssertionError((Object)role);
                }
                case NORMALIZATION: {
                    return this.toMatrixSIS(this.normalize);
                }
                case DENORMALIZATION: {
                    return this.toMatrixSIS(this.denormalize);
                }
                case INVERSE_NORMALIZATION: {
                    role = MatrixRole.DENORMALIZATION;
                    fallback = this.normalize;
                    break;
                }
                case INVERSE_DENORMALIZATION: {
                    role = MatrixRole.NORMALIZATION;
                    fallback = this.denormalize;
                }
            }
            inverse = this.inverse;
        }
        if (inverse != null) {
            m = inverse.getMatrix(role);
        } else {
            try {
                m = Matrices.inverse(fallback);
            }
            catch (NoninvertibleMatrixException e) {
                throw new IllegalStateException(Errors.format((short)5, (Object)role), (Throwable)((Object)e));
            }
        }
        return Matrices.unmodifiable(m);
    }

    public synchronized MatrixSIS normalizeGeographicInputs(double \u03bb0) {
        this.ensureModifiable();
        DoubleDouble toRadians = DoubleDouble.createDegreesToRadians();
        DoubleDouble offset = null;
        if (\u03bb0 != 0.0) {
            offset = DoubleDouble.createAndGuessError(-\u03bb0);
            offset.multiply(toRadians);
        }
        MatrixSIS normalize = (MatrixSIS)this.normalize;
        normalize.convertBefore(0, toRadians, offset);
        normalize.convertBefore(1, toRadians, null);
        return normalize;
    }

    public synchronized MatrixSIS denormalizeGeographicOutputs(double \u03bb0) {
        this.ensureModifiable();
        DoubleDouble toDegrees = DoubleDouble.createRadiansToDegrees();
        MatrixSIS denormalize = (MatrixSIS)this.denormalize;
        denormalize.convertAfter(0, toDegrees, \u03bb0 != 0.0 ? Double.valueOf(\u03bb0) : null);
        denormalize.convertAfter(1, toDegrees, null);
        return denormalize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform completeTransform(MathTransformFactory factory, MathTransform kernel) throws FactoryException {
        MathTransform d;
        MathTransform n;
        ContextualParameters contextualParameters = this;
        synchronized (contextualParameters) {
            if (!this.isFrozen) {
                this.freeze();
            }
            n = factory.createAffineTransform(this.normalize);
            d = factory.createAffineTransform(this.denormalize);
            Matrix m = MathTransforms.getMatrix(n);
            if (m != null) {
                this.normalize = m;
            }
            if ((m = MathTransforms.getMatrix(d)) != null) {
                this.denormalize = m;
            }
        }
        if (kernel == null) {
            return null;
        }
        return factory.createConcatenatedTransform(factory.createConcatenatedTransform(n, kernel), d);
    }

    private void freeze() {
        this.isFrozen = true;
        IdentityHashMap parameters = new IdentityHashMap(this.values.length);
        for (ParameterValue<?> p : this.values) {
            if (p == null) break;
            ParameterDescriptor desc = (p = DefaultParameterValue.unmodifiable(p)).getDescriptor();
            if (parameters.put(desc, p) == null) continue;
            throw new IllegalStateException(Errors.format((short)27, desc.getName()));
        }
        this.values = new ParameterValue[parameters.size()];
        assert (this.descriptor.descriptors().containsAll(parameters.keySet()));
        Iterator it = this.descriptor.descriptors().iterator();
        int i = 0;
        while (i < this.values.length) {
            ParameterValue p = (ParameterValue)parameters.get(it.next());
            if (p == null) continue;
            this.values[i++] = p;
        }
    }

    public synchronized ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        GeneralParameterDescriptor desc = this.descriptor.descriptor(name);
        if (!(desc instanceof ParameterDescriptor)) {
            throw this.parameterNotFound(name);
        }
        for (int i = 0; i < this.values.length; ++i) {
            ParameterValue<?> p = this.values[i];
            if (p == null) {
                this.values[i] = p = new ContextualParameter((ParameterDescriptor)desc);
                return p;
            }
            if (p.getDescriptor() != desc) continue;
            return p;
        }
        if (this.isFrozen) {
            return ((ParameterDescriptor)desc).createValue();
        }
        throw new ParameterNotFoundException(Errors.format((short)134, this.descriptor.getName()), name);
    }

    public synchronized List<GeneralParameterValue> values() {
        int upper;
        for (upper = this.values.length; upper != 0 && this.values[upper - 1] == null; --upper) {
        }
        return UnmodifiableArrayList.wrap(this.values, 0, upper);
    }

    public List<ParameterValueGroup> groups(String name) {
        throw this.parameterNotFound(name);
    }

    public ParameterValueGroup addGroup(String name) {
        throw this.parameterNotFound(name);
    }

    private ParameterNotFoundException parameterNotFound(String name) {
        return new ParameterNotFoundException(Resources.format((short)61, this.descriptor.getName(), name), name);
    }

    @Override
    public synchronized ContextualParameters clone() {
        ParameterValue<?> p;
        ParameterValue<?>[] param = Arrays.copyOf(this.values, this.descriptor.descriptors().size());
        for (int i = 0; i < param.length && (p = param[i]) != null; ++i) {
            param[i] = param[i].clone();
        }
        ContextualParameters clone = (ContextualParameters)super.clone();
        clone.values = param;
        clone.normalize = this.normalize.clone();
        clone.denormalize = this.denormalize.clone();
        return clone;
    }

    public synchronized int hashCode() {
        return this.normalize.hashCode() + 31 * this.denormalize.hashCode() ^ Arrays.hashCode(this.values) ^ 0x111EE98D;
    }

    public synchronized boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ContextualParameters that = (ContextualParameters)object;
            return Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.normalize, that.normalize) && Objects.equals(this.denormalize, that.denormalize) && Arrays.equals(this.values, that.values);
        }
        return false;
    }

    final int beforeFormat(List<Object> transforms, int index, boolean inverse) {
        Object old;
        MatrixSIS userDefined;
        Object candidate;
        Matrix before = null;
        Matrix after = null;
        if (index != 0 && (candidate = transforms.get(index - 1)) instanceof MathTransform) {
            before = MathTransforms.getMatrix((MathTransform)candidate);
        }
        if (index + 1 < transforms.size() && (candidate = transforms.get(index + 1)) instanceof MathTransform) {
            after = MathTransforms.getMatrix((MathTransform)candidate);
        }
        boolean hasBefore = before != null;
        boolean hasAfter = after != null;
        try {
            userDefined = this.getMatrix(inverse ? MatrixRole.DENORMALIZATION : MatrixRole.INVERSE_NORMALIZATION);
        }
        catch (IllegalStateException e) {
            ContextualParameters.unexpectedException(e);
            return index;
        }
        if (hasBefore) {
            userDefined = userDefined.multiply(before);
        }
        before = Matrices.isIdentity(userDefined, 8.999280057595393E-8) ? null : userDefined;
        try {
            userDefined = this.getMatrix(inverse ? MatrixRole.NORMALIZATION : MatrixRole.INVERSE_DENORMALIZATION);
        }
        catch (IllegalStateException e) {
            ContextualParameters.unexpectedException(e);
            return index;
        }
        if (hasAfter) {
            userDefined = Matrices.multiply(after, userDefined);
        }
        MatrixSIS matrixSIS = after = Matrices.isIdentity(userDefined, 8.999280057595393E-8) ? null : userDefined;
        if (before == null) {
            if (hasBefore) {
                old = transforms.remove(--index);
                assert (old instanceof LinearTransform);
            }
        } else if (hasBefore) {
            old = transforms.set(index - 1, before);
            assert (old instanceof LinearTransform);
        } else {
            transforms.add(index++, before);
        }
        transforms.set(index, new WKT(inverse));
        if (after == null) {
            if (hasAfter) {
                old = transforms.remove(index + 1);
                assert (old instanceof LinearTransform);
            }
        } else if (hasAfter) {
            old = transforms.set(index + 1, after);
            assert (old instanceof LinearTransform);
        } else {
            transforms.add(index + 1, after);
        }
        return index;
    }

    private static void unexpectedException(IllegalStateException e) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.io.wkt"), ConcatenatedTransform.class, "formatTo", e.getCause());
    }

    private final class WKT
    extends FormattableObject
    implements Parameterized {
        private final boolean inverse;

        WKT(boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return ContextualParameters.this.getDescriptor();
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return ContextualParameters.this;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            if (this.inverse) {
                formatter.newLine();
                formatter.append(new WKT(false));
                return "Inverse_MT";
            }
            WKTUtilities.appendParamMT(ContextualParameters.this, formatter);
            return "Param_MT";
        }
    }

    public static enum MatrixRole {
        NORMALIZATION,
        INVERSE_NORMALIZATION,
        DENORMALIZATION,
        INVERSE_DENORMALIZATION;

    }
}

