/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;

final class ConstantTransform1D
extends LinearTransform1D {
    private static final long serialVersionUID = -1583675681650985947L;
    static final ConstantTransform1D ZERO = new ConstantTransform1D(0.0);
    static final ConstantTransform1D ONE = new ConstantTransform1D(1.0);

    ConstantTransform1D(double offset) {
        super(0.0, offset);
    }

    @Override
    public double transform(double value) {
        return this.offset;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        Arrays.fill(dstPts, dstOff, dstOff + numPts, this.offset);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        Arrays.fill(dstPts, dstOff, dstOff + numPts, (float)this.offset);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        Arrays.fill(dstPts, dstOff, dstOff + numPts, (float)this.offset);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        Arrays.fill(dstPts, dstOff, dstOff + numPts, this.offset);
    }
}

