/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedTransformDirect2D
extends ConcatenatedTransformDirect
implements MathTransform2D {
    private static final long serialVersionUID = 6009454091075588885L;

    public ConcatenatedTransformDirect2D(MathTransform2D transform1, MathTransform2D transform2) {
        super((MathTransform)transform1, (MathTransform)transform2);
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 2 && this.getTargetDimensions() == 2;
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        assert (this.isValid());
        MathTransform2D transform1 = (MathTransform2D)this.transform1;
        MathTransform2D transform2 = (MathTransform2D)this.transform2;
        ptDst = transform1.transform(ptSrc, ptDst);
        return transform2.transform(ptDst, ptDst);
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return AbstractMathTransform2D.createTransformedShape(this, shape, null, null, false);
    }

    public Matrix derivative(Point2D point) throws TransformException {
        MathTransform2D transform1 = (MathTransform2D)this.transform1;
        MathTransform2D transform2 = (MathTransform2D)this.transform2;
        Matrix matrix1 = transform1.derivative(point);
        Matrix matrix2 = transform2.derivative(transform1.transform(point, null));
        return Matrices.multiply(matrix2, matrix1);
    }

    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }
}

