/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.provider.LambertCylindricalEqualArea;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.EqualAreaProjection;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class CylindricalEqualArea
extends EqualAreaProjection {
    private static final long serialVersionUID = 8840395516658904421L;
    private final byte variant;

    private static byte getVariant(OperationMethod method) {
        if (CylindricalEqualArea.identMatch(method, "(?i).*\\bSpherical\\b.*", "9834")) {
            return -128;
        }
        return 0;
    }

    public CylindricalEqualArea(OperationMethod method, Parameters parameters) {
        this(CylindricalEqualArea.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, LambertCylindricalEqualArea.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertCylindricalEqualArea.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, CylindricalEqualArea.getVariant(method));
    }

    private CylindricalEqualArea(Initializer initializer) {
        super(initializer);
        this.variant = initializer.variant;
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        double \u03bb0 = initializer.getAndStore(LambertCylindricalEqualArea.LONGITUDE_OF_ORIGIN);
        if (\u03bb0 != 0.0) {
            DoubleDouble offset = DoubleDouble.createDegreesToRadians();
            offset.multiplyGuessError(-\u03bb0);
            denormalize.convertBefore(0, null, offset);
        }
        double \u03c61 = Math.toRadians(initializer.getAndStore(LambertCylindricalEqualArea.STANDARD_PARALLEL));
        DoubleDouble k0 = new DoubleDouble(initializer.scaleAt\u03c6(Math.sin(\u03c61), Math.cos(\u03c61)));
        k0.multiplyGuessError(initializer.getAndStore(Mercator1SP.SCALE_FACTOR));
        DoubleDouble ik = new DoubleDouble(1.0);
        ik.subtract(initializer.eccentricitySquared);
        ik.multiply(0.5);
        ik.divide(k0);
        denormalize.convertAfter(0, k0, null);
        denormalize.convertAfter(1, ik, null);
    }

    CylindricalEqualArea(CylindricalEqualArea other) {
        super(other);
        this.variant = other.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        CylindricalEqualArea kernel = this;
        if (this.variant == -128 || this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(factory, kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        if (dstPts != null) {
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = this.qm_ellipsoid(sin\u03c6);
        }
        return derivate ? new Matrix2(1.0, 0.0, 0.0, this.dqm_d\u03c6(sin\u03c6, Math.cos(\u03c6))) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts != dstPts || srcOff != dstOff || this.getClass() != CylindricalEqualArea.class) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            --dstOff;
            while (--numPts >= 0) {
                double \u03c6 = dstPts[dstOff += 2];
                dstPts[dstOff] = this.qm_ellipsoid(Math.sin(\u03c6));
            }
        }
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = srcPts[srcOff];
        dstPts[dstOff + 1] = this.\u03c6(y);
    }

    private static final class Spherical
    extends CylindricalEqualArea {
        private static final long serialVersionUID = 1063449347697947732L;

        Spherical(CylindricalEqualArea other) {
            super(other);
            this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertAfter(1, 2, null);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03c6 = srcPts[srcOff + 1];
            if (dstPts != null) {
                dstPts[dstOff] = srcPts[srcOff];
                dstPts[dstOff + 1] = Math.sin(\u03c6);
            }
            return derivate ? new Matrix2(1.0, 0.0, 0.0, Math.cos(\u03c6)) : null;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts != dstPts || srcOff != dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                --dstOff;
                while (--numPts >= 0) {
                    double \u03c6 = dstPts[dstOff += 2];
                    dstPts[dstOff] = Math.sin(\u03c6);
                }
            }
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double y = srcPts[srcOff + 1];
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = Math.asin(y);
        }
    }
}

