/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Queue;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.io.TableAppender;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class ProjectedTransformTry
implements Comparable<ProjectedTransformTry> {
    private static final int BUFFER_CAPACITY = 512;
    private String name;
    private final MathTransform projection;
    private final int[] projToGrid;
    float correlation;
    private TransformException error;

    ProjectedTransformTry(ProjectedTransformTry other) {
        this.name = other.name;
        this.projection = other.projection;
        this.projToGrid = other.projToGrid;
    }

    ProjectedTransformTry(float corr) {
        this.projection = null;
        this.projToGrid = null;
        this.correlation = corr;
    }

    ProjectedTransformTry(String name, MathTransform projection, int[] projToGrid, int expectedDimension) {
        ArgumentChecks.ensureNonNull("name", name);
        ArgumentChecks.ensureNonNull("projection", projection);
        this.name = name;
        this.projection = projection;
        this.projToGrid = projToGrid;
        int side = 0;
        int actual = projection.getSourceDimensions();
        if (actual <= expectedDimension && actual == (expectedDimension = projToGrid.length)) {
            actual = projection.getTargetDimensions();
            if (actual == expectedDimension) {
                return;
            }
            side = 1;
        }
        throw new MismatchedDimensionException(Resources.format((short)37, side, expectedDimension, actual));
    }

    final String name() {
        return this.name;
    }

    final MathTransform projection() {
        LinearTransform mt = MathTransforms.linear(Matrices.createDimensionSelect(this.projToGrid.length, this.projToGrid));
        return MathTransforms.concatenate(mt, this.projection);
    }

    final double[][] transform(double[][] coordinates, int numPoints, Queue<double[]> pool) {
        int numDimensions = this.projToGrid.length;
        double[][] results = new double[numDimensions][];
        for (int i = 0; i < numDimensions; ++i) {
            results[i] = pool.poll();
            if (results[i] != null) continue;
            results[i] = new double[numPoints];
        }
        try {
            if (numDimensions == 1) {
                this.projection.transform(coordinates[this.projToGrid[0]], 0, results[0], 0, numPoints);
            } else {
                int bufferCapacity = Math.min(numPoints, 512);
                double[] buffer = new double[bufferCapacity * numDimensions];
                int dataOffset = 0;
                while (dataOffset < numPoints) {
                    int dst;
                    double[] data;
                    int d;
                    int start = dataOffset;
                    int stop = Math.min(start + bufferCapacity, numPoints);
                    for (d = 0; d < numDimensions; ++d) {
                        data = coordinates[this.projToGrid[d]];
                        dataOffset = start;
                        dst = d;
                        do {
                            buffer[dst] = data[dataOffset];
                            dst += numDimensions;
                        } while (++dataOffset < stop);
                    }
                    this.projection.transform(buffer, 0, buffer, 0, stop - start);
                    for (d = 0; d < numDimensions; ++d) {
                        data = results[d];
                        dataOffset = start;
                        dst = d;
                        do {
                            if (Double.isNaN(data[dataOffset] = buffer[dst])) {
                                ProjectedTransformTry.recycle(results, pool);
                                return null;
                            }
                            dst += numDimensions;
                        } while (++dataOffset < stop);
                    }
                }
            }
        }
        catch (TransformException e) {
            this.error = e;
            ProjectedTransformTry.recycle(results, pool);
            return null;
        }
        return results;
    }

    static void recycle(double[][] arrays, Queue<double[]> pool) {
        if (arrays != null) {
            pool.addAll(Arrays.asList(arrays));
        }
    }

    final double[] replace(double[] correlations, double[] newValues) {
        if (newValues.length == correlations.length && ArraysExt.isRange(0, this.projToGrid)) {
            return newValues;
        }
        correlations = (double[])correlations.clone();
        for (int j = 0; j < this.projToGrid.length; ++j) {
            correlations[this.projToGrid[j]] = newValues[j];
        }
        return correlations;
    }

    final MatrixSIS replace(MatrixSIS transform, MatrixSIS newValues) {
        assert (newValues.getNumCol() == transform.getNumCol());
        if (newValues.getNumRow() == transform.getNumRow() && ArraysExt.isRange(0, this.projToGrid)) {
            return newValues;
        }
        transform = transform.clone();
        for (int j = 0; j < this.projToGrid.length; ++j) {
            int d = this.projToGrid[j];
            int i = transform.getNumCol();
            while (--i >= 0) {
                transform.setNumber(d, i, newValues.getNumber(j, i));
            }
        }
        return transform;
    }

    @Override
    public int compareTo(ProjectedTransformTry other) {
        return Float.compare(-this.correlation, -other.correlation);
    }

    final NumberFormat summarize(TableAppender table, NumberFormat nf, Locale locale) {
        if (this.name == null) {
            this.name = Vocabulary.getResources(locale).getString((short)48);
        }
        table.append(this.name).nextColumn();
        String message = "";
        if (this.error != null) {
            message = Exceptions.getLocalizedMessage(this.error, locale);
            if (message == null) {
                message = ((Object)((Object)this.error)).getClass().getSimpleName();
            }
        } else if (this.correlation > 0.0f) {
            if (nf == null) {
                nf = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
                nf.setMinimumFractionDigits(6);
                nf.setMaximumFractionDigits(6);
            }
            message = nf.format(this.correlation);
        }
        table.append(message).nextLine();
        return nf;
    }

    public String toString() {
        TableAppender buffer = new TableAppender("  ");
        this.summarize(buffer, null, null);
        return buffer.toString();
    }
}

