/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.StatisticsFormat;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.operation.builder.LinearTransformBuilder;
import org.apache.sis.referencing.operation.builder.ResidualGrid;
import org.apache.sis.referencing.operation.builder.TransformBuilder;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class LocalizationGridBuilder
extends TransformBuilder {
    private static final double EPS = 1.0E-13;
    private final LinearTransformBuilder linear;
    private final int[] tmp = new int[2];
    private LinearTransform sourceToGrid;
    private double precision;
    private static final double DEFAULT_PRECISION = 1.0E-7;
    private MathTransform transform;

    public LocalizationGridBuilder(int width, int height) {
        this.linear = new LinearTransformBuilder(width, height);
        this.sourceToGrid = MathTransforms.identity(2);
    }

    public LocalizationGridBuilder(Vector sourceX, Vector sourceY) {
        Matrix3 fromGrid = new Matrix3();
        int width = LocalizationGridBuilder.infer(sourceX, fromGrid, 0);
        int height = LocalizationGridBuilder.infer(sourceY, fromGrid, 1);
        this.linear = new LinearTransformBuilder(width, height);
        try {
            this.sourceToGrid = MathTransforms.linear(fromGrid).inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw (ArithmeticException)new ArithmeticException(e.getLocalizedMessage()).initCause(e);
        }
    }

    public LocalizationGridBuilder(LinearTransformBuilder localizations) {
        ArgumentChecks.ensureNonNull("localizations", localizations);
        int n = localizations.getGridDimensions();
        if (n != 2) {
            Vector[] sources;
            if (n < 0 && (n = (sources = localizations.sources()).length) == 2) {
                Matrix3 fromGrid = new Matrix3();
                int width = LocalizationGridBuilder.infer(sources[0], fromGrid, 0);
                int height = LocalizationGridBuilder.infer(sources[1], fromGrid, 1);
                this.linear = new LinearTransformBuilder(width, height);
                this.linear.setControlPoints(localizations.getControlPoints());
                try {
                    this.sourceToGrid = MathTransforms.linear(fromGrid).inverse();
                }
                catch (NoninvertibleTransformException e) {
                    throw (ArithmeticException)new ArithmeticException(e.getLocalizedMessage()).initCause(e);
                }
                this.linear.setLinearizers(localizations);
                return;
            }
            throw new IllegalArgumentException(Resources.format((short)37, 0, 2, n));
        }
        this.linear = localizations;
        this.sourceToGrid = MathTransforms.identity(2);
    }

    private static int infer(Vector source, Matrix fromGrid, int dim) {
        double inc;
        NumberRange<?> range = source.range();
        double min = range.getMinDouble(true);
        double span = range.getMaxDouble(true) - min;
        Number increment = source.increment(1.0E-13 * span);
        if (increment != null) {
            inc = increment.doubleValue();
        } else {
            inc = span;
            int size = source.size();
            for (int i = 0; i < size; ++i) {
                double r;
                double v = source.doubleValue(i) - min;
                if (!(Math.abs(v % inc) > 1.0E-13)) continue;
                do {
                    r = inc % v;
                    inc = v;
                } while (Math.abs(v = r) > 1.0E-13);
            }
        }
        fromGrid.setElement(dim, dim, inc);
        fromGrid.setElement(dim, 2, min);
        double n = span / inc;
        if (n >= 0.5 && n < (double)source.size() - 0.5) {
            return (int)Math.round(n) + 1;
        }
        throw new ArithmeticException(Resources.format((short)75, range));
    }

    private void ensureModifiable() throws IllegalStateException {
        if (!this.linear.isModifiable()) {
            throw new IllegalStateException(Errors.format((short)153, LocalizationGridBuilder.class));
        }
    }

    public void setDesiredPrecision(double precision) {
        this.ensureModifiable();
        ArgumentChecks.ensureStrictlyPositive("precision", precision);
        this.precision = precision;
    }

    public double getDesiredPrecision() {
        return this.precision;
    }

    public void setSourceToGrid(LinearTransform sourceToGrid) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("sourceToGrid", sourceToGrid);
        int isTarget = 0;
        int dim = sourceToGrid.getSourceDimensions();
        if (dim >= 2) {
            isTarget = 1;
            dim = sourceToGrid.getTargetDimensions();
            if (dim == 2) {
                this.sourceToGrid = sourceToGrid;
                return;
            }
        }
        throw new MismatchedDimensionException(Resources.format((short)37, isTarget, 2, dim));
    }

    public LinearTransform getSourceToGrid() {
        return this.sourceToGrid;
    }

    public Envelope getSourceEnvelope(boolean fullArea) throws TransformException {
        Envelope envelope = this.linear.getSourceEnvelope();
        if (fullArea) {
            int i = envelope.getDimension();
            while (--i >= 0) {
                GeneralEnvelope ge = GeneralEnvelope.castOrCopy(envelope);
                ge.setRange(i, ge.getLower(i) - 0.5, ge.getUpper(i) + 0.5);
                envelope = ge;
            }
        }
        return Envelopes.transform(this.sourceToGrid.inverse(), envelope);
    }

    public void setControlPoints(Vector ... coordinates) {
        this.ensureModifiable();
        ArgumentChecks.ensureNonNull("coordinates", coordinates);
        this.linear.setControlPoints(coordinates);
    }

    public void setControlPoint(int gridX, int gridY, double ... target) {
        this.ensureModifiable();
        this.tmp[0] = gridX;
        this.tmp[1] = gridY;
        this.linear.setControlPoint(this.tmp, target);
    }

    public double[] getControlPoint(int gridX, int gridY) {
        this.tmp[0] = gridX;
        this.tmp[1] = gridY;
        return this.linear.getControlPoint(this.tmp);
    }

    public Vector getRow(int dimension, int row) {
        this.tmp[0] = 0;
        this.tmp[1] = row;
        return this.linear.getTransect(dimension, this.tmp, 0);
    }

    public Vector getColumn(int dimension, int column) {
        this.tmp[0] = column;
        this.tmp[1] = 0;
        return this.linear.getTransect(dimension, this.tmp, 1);
    }

    public NumberRange<Double> resolveWraparoundAxis(int dimension, int direction, double period) {
        this.ensureModifiable();
        ArgumentChecks.ensureBetween("dimension", 0, this.linear.getTargetDimensions() - 1, dimension);
        ArgumentChecks.ensureBetween("direction", 0, this.linear.getSourceDimensions() - 1, direction);
        ArgumentChecks.ensureStrictlyPositive("period", period);
        return this.linear.resolveWraparoundAxis(dimension, direction, period);
    }

    public void addLinearizers(Map<String, MathTransform> projections, int ... dimensions) {
        this.ensureModifiable();
        this.linear.addLinearizers(projections, dimensions);
    }

    @Override
    public MathTransform create(MathTransformFactory factory) throws FactoryException {
        if (this.transform == null) {
            MathTransform step;
            LinearTransform gridToCoord = this.linear.create(factory);
            boolean isExact = true;
            boolean isLinear = true;
            for (double c : this.linear.correlation()) {
                isExact &= c == 1.0;
                if (c >= 0.9999) continue;
                isLinear = false;
                break;
            }
            if (isExact) {
                step = MathTransforms.concatenate(this.sourceToGrid, gridToCoord);
            } else {
                int width = this.linear.gridSize(0);
                int height = this.linear.gridSize(1);
                float[] residual = new float[2 * this.linear.gridLength];
                double[] grid = new double[2 * width];
                double gridPrecision = this.precision;
                try {
                    if (gridPrecision > 0.0 && !this.sourceToGrid.isIdentity()) {
                        double[] vector = new double[this.sourceToGrid.getSourceDimensions()];
                        double[] offset = new double[this.sourceToGrid.getTargetDimensions()];
                        double converted = 0.0;
                        for (int i = 0; i < vector.length; ++i) {
                            vector[i] = this.precision;
                            this.sourceToGrid.deltaTransform(vector, 0, offset, 0, 1);
                            double length = MathFunctions.magnitude(offset);
                            if (length > converted) {
                                converted = length;
                            }
                            vector[i] = 0.0;
                        }
                        gridPrecision = converted;
                    }
                    LinearTransform coordToGrid = gridToCoord.inverse();
                    int k = 0;
                    for (int y = 0; y < height; ++y) {
                        this.tmp[0] = 0;
                        this.tmp[1] = y;
                        this.linear.getControlRow(this.tmp, grid);
                        coordToGrid.transform(grid, 0, grid, 0, width);
                        int i = 0;
                        for (int x = 0; x < width; ++x) {
                            double dx = grid[i++] - (double)x;
                            double dy = grid[i++] - (double)y;
                            isLinear &= dx <= gridPrecision;
                            isLinear &= dy <= gridPrecision;
                            residual[k++] = (float)dx;
                            residual[k++] = (float)dy;
                        }
                    }
                }
                catch (TransformException e) {
                    throw new FactoryException((Throwable)e);
                }
                step = isLinear ? MathTransforms.concatenate(this.sourceToGrid, gridToCoord) : InterpolatedTransform.createGeodeticTransformation(LocalizationGridBuilder.nonNull(factory), new ResidualGrid(this.sourceToGrid, gridToCoord, width, height, residual, gridPrecision > 0.0 ? gridPrecision : 1.0E-7));
            }
            Optional<MathTransform> linearizer = this.linear.linearizer();
            if (linearizer.isPresent()) {
                try {
                    step = factory.createConcatenatedTransform(step, linearizer.get().inverse());
                }
                catch (NoninvertibleTransformException e) {
                    throw new InvalidGeodeticParameterException(Resources.format((short)52, this.linear.linearizerID()), e);
                }
            }
            this.transform = step;
        }
        return this.transform;
    }

    public Statistics[] error(MathTransform mt) throws NoninvertibleTransformException {
        int tgtDim = mt.getTargetDimensions();
        double[] point = new double[Math.max(tgtDim, 2)];
        Statistics[] stats = new Statistics[tgtDim + 2];
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < stats.length; ++i) {
            buffer.setLength(0);
            if (i < tgtDim) {
                buffer.append("P \u2192 ");
                if (i < 3) {
                    buffer.append((char)(120 + i));
                } else {
                    buffer.append('z').append(i - 1);
                }
            } else {
                buffer.append((char)(105 + (i - tgtDim))).append(" \u2190 P\u2032");
            }
            stats[i] = new Statistics(buffer.toString());
        }
        Optional<MathTransform> linearizer = this.linear.linearizer();
        MathTransform complete = linearizer.isPresent() ? linearizer.get().inverse() : null;
        MathTransform inverse = mt.inverse();
        int width = this.linear.gridSize(0);
        int height = this.linear.gridSize(1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i;
                double[] expected;
                block13: {
                    this.tmp[0] = x;
                    point[0] = this.tmp[0];
                    this.tmp[1] = y;
                    point[1] = this.tmp[1];
                    try {
                        mt.transform(point, 0, point, 0, 1);
                        expected = this.linear.getControlPoint(this.tmp);
                        if (complete == null) break block13;
                        complete.transform(expected, 0, expected, 0, 1);
                    }
                    catch (TransformException e) {
                        continue;
                    }
                }
                for (i = 0; i < tgtDim; ++i) {
                    stats[i].accept(point[i] - expected[i]);
                }
                try {
                    inverse.transform(expected, 0, expected, 0, 1);
                }
                catch (TransformException e) {
                    continue;
                }
                for (i = 0; i < 2; ++i) {
                    stats[tgtDim + i].accept(expected[i] - (double)this.tmp[i]);
                }
            }
        }
        return stats;
    }

    public String toString(Locale locale) {
        StringBuilder buffer = new StringBuilder(400);
        String lineSeparator = null;
        try {
            lineSeparator = this.linear.appendTo(buffer, this.getClass(), locale, (short)165);
            if (this.transform != null) {
                buffer.append("\u25b6\u00a0");
                Vocabulary vocabulary = Vocabulary.getResources(locale);
                vocabulary.appendLabel((short)167, buffer);
                buffer.append(lineSeparator);
                StatisticsFormat sf = locale != null ? StatisticsFormat.getInstance(locale) : StatisticsFormat.getInstance();
                sf.format(this.error(this.transform), (Appendable)buffer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        Strings.insertLineInLeftMargin(buffer, lineSeparator);
        return buffer.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

