/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.List;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.FactoryException;

final class SubOperationInfo {
    private static final Class<?>[][] COMPATIBLE_TYPES = new Class[][]{{GeodeticCRS.class}, {VerticalCRS.class, GeodeticCRS.class}, {TemporalCRS.class}, {DefaultParametricCRS.class}, {EngineeringCRS.class}, {ImageCRS.class}};
    final CoordinateOperation operation;
    final int startAtDimension;
    final int endAtDimension;

    private static Class<?> type(SingleCRS crs) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = (SingleCRS)((GeneralDerivedCRS)crs).getBaseCRS();
        }
        return crs.getClass();
    }

    private SubOperationInfo(CoordinateOperation operation, int startAtDimension, int endAtDimension) {
        this.operation = operation;
        this.startAtDimension = startAtDimension;
        this.endAtDimension = endAtDimension;
    }

    static SubOperationInfo create(CoordinateOperationFinder caller, boolean[] sourceIsUsed, List<? extends SingleCRS> sources, SingleCRS target) throws FactoryException {
        OperationNotFoundException failure = null;
        Class<?> targetType = SubOperationInfo.type(target);
        for (Class<?>[] sourceTypes : COMPATIBLE_TYPES) {
            if (!sourceTypes[0].isAssignableFrom(targetType)) continue;
            for (Class<?> sourceType : sourceTypes) {
                int endAtDimension = 0;
                for (int i = 0; i < sourceIsUsed.length; ++i) {
                    CoordinateOperation operation;
                    SingleCRS source = sources.get(i);
                    int startAtDimension = endAtDimension;
                    endAtDimension += source.getCoordinateSystem().getDimension();
                    if (sourceIsUsed[i] || !sourceType.isAssignableFrom(SubOperationInfo.type(source))) continue;
                    try {
                        operation = caller.createOperation((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)target);
                    }
                    catch (OperationNotFoundException exception) {
                        if (failure == null) {
                            failure = exception;
                            continue;
                        }
                        failure.addSuppressed((Throwable)exception);
                        continue;
                    }
                    sourceIsUsed[i] = true;
                    if (failure != null) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.operation"), CoordinateOperationFinder.class, "decompose", failure);
                    }
                    return new SubOperationInfo(operation, startAtDimension, endAtDimension);
                }
            }
        }
        if (failure != null) {
            throw failure;
        }
        return null;
    }

    static int startOfIdentity(SubOperationInfo[] selected) {
        int n = selected.length;
        while (n != 0 && selected[--n].operation.getMathTransform().isIdentity()) {
        }
        return n;
    }

    static Matrix sourceToSelected(int sourceDimensions, int selectedDimensions, SubOperationInfo[] selected) {
        MatrixSIS select = Matrices.createZero(selectedDimensions + 1, sourceDimensions + 1);
        select.setElement(selectedDimensions, sourceDimensions, 1.0);
        int j = 0;
        for (SubOperationInfo component : selected) {
            for (int i = component.startAtDimension; i < component.endAtDimension; ++i) {
                select.setElement(j++, i, 1.0);
            }
        }
        return select;
    }
}

