/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.util.InternationalString;

final class FinalLocationType
extends AbstractLocationType
implements Serializable {
    private static final long serialVersionUID = 9032473745502779734L;
    private final InternationalString name;
    private final InternationalString theme;
    private final List<InternationalString> identifications;
    private final InternationalString definition;
    private final ReferencingByIdentifiers referenceSystem;
    private final GeographicExtent territoryOfUse;
    private final AbstractParty owner;
    private final List<AbstractLocationType> parents;
    final List<AbstractLocationType> children;

    private FinalLocationType(AbstractLocationType source, ReferencingByIdentifiers rs, Map<AbstractLocationType, FinalLocationType> existing) {
        existing.put(source, this);
        this.name = source.getName();
        InternationalString theme = source.getTheme();
        this.identifications = FinalLocationType.snapshot(source.getIdentifications());
        this.definition = source.getDefinition();
        GeographicExtent territoryOfUse = (GeographicExtent)FinalLocationType.unmodifiable(source.getTerritoryOfUse());
        AbstractParty owner = (AbstractParty)FinalLocationType.unmodifiable(source.getOwner());
        this.parents = FinalLocationType.snapshot(source.getParents(), rs, existing);
        this.children = FinalLocationType.snapshot(source.getChildren(), rs, existing);
        this.referenceSystem = rs;
        if (rs != null) {
            Extent domainOfValidity;
            if (theme == null) {
                theme = rs.getTheme();
            }
            if (owner == null) {
                owner = rs.getOverallOwner();
            }
            if (territoryOfUse == null && (domainOfValidity = rs.getDomainOfValidity()) instanceof GeographicExtent) {
                territoryOfUse = (GeographicExtent)domainOfValidity;
            }
        }
        this.theme = theme;
        this.territoryOfUse = territoryOfUse;
        this.owner = owner;
    }

    static List<AbstractLocationType> snapshot(Collection<? extends AbstractLocationType> types, ReferencingByIdentifiers rs, Map<AbstractLocationType, FinalLocationType> existing) {
        AbstractLocationType[] array = types.toArray(new AbstractLocationType[types.size()]);
        for (int i = 0; i < array.length; ++i) {
            AbstractLocationType source = array[i];
            ArgumentChecks.ensureNonNullElement("types", i, source);
            FinalLocationType copy = existing.get(source);
            if (copy == null) {
                copy = new FinalLocationType(source, rs, existing);
            }
            array[i] = copy;
        }
        switch (array.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(array[0]);
            }
        }
        return UnmodifiableArrayList.wrap(array);
    }

    private static List<InternationalString> snapshot(Collection<? extends InternationalString> c) {
        if (c instanceof UnmodifiableArrayList) {
            return (List)c;
        }
        return UnmodifiableArrayList.wrap(c.toArray(new InternationalString[c.size()]));
    }

    private static Object unmodifiable(Object metadata) {
        if (metadata instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)metadata).unmodifiable();
        }
        return metadata;
    }

    @Override
    public InternationalString getName() {
        return this.name;
    }

    @Override
    public InternationalString getTheme() {
        return this.theme;
    }

    public Collection<InternationalString> getIdentifications() {
        return this.identifications;
    }

    @Override
    public InternationalString getDefinition() {
        return this.definition;
    }

    @Override
    public GeographicExtent getTerritoryOfUse() {
        return this.territoryOfUse;
    }

    @Override
    public ReferencingByIdentifiers getReferenceSystem() {
        return this.referenceSystem;
    }

    @Override
    public AbstractParty getOwner() {
        return this.owner;
    }

    public Collection<AbstractLocationType> getParents() {
        return this.parents;
    }

    public Collection<AbstractLocationType> getChildren() {
        return this.children;
    }
}

