/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.sis.internal.system.ReferenceQueueConsumer;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

final class CloseableReference<T>
extends WeakReference<T>
implements Disposable {
    private final EPSGDataAccess factory;
    private final Statement[] statements;

    CloseableReference(T ref, EPSGDataAccess factory, Statement[] statements) {
        super(ref, ReferenceQueueConsumer.QUEUE);
        this.statements = statements;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws SQLException {
        SQLException exception = null;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int i = this.statements.length;
            while (--i >= 0) {
                Statement s = this.statements[i];
                this.statements[i] = null;
                if (s == null) continue;
                try {
                    s.close();
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void dispose() {
        try {
            this.close();
        }
        catch (SQLException exception) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.referencing.factory"), AuthorityCodes.class, "close", exception);
        }
    }
}

