/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.AuthorityFactoryProxy;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    static final ComparisonMode COMPARISON_MODE = ComparisonMode.APPROXIMATE;
    protected final AuthorityFactory factory;
    private transient AuthorityFactoryProxy<?> proxy;
    private IdentifiedObjectFinder wrapper;
    private Domain domain = Domain.VALID_DATASET;
    private boolean ignoreAxes;
    boolean ignoreIdentifiers;

    protected IdentifiedObjectFinder(AuthorityFactory factory) {
        ArgumentChecks.ensureNonNull("factory", factory);
        this.factory = factory;
    }

    final void setWrapper(IdentifiedObjectFinder other) {
        this.wrapper = other;
        this.setSearchDomain(other.domain);
        this.setIgnoringAxes(other.ignoreAxes);
    }

    public Domain getSearchDomain() {
        return this.domain;
    }

    public void setSearchDomain(Domain domain) {
        ArgumentChecks.ensureNonNull("domain", (Object)domain);
        this.domain = domain;
    }

    public boolean isIgnoringAxes() {
        return this.ignoreAxes;
    }

    public void setIgnoringAxes(boolean ignore) {
        this.ignoreAxes = ignore;
    }

    private boolean match(IdentifiedObject candidate, IdentifiedObject object) {
        return Utilities.deepEquals(candidate, object, this.ignoreAxes ? ComparisonMode.ALLOW_VARIANT : COMPARISON_MODE);
    }

    Set<IdentifiedObject> getFromCache(IdentifiedObject object) {
        return this.wrapper != null ? this.wrapper.getFromCache(object) : null;
    }

    Set<IdentifiedObject> cache(IdentifiedObject object, Set<IdentifiedObject> result) {
        if (this.wrapper != null) {
            result = this.wrapper.cache(object, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
        ArgumentChecks.ensureNonNull("object", object);
        Set<IdentifiedObject> result = this.getFromCache(object);
        if (result == null) {
            AuthorityFactoryProxy<?> previous = this.proxy;
            this.proxy = AuthorityFactoryProxy.getInstance(object.getClass());
            try {
                if (!this.ignoreIdentifiers && !this.ignoreAxes) {
                    IdentifiedObject candidate = this.createFromIdentifiers(object);
                    if (candidate != null) {
                        Set<IdentifiedObject> set = Collections.singleton(candidate);
                        return set;
                    }
                    candidate = this.createFromNames(object);
                    if (candidate != null) {
                        Set<IdentifiedObject> set = Collections.singleton(candidate);
                        return set;
                    }
                }
                if (this.domain == Domain.DECLARATION) {
                    Set<IdentifiedObject> set = Collections.emptySet();
                    return set;
                }
                result = this.createFromCodes(object);
            }
            finally {
                this.proxy = previous;
            }
            result = this.cache(object, result);
        }
        return result;
    }

    public IdentifiedObject findSingleton(IdentifiedObject object) throws FactoryException {
        IdentifiedObject result = null;
        boolean sameAxisOrder = false;
        boolean ambiguous = false;
        try {
            for (IdentifiedObject candidate : this.find(object)) {
                boolean so;
                boolean bl = so = !this.ignoreAxes || Utilities.deepEquals(candidate, object, COMPARISON_MODE);
                if (result != null) {
                    ambiguous = true;
                    if (sameAxisOrder && so) {
                        return null;
                    }
                }
                result = candidate;
                sameAxisOrder = so;
            }
        }
        catch (BackingStoreException e) {
            throw e.unwrapOrRethrow(FactoryException.class);
        }
        return sameAxisOrder || !ambiguous ? result : null;
    }

    private IdentifiedObject createFromIdentifiers(IdentifiedObject object) throws FactoryException {
        for (Identifier id : object.getIdentifiers()) {
            IdentifiedObject candidate;
            String code = IdentifiedObjects.toString(id);
            if (code.indexOf(58) < 0) continue;
            try {
                candidate = this.create(code);
            }
            catch (NoSuchAuthorityCodeException e) {
                IdentifiedObjectFinder.exceptionOccurred((FactoryException)((Object)e));
                continue;
            }
            if (!this.match(candidate, object)) continue;
            return candidate;
        }
        return null;
    }

    private IdentifiedObject createFromNames(IdentifiedObject object) throws FactoryException {
        IdentifiedObject candidate;
        String code = object.getName().getCode();
        try {
            candidate = this.create(code);
        }
        catch (FactoryException e) {
            IdentifiedObjectFinder.exceptionOccurred(e);
            candidate = null;
        }
        if (this.match(candidate, object)) {
            return candidate;
        }
        for (GenericName id : object.getAlias()) {
            code = id.toString();
            try {
                candidate = this.create(code);
            }
            catch (FactoryException e) {
                IdentifiedObjectFinder.exceptionOccurred(e);
                continue;
            }
            if (!this.match(candidate, object)) continue;
            return candidate;
        }
        return null;
    }

    Set<IdentifiedObject> createFromCodes(IdentifiedObject object) throws FactoryException {
        LinkedHashSet<IdentifiedObject> result = new LinkedHashSet<IdentifiedObject>();
        for (String code : this.getCodeCandidates(object)) {
            IdentifiedObject candidate;
            try {
                candidate = this.create(code);
            }
            catch (FactoryException e) {
                IdentifiedObjectFinder.exceptionOccurred(e);
                continue;
            }
            if (!this.match(candidate, object)) continue;
            result.add(candidate);
        }
        return result;
    }

    private IdentifiedObject create(String code) throws FactoryException {
        return (IdentifiedObject)this.proxy.createFromAPI(this.factory, code);
    }

    protected Set<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
        return this.factory.getAuthorityCodes(this.proxy.type.asSubclass(IdentifiedObject.class));
    }

    private static void exceptionOccurred(FactoryException exception) {
        LogRecord record = new LogRecord(Level.FINER, exception.getMessage());
        record.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(IdentifiedObjectFinder.class, "find", record);
    }

    public static enum Domain {
        DECLARATION,
        VALID_DATASET,
        ALL_DATASET;

    }
}

