/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.factory.FilteredCodes;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class CommonAuthorityFactory
extends GeodeticAuthorityFactory
implements CRSAuthorityFactory {
    private static final String AUTO2 = "AUTO2";
    private static final Set<String> CODESPACES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("OGC", "CRS", "AUTO", "AUTO2")));
    private static final int LEGACY_MASK = Integer.MIN_VALUE;
    private static final int FIRST_PROJECTION_CODE = 42001;
    private static final String[] PROJECTION_NAMES = new String[]{"WGS 84 / Auto UTM", "WGS 84 / Auto Tr. Mercator", "WGS 84 / Auto Orthographic", "WGS 84 / Auto Equirectangular", "WGS 84 / Auto Mollweide"};
    static final char SEPARATOR = ',';
    private final Map<String, Class<?>> codes = new LinkedHashMap();
    private CoordinateReferenceSystem displayCRS;
    private volatile CartesianCS projectedCS;

    @Override
    public Citation getAuthority() {
        return Citations.WMS;
    }

    static String reformat(String code) {
        try {
            return CommonAuthorityFactory.format(Integer.parseInt(code.substring(CommonAuthorityFactory.skipNamespace(code) & Integer.MAX_VALUE)));
        }
        catch (NumberFormatException | NoSuchAuthorityCodeException e) {
            Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.factory"), CommonAuthorityFactory.class, "reformat", e);
            return null;
        }
    }

    private static int skipNamespace(String code) throws NoSuchAuthorityCodeException {
        int end;
        int start;
        int isLegacy = 0;
        int s = code.indexOf(58);
        if (s >= 0 && !CommonAuthorityFactory.regionMatches("CRS", code, start = CharSequences.skipLeadingWhitespaces(code, 0, end = CharSequences.skipTrailingWhitespaces(code, 0, s)), end) && !CommonAuthorityFactory.regionMatches("OGC", code, start, end)) {
            boolean isRecognized = false;
            int length = AUTO2.length() - 1;
            if (code.regionMatches(true, start, AUTO2, 0, length)) {
                switch (end - start - length) {
                    case 0: {
                        isRecognized = true;
                        isLegacy = Integer.MIN_VALUE;
                        break;
                    }
                    case 1: {
                        char c = code.charAt(end - 1);
                        boolean bl = isRecognized = c >= '1' && c <= '2';
                        if (c != '1') break;
                        isLegacy = Integer.MIN_VALUE;
                    }
                }
            }
            if (!isRecognized) {
                throw new NoSuchAuthorityCodeException(Resources.format((short)66, CharSequences.trimWhitespaces(code, 0, s)), "OGC", code);
            }
        }
        if (code.regionMatches(true, s = CharSequences.skipLeadingWhitespaces(code, s + 1, code.length()), "CRS", 0, "CRS".length())) {
            s = CharSequences.skipLeadingWhitespaces(code, s + "CRS".length(), code.length());
        }
        if (s >= code.length()) {
            throw new NoSuchAuthorityCodeException(Errors.format((short)29, "code"), "OGC", code);
        }
        return s | isLegacy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        ArgumentChecks.ensureNonNull("type", type);
        if (!type.isAssignableFrom(SingleCRS.class) && !SingleCRS.class.isAssignableFrom(type)) {
            return Collections.emptySet();
        }
        Map<String, Class<?>> map = this.codes;
        synchronized (map) {
            if (this.codes.isEmpty()) {
                this.add(1, EngineeringCRS.class);
                this.add(27, GeographicCRS.class);
                this.add(83, GeographicCRS.class);
                this.add(84, GeographicCRS.class);
                this.add(88, VerticalCRS.class);
                for (int code = 42001; code < 42001 + PROJECTION_NAMES.length; ++code) {
                    this.add(code, ProjectedCRS.class);
                }
            }
        }
        return new FilteredCodes(this.codes, type).keySet();
    }

    private static String format(int code) {
        return (code >= 42001 ? AUTO2 : "CRS") + ':' + code;
    }

    private void add(int code, Class<? extends SingleCRS> type) throws FactoryException {
        assert (code >= 42001 == ProjectedCRS.class.isAssignableFrom(type)) : code;
        if (this.codes.put(CommonAuthorityFactory.format(code), type) != null) {
            throw new FactoryException();
        }
    }

    @Override
    public Set<String> getCodeSpaces() {
        return CODESPACES;
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        int s = CommonAuthorityFactory.skipNamespace(code) & Integer.MAX_VALUE;
        String localCode = code.substring(s, CharSequences.skipTrailingWhitespaces(code, s, code.length()));
        if (localCode.indexOf(44) < 0) {
            int codeValue;
            try {
                codeValue = Integer.parseInt(localCode);
            }
            catch (NumberFormatException exception) {
                throw CommonAuthorityFactory.noSuchAuthorityCode(localCode, code, exception);
            }
            int i = codeValue - 42001;
            if (i >= 0 && i < PROJECTION_NAMES.length) {
                return new SimpleInternationalString(PROJECTION_NAMES[i]);
            }
        }
        return new SimpleInternationalString(this.createCoordinateReferenceSystem(localCode).getName().getCode());
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.createCoordinateReferenceSystem(code);
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        CommonCRS crs;
        ArgumentChecks.ensureNonNull("code", code);
        String complement = null;
        int start = CommonAuthorityFactory.skipNamespace(code);
        boolean isLegacy = (start & Integer.MIN_VALUE) != 0;
        int startOfParameters = code.indexOf(44, start &= Integer.MAX_VALUE);
        int end = CharSequences.skipTrailingWhitespaces(code, start, code.length());
        if (startOfParameters >= 0) {
            complement = code.substring(startOfParameters + 1);
            end = CharSequences.skipTrailingWhitespaces(code, start, startOfParameters);
        }
        String localCode = code.substring(start, end);
        int codeValue = 0;
        double[] parameters = ArraysExt.EMPTY_DOUBLE;
        try {
            codeValue = Integer.parseInt(localCode);
            if (complement != null) {
                parameters = CharSequences.parseDoubles(complement, ',');
            }
        }
        catch (NumberFormatException exception) {
            throw CommonAuthorityFactory.noSuchAuthorityCode(localCode, code, exception);
        }
        int count = parameters.length;
        if (codeValue >= 42001) {
            short errorKey = 0;
            int expected = 2;
            if (count < 2) {
                errorKey = 127;
            } else {
                expected = 3;
                if (count > 3) {
                    errorKey = 129;
                }
            }
            if (errorKey == 0) {
                return this.createAuto(code, codeValue, isLegacy, count > 2 ? parameters[0] : (isLegacy ? 9001.0 : 1.0), parameters[count - 2], parameters[count - 1]);
            }
            throw new NoSuchAuthorityCodeException(Errors.format(errorKey, expected, count), AUTO2, localCode, code);
        }
        if (count != 0) {
            throw new NoSuchAuthorityCodeException(Errors.format((short)135, localCode, complement), "CRS", localCode, code);
        }
        switch (codeValue) {
            case 1: {
                return this.displayCRS();
            }
            case 84: {
                crs = CommonCRS.WGS84;
                break;
            }
            case 83: {
                crs = CommonCRS.NAD83;
                break;
            }
            case 27: {
                crs = CommonCRS.NAD27;
                break;
            }
            case 88: {
                return CommonCRS.Vertical.NAVD88.crs();
            }
            default: {
                throw CommonAuthorityFactory.noSuchAuthorityCode(localCode, code, null);
            }
        }
        return crs.normalizedGeographic();
    }

    private ProjectedCRS createAuto(String code, int projection, boolean isLegacy, double factor, double longitude, double latitude) throws FactoryException {
        Boolean isUTM = null;
        String method = null;
        String param = null;
        switch (projection) {
            case 42001: {
                isUTM = true;
                break;
            }
            case 42002: {
                isUTM = latitude == 0.0 && TransverseMercator.Zoner.UTM.centralMeridian(TransverseMercator.Zoner.UTM.zone(0.0, longitude)) == longitude;
                break;
            }
            case 42003: {
                method = "Orthographic";
                param = "latitude_of_origin";
                break;
            }
            case 42004: {
                method = "Equirectangular";
                param = "standard_parallel_1";
                break;
            }
            case 42005: {
                method = "Mollweide";
                break;
            }
            default: {
                throw CommonAuthorityFactory.noSuchAuthorityCode(String.valueOf(projection), code, null);
            }
        }
        CommonCRS datum = CommonCRS.WGS84;
        try {
            Unit unit;
            CartesianCS cs;
            GeographicCRS baseCRS;
            ProjectedCRS crs;
            if (isUTM != null && isUTM.booleanValue()) {
                crs = datum.universal(Math.signum(latitude), longitude);
                if (factor == (double)(isLegacy ? 9001 : 1)) {
                    return crs;
                }
                baseCRS = crs.getBaseCRS();
                cs = crs.getCoordinateSystem();
            } else {
                cs = this.projectedCS;
                if (cs == null) {
                    crs = datum.universal(Math.signum(latitude), longitude);
                    this.projectedCS = cs = crs.getCoordinateSystem();
                    baseCRS = crs.getBaseCRS();
                } else {
                    crs = null;
                    baseCRS = datum.geographic();
                }
            }
            if (isLegacy) {
                unit = CommonAuthorityFactory.createUnitFromEPSG(factor).asType(Length.class);
            } else {
                unit = Units.METRE;
                if (factor != 1.0) {
                    unit = unit.multiply(factor);
                }
            }
            if (!Units.METRE.equals((Object)unit)) {
                cs = (CartesianCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cs, (Unit<Length>)unit);
            }
            GeodeticObjectBuilder builder = new GeodeticObjectBuilder();
            if (isUTM != null) {
                if (isUTM.booleanValue() && crs != null) {
                    builder.addName(crs.getName());
                }
                builder.setTransverseMercator(isUTM != false ? TransverseMercator.Zoner.UTM : TransverseMercator.Zoner.ANY, latitude, longitude);
            } else {
                ((GeodeticObjectBuilder)builder.setConversionMethod(method).addName(PROJECTION_NAMES[projection - 42001])).setParameter("central_meridian", longitude, Units.DEGREE);
                if (param != null) {
                    builder.setParameter(param, latitude, Units.DEGREE);
                }
            }
            return builder.createProjectedCRS(baseCRS, cs);
        }
        catch (IllegalArgumentException e) {
            throw CommonAuthorityFactory.noSuchAuthorityCode(String.valueOf(projection), code, e);
        }
    }

    private static Unit<?> createUnitFromEPSG(double code) throws NoSuchAuthorityCodeException {
        String s;
        String message = null;
        int c = (int)code;
        if ((double)c == code) {
            Unit<?> unit = Units.valueOfEPSG(c);
            if (Units.isLinear(unit)) {
                return unit;
            }
            if (unit != null) {
                message = Errors.format((short)103, unit);
            }
            s = String.valueOf(c);
        } else {
            s = String.valueOf(code);
        }
        if (message == null) {
            message = Resources.format((short)49, "EPSG", Unit.class, s);
        }
        throw new NoSuchAuthorityCodeException(message, "EPSG", s);
    }

    private synchronized CoordinateReferenceSystem displayCRS() throws FactoryException {
        if (this.displayCRS == null) {
            CSFactory csFactory = DefaultFactories.forBuildin(CSFactory.class);
            CartesianCS cs = csFactory.createCartesianCS(Collections.singletonMap("name", "Computer display"), csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", "i"), "i", AxisDirection.EAST, Units.PIXEL), csFactory.createCoordinateSystemAxis(Collections.singletonMap("name", "j"), "j", AxisDirection.SOUTH, Units.PIXEL));
            HashMap<String, Object> properties = new HashMap<String, Object>(4);
            properties.put("name", cs.getName());
            properties.put("anchorPoint", "Origin is in upper left.");
            this.displayCRS = DefaultFactories.forBuildin(CRSFactory.class).createEngineeringCRS(properties, DefaultFactories.forBuildin(DatumFactory.class).createEngineeringDatum(properties), (CoordinateSystem)cs);
        }
        return this.displayCRS;
    }

    private static NoSuchAuthorityCodeException noSuchAuthorityCode(String localCode, String code, Exception cause) {
        return (NoSuchAuthorityCodeException)new NoSuchAuthorityCodeException(Resources.format((short)49, "OGC", CoordinateReferenceSystem.class, localCode), "OGC", localCode, code).initCause((Throwable)cause);
    }
}

