/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public abstract class DatumShiftGrid<C extends Quantity<C>, T extends Quantity<T>>
implements Serializable {
    private static final long serialVersionUID = 8405276545243175808L;
    protected static final int INTERPOLATED_DIMENSIONS = 2;
    private final Unit<C> coordinateUnit;
    private final LinearTransform coordinateToGrid;
    private final Unit<T> translationUnit;
    private final boolean isCellValueRatio;
    private final int[] gridSize;

    protected DatumShiftGrid(Unit<C> coordinateUnit, LinearTransform coordinateToGrid, int[] gridSize, boolean isCellValueRatio, Unit<T> translationUnit) {
        ArgumentChecks.ensureNonNull("coordinateUnit", coordinateUnit);
        ArgumentChecks.ensureNonNull("coordinateToGrid", coordinateToGrid);
        ArgumentChecks.ensureNonNull("gridSize", gridSize);
        ArgumentChecks.ensureNonNull("translationUnit", translationUnit);
        int n = coordinateToGrid.getTargetDimensions();
        ArgumentChecks.ensureDimensionMatches("gridSize", n, gridSize);
        this.coordinateUnit = coordinateUnit;
        this.coordinateToGrid = coordinateToGrid;
        this.isCellValueRatio = isCellValueRatio;
        this.translationUnit = translationUnit;
        gridSize = (int[])gridSize.clone();
        this.gridSize = gridSize;
        for (int i = 0; i < gridSize.length; ++i) {
            n = gridSize[i];
            if (n >= 2) continue;
            throw new IllegalArgumentException(Errors.format(n <= 0 ? (short)165 : 45, Strings.toIndexed("gridSize", i), n));
        }
    }

    protected DatumShiftGrid(DatumShiftGrid<C, T> other) {
        ArgumentChecks.ensureNonNull("other", other);
        this.coordinateUnit = other.coordinateUnit;
        this.coordinateToGrid = other.coordinateToGrid;
        this.isCellValueRatio = other.isCellValueRatio;
        this.translationUnit = other.translationUnit;
        this.gridSize = other.gridSize;
    }

    public int[] getGridSize() {
        return (int[])this.gridSize.clone();
    }

    public Envelope getDomainOfValidity() throws TransformException {
        GeneralEnvelope env = new GeneralEnvelope(this.gridSize.length);
        for (int i = 0; i < this.gridSize.length; ++i) {
            env.setRange(i, -0.5, (double)this.gridSize[i] - 0.5);
        }
        return Envelopes.transform(this.getCoordinateToGrid().inverse(), (Envelope)env);
    }

    public Unit<C> getCoordinateUnit() {
        return this.coordinateUnit;
    }

    public LinearTransform getCoordinateToGrid() {
        return this.coordinateToGrid;
    }

    public abstract int getTranslationDimensions();

    public Unit<T> getTranslationUnit() {
        return this.translationUnit;
    }

    public double[] interpolateAt(double ... coordinates) throws TransformException {
        LinearTransform c = this.getCoordinateToGrid();
        ArgumentChecks.ensureDimensionMatches("coordinates", c.getSourceDimensions(), coordinates);
        int dim = this.getTranslationDimensions();
        double[] vector = new double[Math.max(dim, c.getTargetDimensions())];
        c.transform(coordinates, 0, vector, 0, 1);
        this.interpolateInCell(vector[0], vector[1], vector);
        if (this.isCellValueRatio()) {
            c.inverse().deltaTransform(vector, 0, vector, 0, 1);
        }
        if (vector.length != dim) {
            vector = Arrays.copyOf(vector, dim);
        }
        return vector;
    }

    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        boolean skipX = false;
        boolean skipY = false;
        if (gridX < 0.0) {
            gridX = 0.0;
            skipX = true;
        }
        if (gridY < 0.0) {
            gridY = 0.0;
            skipY = true;
        }
        int ix = (int)gridX;
        gridX -= (double)ix;
        int iy = (int)gridY;
        gridY -= (double)iy;
        int n = this.gridSize[0] - 2;
        if (ix > n) {
            skipX |= ix != n + 1 || gridX != 0.0;
            ix = n;
            gridX = 1.0;
        }
        if (iy > (n = this.gridSize[1] - 2)) {
            skipY |= iy != n + 1 || gridY != 0.0;
            iy = n;
            gridY = 1.0;
        }
        boolean derivative = vector.length >= (n = this.getTranslationDimensions()) + 4;
        for (int dim = 0; dim < n; ++dim) {
            double r00 = this.getCellValue(dim, ix, iy);
            double r01 = this.getCellValue(dim, ix + 1, iy);
            double r10 = this.getCellValue(dim, ix, iy + 1);
            double r11 = this.getCellValue(dim, ix + 1, iy + 1);
            double dx = r01 - r00;
            double r0x = r00 + gridX * dx;
            double dy = r11 - r10;
            double r1x = r10 + gridX * dy;
            vector[dim] = gridY * (r1x - r0x) + r0x;
            if (!derivative) continue;
            dx = skipX ? 0.0 : (dx += (dy - dx) * gridX);
            if (skipY) {
                dy = 0.0;
            } else {
                dy = r10 - r00;
                dy += (r11 - r01 - dy) * gridY;
            }
            int i = n;
            if (dim == 0) {
                dx += 1.0;
            } else {
                dy += 1.0;
                i += 2;
                derivative = false;
            }
            vector[i] = dx;
            vector[i + 1] = dy;
        }
    }

    public Matrix derivativeInCell(double gridX, double gridY) {
        int ix = Math.max(0, Math.min(this.gridSize[0] - 2, (int)gridX));
        int iy = Math.max(0, Math.min(this.gridSize[1] - 2, (int)gridY));
        boolean skipX = (gridX -= (double)ix) < 0.0 || gridX > 1.0;
        boolean skipY = (gridY -= (double)iy) < 0.0 || gridY > 1.0;
        MatrixSIS derivative = Matrices.createDiagonal(this.getTranslationDimensions(), this.gridSize.length);
        int j = derivative.getNumRow();
        while (--j >= 0) {
            double r00 = this.getCellValue(j, ix, iy);
            double r01 = this.getCellValue(j, ix + 1, iy);
            double r10 = this.getCellValue(j, ix, iy + 1);
            double r11 = this.getCellValue(j, ix + 1, iy + 1);
            if (!skipX) {
                double dx = r01 - r00;
                dx += (r11 - r10 - dx) * gridX;
                derivative.setElement(j, 0, derivative.getElement(j, 0) + dx);
            }
            if (skipY) continue;
            double dy = r10 - r00;
            dy += (r11 - r01 - dy) * gridY;
            derivative.setElement(j, 1, derivative.getElement(j, 1) + dy);
        }
        return derivative;
    }

    public abstract double getCellValue(int var1, int var2, int var3);

    public double getCellMean(int dim) {
        DoubleDouble sum = new DoubleDouble();
        int nx = this.gridSize[0];
        int ny = this.gridSize[1];
        for (int gridY = 0; gridY < ny; ++gridY) {
            for (int gridX = 0; gridX < nx; ++gridX) {
                sum.addKahan(this.getCellValue(dim, gridX, gridY));
            }
        }
        return sum.doubleValue() / (double)(nx * ny);
    }

    public abstract double getCellPrecision();

    public boolean isCellValueRatio() {
        return this.isCellValueRatio;
    }

    public boolean isCellInGrid(double gridX, double gridY) {
        return gridX >= 0.0 && gridY >= 0.0 && gridX <= (double)(this.gridSize[0] - 1) && gridY <= (double)(this.gridSize[1] - 1);
    }

    public abstract ParameterDescriptorGroup getParameterDescriptors();

    public abstract void getParameterValues(Parameters var1);

    public String toString() {
        ParameterDescriptorGroup d = this.getParameterDescriptors();
        if (d != null) {
            Parameters p = Parameters.castOrWrap(d.createValue());
            this.getParameterValues(p);
            return p.toString();
        }
        return super.toString();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            DatumShiftGrid that = (DatumShiftGrid)other;
            return Arrays.equals(this.gridSize, that.gridSize) && Objects.equals(this.coordinateToGrid, that.coordinateToGrid) && Objects.equals(this.coordinateUnit, that.coordinateUnit) && Objects.equals(this.translationUnit, that.translationUnit) && this.isCellValueRatio == that.isCellValueRatio;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.coordinateToGrid) + 37 * Arrays.hashCode(this.gridSize);
    }
}

