/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;

@XmlType(name="CylindricalCSType")
@XmlRootElement(name="CylindricalCS")
public class DefaultCylindricalCS
extends AbstractCS
implements CylindricalCS {
    private static final long serialVersionUID = -8290402732390917907L;

    private DefaultCylindricalCS(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        super(properties, axes);
    }

    public DefaultCylindricalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    protected DefaultCylindricalCS(CylindricalCS cs) {
        super((CoordinateSystem)cs);
    }

    public static DefaultCylindricalCS castOrCopy(CylindricalCS object) {
        return object == null || object instanceof DefaultCylindricalCS ? (DefaultCylindricalCS)object : new DefaultCylindricalCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(direction, false)) {
            return 1;
        }
        if (!Units.isAngular(unit) && !Units.isLinear(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends CylindricalCS> getInterface() {
        return CylindricalCS.class;
    }

    @Override
    public DefaultCylindricalCS forConvention(AxesConvention convention) {
        return (DefaultCylindricalCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> properties, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 2: {
                return new DefaultPolarCS(properties, axes);
            }
            case 3: {
                return new DefaultCylindricalCS(properties, axes);
            }
        }
        throw DefaultCylindricalCS.unexpectedDimension(properties, axes, 2);
    }

    private DefaultCylindricalCS() {
    }
}

