/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    NORMALIZED{

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis axis, Unit<?> unit) {
            if (Units.isLinear(unit)) {
                unit = Units.METRE;
            } else if (Units.isAngular(unit)) {
                unit = Units.DEGREE;
            } else if (Units.isTemporal(unit)) {
                unit = Units.DAY;
            }
            return unit;
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            if (!AxisDirections.isIntercardinal(direction) && (axis == null || axis.getMinimumValue() < 0.0)) {
                return AxisDirections.absolute(direction);
            }
            return direction;
        }
    }
    ,
    DISPLAY_ORIENTED{

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis axis, AxisDirection direction) {
            return NORMALIZED.getDirectionReplacement(axis, direction);
        }
    }
    ,
    RIGHT_HANDED,
    POSITIVE_RANGE;

    @Deprecated
    public static final AxesConvention CONVENTIONALLY_ORIENTED;

    static {
        CONVENTIONALLY_ORIENTED = DISPLAY_ORIENTED;
    }
}

