/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.VerticalDatum;

@XmlType(name="VerticalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="VerticalCRS")
public class DefaultVerticalCRS
extends AbstractCRS
implements VerticalCRS {
    private static final long serialVersionUID = 3565878468719941800L;
    private VerticalDatum datum;

    public DefaultVerticalCRS(Map<String, ?> properties, VerticalDatum datum, VerticalCS cs) {
        super(properties, (CoordinateSystem)cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
    }

    protected DefaultVerticalCRS(VerticalCRS crs) {
        super((CoordinateReferenceSystem)crs);
        this.datum = crs.getDatum();
    }

    public static DefaultVerticalCRS castOrCopy(VerticalCRS object) {
        return object == null || object instanceof DefaultVerticalCRS ? (DefaultVerticalCRS)object : new DefaultVerticalCRS(object);
    }

    public Class<? extends VerticalCRS> getInterface() {
        return VerticalCRS.class;
    }

    @XmlElement(name="verticalDatum", required=true)
    public VerticalDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="verticalCS", required=true)
    public VerticalCS getCoordinateSystem() {
        return (VerticalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultVerticalCRS forConvention(AxesConvention convention) {
        return (DefaultVerticalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultVerticalCRS(properties, this.datum, (VerticalCS)cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Vert_CS" : (DefaultVerticalCRS.isBaseCRS(formatter) ? "BaseVertCRS" : formatter.shortOrLong("VertCRS", "VerticalCRS"));
    }

    private DefaultVerticalCRS() {
    }

    private void setDatum(VerticalDatum value) {
        if (this.datum == null) {
            this.datum = value;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultVerticalCRS.class, "setDatum", "verticalDatum");
        }
    }

    private void setCoordinateSystem(VerticalCS cs) {
        this.setCoordinateSystem("verticalCS", (CoordinateSystem)cs);
    }
}

