/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.AbstractDerivedCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Projection;

@XmlType(name="ProjectedCRSType", propOrder={"baseCRS", "coordinateSystem"})
@XmlRootElement(name="ProjectedCRS")
public class DefaultProjectedCRS
extends AbstractDerivedCRS<Projection>
implements ProjectedCRS {
    private static final long serialVersionUID = -4502680112031773028L;

    public DefaultProjectedCRS(Map<String, ?> properties, GeographicCRS baseCRS, Conversion conversion, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, (SingleCRS)baseCRS, conversion, (CoordinateSystem)derivedCS);
    }

    protected DefaultProjectedCRS(ProjectedCRS crs) {
        super((GeneralDerivedCRS)crs);
    }

    public static DefaultProjectedCRS castOrCopy(ProjectedCRS object) {
        return object == null || object instanceof DefaultProjectedCRS ? (DefaultProjectedCRS)object : new DefaultProjectedCRS(object);
    }

    @Override
    final Class<Projection> getConversionType() {
        return Projection.class;
    }

    @Override
    public Class<? extends ProjectedCRS> getInterface() {
        return ProjectedCRS.class;
    }

    public GeodeticDatum getDatum() {
        return this.getBaseCRS().getDatum();
    }

    @XmlElement(name="baseGeodeticCRS", required=true)
    public GeographicCRS getBaseCRS() {
        Projection projection = (Projection)super.getConversionFromBase();
        return projection != null ? (GeographicCRS)projection.getSourceCRS() : null;
    }

    @Override
    public Projection getConversionFromBase() {
        return (Projection)super.getConversionFromBase();
    }

    @XmlElement(name="cartesianCS", required=true)
    public final CartesianCS getCoordinateSystem() {
        return (CartesianCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultProjectedCRS forConvention(AxesConvention convention) {
        return (DefaultProjectedCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        Projection conversion = (Projection)super.getConversionFromBase();
        return new DefaultProjectedCRS(properties, (GeographicCRS)conversion.getSourceCRS(), (Conversion)conversion, (CartesianCS)cs);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        return super.equals(object, mode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean isBaseCRS;
        if (super.getConversionFromBase() == null) {
            return super.formatTo(formatter);
        }
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        CartesianCS cs = this.getCoordinateSystem();
        GeographicCRS baseCRS = this.getBaseCRS();
        Unit<?> lengthUnit = ReferencingUtilities.getUnit((CoordinateSystem)cs);
        Unit<Angle> angularUnit = AxisDirections.getAngularUnit((CoordinateSystem)baseCRS.getCoordinateSystem(), null);
        Unit<Angle> oldAngle = formatter.addContextualUnit(angularUnit);
        Unit<?> oldLength = formatter.addContextualUnit(lengthUnit);
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)baseCRS));
        formatter.newLine();
        Parameters p = new Parameters(this);
        if (isWKT1) {
            p.append(formatter);
            isBaseCRS = false;
        } else {
            formatter.append(p);
            isBaseCRS = DefaultProjectedCRS.isBaseCRS(formatter);
        }
        if (!isBaseCRS || convention == Convention.INTERNAL) {
            this.formatCS(formatter, (CoordinateSystem)cs, lengthUnit, isWKT1);
        }
        formatter.restoreContextualUnit(lengthUnit, oldLength);
        formatter.restoreContextualUnit(angularUnit, oldAngle);
        return isWKT1 ? "ProjCS" : (isBaseCRS ? "BaseProjCRS" : formatter.shortOrLong("ProjCRS", "ProjectedCRS"));
    }

    private DefaultProjectedCRS() {
    }

    private void setBaseCRS(GeographicCRS crs) {
        this.setBaseCRS("baseGeodeticCRS", (SingleCRS)crs);
    }

    private void setCoordinateSystem(CartesianCS cs) {
        this.setCoordinateSystem("cartesianCS", (CoordinateSystem)cs);
    }

    private static final class Parameters
    extends FormattableObject {
        private final Conversion conversion;
        private final Ellipsoid ellipsoid;

        Parameters(DefaultProjectedCRS crs) {
            this.conversion = crs.getConversionFromBase();
            this.ellipsoid = crs.getDatum().getEllipsoid();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            WKTUtilities.appendName((IdentifiedObject)this.conversion, formatter, null);
            formatter.newLine();
            this.append(formatter);
            return "Conversion";
        }

        void append(Formatter formatter) {
            Unit axisUnit = this.ellipsoid.getAxisUnit();
            formatter.append(DefaultOperationMethod.castOrCopy(this.conversion.getMethod()));
            formatter.newLine();
            for (GeneralParameterValue param : this.conversion.getParameterValues().values()) {
                block7: {
                    String name;
                    block6: {
                        GeneralParameterDescriptor desc = param.getDescriptor();
                        name = "semi_major";
                        if (IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)desc, "semi_major")) break block6;
                        name = "semi_minor";
                        if (!IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)desc, "semi_minor")) break block7;
                    }
                    if (param instanceof ParameterValue) {
                        double expected;
                        double value;
                        try {
                            value = ((ParameterValue)param).doubleValue(axisUnit);
                        }
                        catch (IllegalStateException e) {
                            Logging.recoverableException(Logging.getLogger("org.apache.sis.io.wkt"), DefaultProjectedCRS.class, "formatTo", e);
                            continue;
                        }
                        if (Double.isNaN(value)) continue;
                        double d = expected = name == "semi_minor" ? this.ellipsoid.getSemiMinorAxis() : this.ellipsoid.getSemiMajorAxis();
                        if (value == expected) continue;
                    }
                }
                WKTUtilities.append(param, formatter);
            }
        }
    }
}

