/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.Properties;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

public final class IdentifiedObjects
extends Static {
    private IdentifiedObjects() {
    }

    public static Map<String, ?> getProperties(IdentifiedObject object, String ... excludes) {
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("excludes", excludes);
        return new Properties(object, excludes);
    }

    public static Set<String> getNames(IdentifiedObject object, Citation authority) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(8);
        IdentifiedObjects.getName(object, authority, names);
        return names;
    }

    public static String getName(IdentifiedObject object, Citation authority) {
        return IdentifiedObjects.getName(object, authority, null);
    }

    private static String getName(IdentifiedObject object, Citation authority, Collection<String> addTo) {
        block12: {
            if (object == null) break block12;
            ReferenceIdentifier identifier = object.getName();
            if (authority == null) {
                String name;
                if (identifier != null && (name = identifier.getCode()) != null) {
                    if (addTo == null) {
                        return name;
                    }
                    addTo.add(name);
                }
                Iterator it = CollectionsExt.iterator(object.getAlias());
                while (it.hasNext()) {
                    String name2;
                    GenericName alias = (GenericName)it.next();
                    if (alias == null || (name2 = alias instanceof Identifier ? ((Identifier)alias).getCode() : alias.toString()) == null) continue;
                    if (addTo == null) {
                        return name2;
                    }
                    addTo.add(name2);
                }
            } else {
                String name;
                if (identifier != null && Citations.identifierMatches(authority, identifier.getAuthority()) && (name = identifier.getCode()) != null) {
                    if (addTo == null) {
                        return name;
                    }
                    addTo.add(name);
                }
                Iterator it = CollectionsExt.iterator(object.getAlias());
                while (it.hasNext()) {
                    String name3;
                    GenericName scope;
                    GenericName alias = (GenericName)it.next();
                    if (alias == null) continue;
                    if (alias instanceof Identifier) {
                        String name4;
                        identifier = (Identifier)alias;
                        if (!Citations.identifierMatches(authority, identifier.getAuthority()) || (name4 = identifier.getCode()) == null) continue;
                        if (addTo == null) {
                            return name4;
                        }
                        addTo.add(name4);
                        continue;
                    }
                    NameSpace ns = alias.scope();
                    if (ns == null || (scope = ns.name()) == null || !Citations.identifierMatches(authority, scope.toString()) || (name3 = alias.toString()) == null) continue;
                    if (addTo == null) {
                        return name3;
                    }
                    addTo.add(name3);
                }
            }
        }
        return null;
    }

    public static Identifier getIdentifier(IdentifiedObject object, Citation authority) {
        if (object != null) {
            Iterator it = CollectionsExt.iterator(object.getIdentifiers());
            while (it.hasNext()) {
                Identifier identifier = (Identifier)it.next();
                if (identifier == null || authority != null && !Citations.identifierMatches(authority, identifier.getAuthority())) continue;
                return identifier;
            }
        }
        return null;
    }

    public static String getIdentifierOrName(IdentifiedObject object) {
        if (object != null) {
            Iterator it = CollectionsExt.iterator(object.getIdentifiers());
            while (it.hasNext()) {
                String code = IdentifiedObjects.toString((Identifier)it.next());
                if (code == null) continue;
                return code;
            }
            String name = IdentifiedObjects.toString((Identifier)object.getName());
            if (name != null) {
                return name;
            }
        }
        return null;
    }

    public static String getSimpleNameOrIdentifier(IdentifiedObject object) {
        if (object != null) {
            String code;
            String code2;
            ReferenceIdentifier identifier = object.getName();
            if (identifier != null && CharSequences.isUnicodeIdentifier(code2 = identifier.getCode())) {
                return code2;
            }
            Iterator it = CollectionsExt.iterator(object.getAlias());
            while (it.hasNext()) {
                GenericName alias = (GenericName)it.next();
                if (alias == null || (alias = alias.tip()) == null || !CharSequences.isUnicodeIdentifier(code = alias.toString())) continue;
                return code;
            }
            Iterator id = CollectionsExt.iterator(object.getIdentifiers());
            while (id.hasNext()) {
                identifier = (Identifier)id.next();
                if (identifier == null || !CharSequences.isUnicodeIdentifier(code = identifier.getCode())) continue;
                return code;
            }
        }
        return null;
    }

    @Deprecated
    public static String getUnicodeIdentifier(IdentifiedObject object) {
        return IdentifiedObjects.getSimpleNameOrIdentifier(object);
    }

    public static String lookupURN(IdentifiedObject object, Citation authority) throws FactoryException {
        List components;
        IdentifiedObjectFinder finder;
        if (object == null) {
            return null;
        }
        try {
            finder = IdentifiedObjects.newFinder(Citations.toCodeSpace(authority));
        }
        catch (NoSuchAuthorityFactoryException e) {
            IdentifiedObjects.warning("lookupURN", (Exception)((Object)e));
            finder = IdentifiedObjects.newFinder(null);
        }
        String urn = IdentifiedObjects.lookupURN(object, authority, finder);
        if (urn != null) {
            return urn;
        }
        if (object instanceof CompoundCRS) {
            components = CRS.getSingleComponents((CoordinateReferenceSystem)((CompoundCRS)object));
        } else if (object instanceof ConcatenatedOperation) {
            components = ((ConcatenatedOperation)object).getOperations();
        } else {
            return null;
        }
        StringBuilder buffer = null;
        for (IdentifiedObject component : components) {
            urn = IdentifiedObjects.lookupURN(component, authority, finder);
            if (urn == null) {
                return null;
            }
            assert (urn.startsWith("urn:ogc:def")) : urn;
            if (buffer == null) {
                buffer = new StringBuilder(40).append("urn:ogc:def").append(':').append(NameMeaning.toObjectType(object.getClass()));
            }
            buffer.append(',').append(urn, "urn:ogc:def".length() + 1, urn.length());
        }
        return buffer != null ? buffer.toString() : null;
    }

    private static String lookupURN(IdentifiedObject object, Citation authority, IdentifiedObjectFinder finder) throws FactoryException {
        String urn = null;
        if (object != null) {
            for (IdentifiedObject candidate : finder.find(object)) {
                String c = IdentifiedObjects.toURN(candidate.getClass(), IdentifiedObjects.getIdentifier(candidate, authority));
                if (c == null && authority == null) {
                    for (Identifier id : candidate.getIdentifiers()) {
                        c = IdentifiedObjects.toURN(candidate.getClass(), id);
                        if (c == null) continue;
                        break;
                    }
                }
                if (c == null) continue;
                if (urn != null && !urn.equals(c)) {
                    return null;
                }
                urn = c;
            }
        }
        return urn;
    }

    public static Integer lookupEPSG(IdentifiedObject object) throws FactoryException {
        Integer code = null;
        if (object != null) {
            for (IdentifiedObject candidate : IdentifiedObjects.newFinder("EPSG").find(object)) {
                Identifier id = IdentifiedObjects.getIdentifier(candidate, Citations.EPSG);
                if (id == null) continue;
                try {
                    Integer previous = code;
                    code = Integer.valueOf(id.getCode());
                    if (previous == null || previous.equals(code)) continue;
                    return null;
                }
                catch (NumberFormatException e) {
                    IdentifiedObjects.warning("lookupEPSG", e);
                }
            }
        }
        return code;
    }

    private static void warning(String method, Exception e) {
        Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing"), IdentifiedObjects.class, method, e);
    }

    public static IdentifiedObjectFinder newFinder(String authority) throws NoSuchAuthorityFactoryException, FactoryException {
        GeodeticAuthorityFactory factory = authority == null ? AuthorityFactories.ALL : AuthorityFactories.ALL.getAuthorityFactory(GeodeticAuthorityFactory.class, authority, null);
        return ((GeodeticAuthorityFactory)factory).newIdentifiedObjectFinder();
    }

    public static boolean isHeuristicMatchForName(IdentifiedObject object, String name) {
        ArgumentChecks.ensureNonNull("name", name);
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).isHeuristicMatchForName(name);
        }
        return NameToIdentifier.isHeuristicMatchForName((Identifier)object.getName(), object.getAlias(), name, NameToIdentifier.Simplifier.DEFAULT);
    }

    public static String toURN(Class<?> type, Identifier identifier) {
        ArgumentChecks.ensureNonNull("type", type);
        if (identifier == null) {
            return null;
        }
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (cs == null || cs.isEmpty()) {
            cs = Identifiers.getIdentifier(identifier.getAuthority(), true);
        }
        return NameMeaning.toURN(type, cs, identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getVersion() : null, identifier.getCode());
    }

    public static String toString(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof GenericName) {
            return identifier.toString();
        }
        String code = identifier.getCode();
        String cs = null;
        if (identifier instanceof ReferenceIdentifier) {
            cs = ((ReferenceIdentifier)identifier).getCodeSpace();
        }
        if (cs == null || cs.isEmpty()) {
            cs = Citations.toCodeSpace(identifier.getAuthority());
        }
        if (cs != null) {
            return cs + ':' + code;
        }
        return code;
    }
}

