/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.StandardDefinitions;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public enum CommonCRS {
    WGS84(4326, 4979, 4978, 6326, 7030, 5041, 5042, 32600, 32700, 1, 60),
    WGS72(4322, 4985, 4984, 6322, 7043, 0, 0, 32200, 32300, 1, 60),
    NAD83(4269, 0, 0, 6269, 7019, 0, 0, 26900, 0, 1, 23),
    NAD27(4267, 0, 0, 6267, 7008, 0, 0, 26700, 0, 1, 22),
    ETRS89(4258, 4937, 4936, 6258, 7019, 0, 0, 25800, 0, 28, 37),
    ED50(4230, 0, 0, 6230, 7022, 0, 0, 23000, 0, 28, 38),
    GRS1980(4019, 0, 0, 6019, 7019, 0, 0, 0, 0, 0, 0),
    SPHERE(4047, 0, 0, 6047, 7048, 0, 0, 0, 0, 0, 0);

    static final CommonCRS DEFAULT;
    final short geographic;
    final short geo3D;
    final short geocentric;
    final short datum;
    final short ellipsoid;
    final short northUPS;
    final short southUPS;
    final short northUTM;
    final short southUTM;
    final byte firstZone;
    final byte lastZone;
    private volatile transient IdentifiedObject cached;
    private volatile transient GeographicCRS cachedNormalized;
    private volatile transient GeographicCRS cachedGeo3D;
    private volatile transient GeocentricCRS cachedGeocentric;
    private volatile transient GeocentricCRS cachedSpherical;
    private final Map<Integer, ProjectedCRS> cachedProjections;
    private static final int POLAR = 90;

    private CommonCRS(short geographic, short geo3D, short geocentric, short datum, short ellipsoid, short northUPS, short southUPS, short northUTM, short southUTM, byte firstZone, byte lastZone) {
        this.geographic = geographic;
        this.geocentric = geocentric;
        this.geo3D = geo3D;
        this.datum = datum;
        this.ellipsoid = ellipsoid;
        this.northUPS = northUPS;
        this.southUPS = southUPS;
        this.northUTM = northUTM;
        this.southUTM = southUTM;
        this.firstZone = firstZone;
        this.lastZone = lastZone;
        this.cachedProjections = new HashMap<Integer, ProjectedCRS>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void clear() {
        this.cached = null;
        this.cachedGeo3D = null;
        this.cachedNormalized = null;
        this.cachedGeocentric = null;
        Map<Integer, ProjectedCRS> map = this.cachedProjections;
        synchronized (map) {
            this.cachedProjections.clear();
        }
    }

    public static CommonCRS forDatum(CoordinateReferenceSystem crs) {
        CommonCRS c;
        SingleCRS single;
        if (crs instanceof SingleCRS) {
            single = (SingleCRS)crs;
        } else {
            single = CRS.getHorizontalComponent(crs);
            if (single == null) {
                throw new IllegalArgumentException(Resources.format((short)71, IdentifiedObjects.getName((IdentifiedObject)crs, null)));
            }
        }
        Datum datum = single.getDatum();
        if (datum instanceof GeodeticDatum && (c = CommonCRS.forDatum((GeodeticDatum)datum)) != null) {
            return c;
        }
        throw new IllegalArgumentException(Errors.format((short)168, IdentifiedObjects.getName((IdentifiedObject)datum, null)));
    }

    static CommonCRS forDatum(GeodeticDatum datum) {
        String code;
        int epsg = 0;
        Identifier identifier = IdentifiedObjects.getIdentifier((IdentifiedObject)datum, Citations.EPSG);
        if (identifier != null && (code = identifier.getCode()) != null) {
            try {
                epsg = Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing"), CommonCRS.class, "forDatum", e);
            }
        }
        for (CommonCRS c : CommonCRS.values()) {
            if (!(epsg != 0 ? c.datum == epsg : Utilities.equalsIgnoreMetadata(c.datum(), datum))) continue;
            return c;
        }
        return null;
    }

    public static GeographicCRS defaultGeographic() {
        return DEFAULT.normalizedGeographic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS normalizedGeographic() {
        GeographicCRS object = this.cachedNormalized;
        if (object == null) {
            DefaultGeographicCRS crs = DefaultGeographicCRS.castOrCopy(this.geographic());
            crs = crs.forConvention(AxesConvention.RIGHT_HANDED);
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = this.cachedNormalized;
                if (object == null) {
                    this.cachedNormalized = object = crs;
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS geographic() {
        GeographicCRS object = CommonCRS.geographic(this.cached);
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = CommonCRS.geographic(this.cached);
                if (object == null) {
                    GeodeticAuthorityFactory factory = CommonCRS.factory();
                    if (factory != null) {
                        try {
                            object = factory.createGeographicCRS(String.valueOf(this.geographic));
                            this.cached = object;
                            return object;
                        }
                        catch (FactoryException e) {
                            CommonCRS.failure((Object)this, "geographic", e, this.geographic);
                        }
                    }
                    EllipsoidalCS cs = this == DEFAULT ? (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6422, true) : DEFAULT.geographic().getCoordinateSystem();
                    object = StandardDefinitions.createGeographicCRS(this.geographic, this.datum(), cs);
                    this.cached = object;
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS geographic3D() {
        GeographicCRS object = this.cachedGeo3D;
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = this.cachedGeo3D;
                if (object == null) {
                    GeodeticAuthorityFactory factory;
                    if (this.geo3D != 0 && (factory = CommonCRS.factory()) != null) {
                        try {
                            this.cachedGeo3D = object = factory.createGeographicCRS(String.valueOf(this.geo3D));
                            return object;
                        }
                        catch (FactoryException e) {
                            CommonCRS.failure((Object)this, "geographic3D", e, this.geo3D);
                        }
                    }
                    EllipsoidalCS cs = this == DEFAULT ? (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6423, true) : DEFAULT.geographic3D().getCoordinateSystem();
                    GeographicCRS base = this.geographic();
                    this.cachedGeo3D = object = new DefaultGeographicCRS(CommonCRS.properties((IdentifiedObject)base, this.geo3D), base.getDatum(), cs);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocentricCRS geocentric() {
        GeocentricCRS object = this.cachedGeocentric;
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = this.cachedGeocentric;
                if (object == null) {
                    GeodeticAuthorityFactory factory;
                    if (this.geocentric != 0 && (factory = CommonCRS.factory()) != null) {
                        try {
                            this.cachedGeocentric = object = factory.createGeocentricCRS(String.valueOf(this.geocentric));
                            return object;
                        }
                        catch (FactoryException e) {
                            CommonCRS.failure((Object)this, "geocentric", e, this.geocentric);
                        }
                    }
                    CartesianCS cs = this == DEFAULT ? (CartesianCS)StandardDefinitions.createCoordinateSystem((short)6500, true) : (CartesianCS)DEFAULT.geocentric().getCoordinateSystem();
                    GeographicCRS base = this.geographic();
                    this.cachedGeocentric = object = new DefaultGeocentricCRS(CommonCRS.properties((IdentifiedObject)base, this.geocentric), base.getDatum(), cs);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocentricCRS spherical() {
        GeocentricCRS object = this.cachedSpherical;
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = this.cachedSpherical;
                if (object == null) {
                    SphericalCS cs = null;
                    if (this == DEFAULT) {
                        GeodeticAuthorityFactory factory = CommonCRS.factory();
                        if (factory != null) {
                            try {
                                cs = factory.createSphericalCS(Short.toString((short)6404));
                            }
                            catch (FactoryException e) {
                                CommonCRS.failure((Object)this, "spherical", e, 6404);
                            }
                        }
                        if (cs == null) {
                            cs = (SphericalCS)StandardDefinitions.createCoordinateSystem((short)6404, true);
                        }
                    } else {
                        cs = (SphericalCS)DEFAULT.spherical().getCoordinateSystem();
                    }
                    GeographicCRS base = this.geographic();
                    this.cachedSpherical = object = new DefaultGeocentricCRS(IdentifiedObjects.getProperties((IdentifiedObject)base, CommonCRS.exclude()), base.getDatum(), cs);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeodeticDatum datum() {
        GeodeticDatum object = CommonCRS.datum(this.cached);
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = CommonCRS.datum(this.cached);
                if (object == null) {
                    GeodeticAuthorityFactory factory = CommonCRS.factory();
                    if (factory != null) {
                        try {
                            object = factory.createGeodeticDatum(String.valueOf(this.datum));
                            this.cached = object;
                            return object;
                        }
                        catch (FactoryException e) {
                            CommonCRS.failure((Object)this, "datum", e, this.datum);
                        }
                    }
                    object = StandardDefinitions.createGeodeticDatum(this.datum, this.ellipsoid(), this.primeMeridian());
                    this.cached = object;
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ellipsoid ellipsoid() {
        Ellipsoid object = CommonCRS.ellipsoid(this.cached);
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = CommonCRS.ellipsoid(this.cached);
                if (object == null) {
                    if (this == NAD83) {
                        object = ETRS89.ellipsoid();
                    } else {
                        GeodeticAuthorityFactory factory = CommonCRS.factory();
                        if (factory != null) {
                            try {
                                object = factory.createEllipsoid(String.valueOf(this.ellipsoid));
                                this.cached = object;
                                return object;
                            }
                            catch (FactoryException e) {
                                CommonCRS.failure((Object)this, "ellipsoid", e, this.ellipsoid);
                            }
                        }
                        object = StandardDefinitions.createEllipsoid(this.ellipsoid);
                    }
                    this.cached = object;
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimeMeridian primeMeridian() {
        PrimeMeridian object = CommonCRS.primeMeridian(this.cached);
        if (object == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                object = CommonCRS.primeMeridian(this.cached);
                if (object == null) {
                    if (this != DEFAULT) {
                        object = DEFAULT.primeMeridian();
                    } else {
                        GeodeticAuthorityFactory factory = CommonCRS.factory();
                        if (factory != null) {
                            try {
                                object = factory.createPrimeMeridian("8901");
                                this.cached = object;
                                return object;
                            }
                            catch (FactoryException e) {
                                CommonCRS.failure((Object)this, "primeMeridian", e, 8901);
                            }
                        }
                        object = StandardDefinitions.primeMeridian();
                    }
                    this.cached = object;
                }
            }
        }
        return object;
    }

    private static GeographicCRS geographic(IdentifiedObject object) {
        return object instanceof GeographicCRS ? (GeographicCRS)object : null;
    }

    private static GeodeticDatum datum(IdentifiedObject object) {
        if (object instanceof GeodeticDatum) {
            return (GeodeticDatum)object;
        }
        if (object instanceof GeodeticCRS) {
            return ((GeodeticCRS)object).getDatum();
        }
        return null;
    }

    private static Ellipsoid ellipsoid(IdentifiedObject object) {
        if (object instanceof Ellipsoid) {
            return (Ellipsoid)object;
        }
        GeodeticDatum datum = CommonCRS.datum(object);
        return datum != null ? datum.getEllipsoid() : null;
    }

    private static PrimeMeridian primeMeridian(IdentifiedObject object) {
        if (object instanceof PrimeMeridian) {
            return (PrimeMeridian)object;
        }
        GeodeticDatum datum = CommonCRS.datum(object);
        return datum != null ? datum.getPrimeMeridian() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS universal(double latitude, double longitude) {
        ProjectedCRS crs;
        ArgumentChecks.ensureBetween("latitude", -90.0, 90.0, latitude);
        ArgumentChecks.ensureBetween("longitude", -4.052915431398935E8, 4.052915431398935E8, longitude);
        boolean isSouth = MathFunctions.isNegative(latitude);
        boolean isUTM = latitude >= -80.0 && latitude < 84.0;
        int zone = isUTM ? TransverseMercator.Zoner.UTM.zone(latitude, longitude) : 90;
        Integer key = isSouth ? -zone : zone;
        Map<Integer, ProjectedCRS> map = this.cachedProjections;
        synchronized (map) {
            crs = this.cachedProjections.get(key);
        }
        if (crs == null) {
            ProjectedCRS other;
            int code = 0;
            if (!isUTM) {
                code = Short.toUnsignedInt(isSouth ? this.southUPS : this.northUPS);
            } else if (zone >= this.firstZone && zone <= this.lastZone) {
                code = Short.toUnsignedInt(isSouth ? this.southUTM : this.northUTM);
            }
            if (code != 0) {
                GeodeticAuthorityFactory factory;
                if (isUTM) {
                    code += zone;
                }
                if ((factory = CommonCRS.factory()) != null) {
                    try {
                        return factory.createProjectedCRS(String.valueOf(code));
                    }
                    catch (FactoryException e) {
                        CommonCRS.failure((Object)this, "universal", e, code);
                    }
                }
            }
            CartesianCS cs = null;
            if (isUTM) {
                Map<Integer, ProjectedCRS> e = CommonCRS.DEFAULT.cachedProjections;
                synchronized (e) {
                    for (Map.Entry<Integer, ProjectedCRS> entry : CommonCRS.DEFAULT.cachedProjections.entrySet()) {
                        if (Math.abs(entry.getKey()) == 90) continue;
                        cs = entry.getValue().getCoordinateSystem();
                        break;
                    }
                }
            }
            if (cs == null) {
                cs = this != DEFAULT ? DEFAULT.universal(latitude, longitude).getCoordinateSystem() : (CartesianCS)StandardDefinitions.createCoordinateSystem(isUTM ? (short)4400 : (isSouth ? (short)1027 : 1026), true);
            }
            crs = StandardDefinitions.createUniversal(code, this.geographic(), isUTM, latitude, longitude, cs);
            Map<Integer, ProjectedCRS> map2 = this.cachedProjections;
            synchronized (map2) {
                other = this.cachedProjections.putIfAbsent(key, crs);
            }
            if (other != null) {
                return other;
            }
        }
        return crs;
    }

    static Map<String, ?> properties(short key) {
        return CommonCRS.properties(Vocabulary.formatInternational(key));
    }

    static Map<String, ?> properties(InternationalString name) {
        return Collections.singletonMap("name", new NamedIdentifier(null, (CharSequence)name));
    }

    private static Map<String, ?> properties(IdentifiedObject template, short code) {
        HashMap properties = new HashMap(IdentifiedObjects.getProperties(template, CommonCRS.exclude()));
        properties.put("identifiers", new NamedIdentifier(Citations.EPSG, String.valueOf(code)));
        return properties;
    }

    private static String[] exclude() {
        return new String[]{"identifiers"};
    }

    static GeodeticAuthorityFactory factory() {
        GeodeticAuthorityFactory factory = AuthorityFactories.EPSG();
        if (!(factory instanceof EPSGFactoryFallback)) {
            return factory;
        }
        return null;
    }

    static void failure(Object caller, String method, FactoryException e, int code) {
        String message = Resources.format((short)5, "EPSG:" + code);
        message = Exceptions.formatChainedMessages(null, message, e);
        LogRecord record = new LogRecord(Level.WARNING, message);
        if (!(e instanceof UnavailableFactoryException) || AuthorityFactories.failure((UnavailableFactoryException)e)) {
            record.setThrown(e);
        }
        record.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(caller.getClass(), method, record);
    }

    static {
        DEFAULT = WGS84;
        SystemListener.add(new SystemListener("org.apache.sis.referencing"){

            @Override
            protected void classpathChanged() {
                for (CommonCRS e : CommonCRS.values()) {
                    e.clear();
                }
            }
        });
    }

    public static enum Temporal {
        JULIAN(56, -210866760000000L),
        MODIFIED_JULIAN(71, -3506716800000L),
        TRUNCATED_JULIAN(104, -50716800000L),
        DUBLIN_JULIAN(38, -2209032000000L),
        UNIX(100, 0L),
        JAVA(100, 0L);

        private final short key;
        private final long epoch;
        private volatile transient IdentifiedObject cached;

        private Temporal(short name, long epoch) {
            this.key = name;
            this.epoch = epoch;
        }

        synchronized void clear() {
            this.cached = null;
        }

        public static Temporal forEpoch(Instant epoch) {
            if (epoch != null) {
                long e = epoch.toEpochMilli();
                for (Temporal candidate : Temporal.values()) {
                    if (candidate.epoch != e) continue;
                    return candidate;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemporalCRS crs() {
            TemporalCRS object = Temporal.crs(this.cached);
            if (object == null) {
                Temporal temporal = this;
                synchronized (temporal) {
                    object = Temporal.crs(this.cached);
                    if (object == null) {
                        TemporalDatum datum = this.datum();
                        object = new DefaultTemporalCRS(IdentifiedObjects.getProperties((IdentifiedObject)datum, CommonCRS.exclude()), datum, this.cs());
                        this.cached = object;
                    }
                }
            }
            return object;
        }

        private TimeCS cs() {
            Map<String, ?> axis;
            Map<String, ?> cs;
            Unit<Time> unit = Units.SECOND;
            switch (this) {
                default: {
                    return TRUNCATED_JULIAN.crs().getCoordinateSystem();
                }
                case TRUNCATED_JULIAN: {
                    unit = Units.DAY;
                }
                case UNIX: {
                    TimeCS share = JAVA.crs().getCoordinateSystem();
                    cs = IdentifiedObjects.getProperties((IdentifiedObject)share, CommonCRS.exclude());
                    axis = IdentifiedObjects.getProperties((IdentifiedObject)share.getAxis(0), CommonCRS.exclude());
                    break;
                }
                case JAVA: {
                    cs = CommonCRS.properties((short)97);
                    axis = CommonCRS.properties((short)99);
                    unit = Units.MILLISECOND;
                }
            }
            return new DefaultTimeCS(cs, new DefaultCoordinateSystemAxis(axis, "t", AxisDirection.FUTURE, unit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemporalDatum datum() {
            TemporalDatum object = Temporal.datum(this.cached);
            if (object == null) {
                Temporal temporal = this;
                synchronized (temporal) {
                    object = Temporal.datum(this.cached);
                    if (object == null) {
                        if (this == UNIX) {
                            object = JAVA.datum();
                        } else {
                            Map<String, ?> properties = this.key == 100 ? CommonCRS.properties(Vocabulary.formatInternational(this.key, (Object)(this == JAVA ? "Java" : "Unix/POSIX"))) : CommonCRS.properties(this.key);
                            object = new DefaultTemporalDatum(properties, new Date(this.epoch));
                        }
                        this.cached = object;
                    }
                }
            }
            return object;
        }

        private static TemporalCRS crs(IdentifiedObject object) {
            return object instanceof TemporalCRS ? (TemporalCRS)object : null;
        }

        private static TemporalDatum datum(IdentifiedObject object) {
            if (object instanceof TemporalDatum) {
                return (TemporalDatum)object;
            }
            if (object instanceof TemporalCRS) {
                return ((TemporalCRS)object).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add(new SystemListener("org.apache.sis.referencing"){

                @Override
                protected void classpathChanged() {
                    for (Temporal e : Temporal.values()) {
                        e.clear();
                    }
                }
            });
        }
    }

    public static enum Vertical {
        BAROMETRIC(false, 9, 17),
        MEAN_SEA_LEVEL(true, 5714, 5100),
        DEPTH(true, 5715, 5100),
        NAVD88(true, 5703, 5103),
        ELLIPSOIDAL(false, 41, 39),
        OTHER_SURFACE(false, 46, 84);

        final boolean isEPSG;
        final short crs;
        final short datum;
        private volatile transient IdentifiedObject cached;

        private Vertical(boolean isEPSG, short crs, short datum) {
            this.isEPSG = isEPSG;
            this.crs = crs;
            this.datum = datum;
        }

        synchronized void clear() {
            this.cached = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerticalCRS crs() {
            VerticalCRS object = Vertical.crs(this.cached);
            if (object == null) {
                Vertical vertical = this;
                synchronized (vertical) {
                    object = Vertical.crs(this.cached);
                    if (object == null) {
                        if (this.isEPSG) {
                            GeodeticAuthorityFactory factory = CommonCRS.factory();
                            if (factory != null) {
                                try {
                                    object = factory.createVerticalCRS(String.valueOf(this.crs));
                                    this.cached = object;
                                    return object;
                                }
                                catch (FactoryException e) {
                                    CommonCRS.failure((Object)this, "crs", e, this.crs);
                                }
                            }
                            object = StandardDefinitions.createVerticalCRS(this.crs, this.datum());
                        } else {
                            VerticalCS cs = this.cs();
                            object = new DefaultVerticalCRS(IdentifiedObjects.getProperties((IdentifiedObject)cs, CommonCRS.exclude()), this.datum(), cs);
                        }
                        this.cached = object;
                    }
                }
            }
            return object;
        }

        private VerticalCS cs() {
            Unit<Length> unit;
            Map<String, ?> properties = CommonCRS.properties(this.crs);
            switch (this) {
                default: {
                    unit = Units.METRE;
                    break;
                }
                case BAROMETRIC: {
                    unit = Units.HECTOPASCAL;
                }
            }
            return new DefaultVerticalCS(properties, new DefaultCoordinateSystemAxis(properties, "h", AxisDirection.UP, unit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerticalDatum datum() {
            VerticalDatum object = Vertical.datum(this.cached);
            if (object == null) {
                Vertical vertical = this;
                synchronized (vertical) {
                    object = Vertical.datum(this.cached);
                    if (object == null) {
                        if (this.isEPSG) {
                            GeodeticAuthorityFactory factory = CommonCRS.factory();
                            if (factory != null) {
                                try {
                                    object = factory.createVerticalDatum(String.valueOf(this.datum));
                                    this.cached = object;
                                    return object;
                                }
                                catch (FactoryException e) {
                                    CommonCRS.failure((Object)this, "datum", e, this.datum);
                                }
                            }
                            object = StandardDefinitions.createVerticalDatum(this.datum);
                        } else {
                            object = new DefaultVerticalDatum(CommonCRS.properties(this.datum), VerticalDatumType.valueOf((String)this.name()));
                        }
                        this.cached = object;
                    }
                }
            }
            return object;
        }

        private static VerticalCRS crs(IdentifiedObject object) {
            return object instanceof VerticalCRS ? (VerticalCRS)object : null;
        }

        private static VerticalDatum datum(IdentifiedObject object) {
            if (object instanceof VerticalDatum) {
                return (VerticalDatum)object;
            }
            if (object instanceof VerticalCRS) {
                return ((VerticalCRS)object).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add(new SystemListener("org.apache.sis.referencing"){

                @Override
                protected void classpathChanged() {
                    for (Vertical e : Vertical.values()) {
                        e.clear();
                    }
                }
            });
        }
    }
}

