/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.parameter.DefaultParameterValueGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.parameter.UnmodifiableParameterValue;
import org.apache.sis.parameter.Verifier;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

final class UnmodifiableParameterValueGroup
extends Parameters
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -7980778116268449513L;
    private final ParameterDescriptorGroup descriptor;
    private final List<GeneralParameterValue> values;

    private UnmodifiableParameterValueGroup(ParameterValueGroup group, Map<ParameterValueGroup, Boolean> done) {
        if (done.put(group, Boolean.TRUE) != null) {
            throw new IllegalArgumentException(Errors.format((short)18));
        }
        this.descriptor = group.getDescriptor();
        List values = group.values();
        GeneralParameterValue[] array = new GeneralParameterValue[values.size()];
        for (int i = 0; i < array.length; ++i) {
            Object value = (GeneralParameterValue)values.get(i);
            ArgumentChecks.ensureNonNullElement("values", i, value);
            if (value instanceof ParameterValue) {
                value = UnmodifiableParameterValue.create((ParameterValue)value);
            } else if (value instanceof ParameterValueGroup) {
                value = new UnmodifiableParameterValueGroup((ParameterValueGroup)value, done);
            }
            array[i] = value;
        }
        this.values = UnmodifiableArrayList.wrap(array);
    }

    static UnmodifiableParameterValueGroup create(ParameterValueGroup group) {
        if (group == null || group instanceof UnmodifiableParameterValueGroup) {
            return (UnmodifiableParameterValueGroup)group;
        }
        return new UnmodifiableParameterValueGroup(group, new IdentityHashMap<ParameterValueGroup, Boolean>(4));
    }

    public ParameterDescriptorGroup getDescriptor() {
        return this.descriptor;
    }

    public List<GeneralParameterValue> values() {
        return this.values;
    }

    @Override
    boolean isKnownImplementation() {
        return true;
    }

    public ParameterValue<?> parameter(String name) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", name);
        ParameterValue<?> value = this.parameterIfExist(name);
        if (value != null) {
            return value;
        }
        throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName((GeneralParameterDescriptor)this.descriptor), name), name);
    }

    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", name);
        ArrayList<ParameterValueGroup> groups = new ArrayList<ParameterValueGroup>(4);
        for (GeneralParameterValue value : this.values) {
            if (!(value instanceof ParameterValueGroup) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)value.getDescriptor(), name)) continue;
            groups.add((ParameterValueGroup)value);
        }
        if (groups.isEmpty() && !(this.descriptor.descriptor(name) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Resources.format((short)61, Verifier.getDisplayName((GeneralParameterDescriptor)this.descriptor), name), name);
        }
        return groups;
    }

    public ParameterValueGroup addGroup(String name) throws IllegalStateException {
        throw new UnsupportedOperationException(Errors.format((short)153, ParameterValueGroup.class));
    }

    @Override
    public Parameters clone() {
        DefaultParameterValueGroup copy = new DefaultParameterValueGroup(this.descriptor);
        Parameters.copy(this, copy);
        return copy;
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (mode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    UnmodifiableParameterValueGroup that = (UnmodifiableParameterValueGroup)object;
                    return Objects.equals(this.descriptor, that.descriptor) && Objects.equals(this.values, that.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                return DefaultParameterValueGroup.equals(this, (ParameterValueGroup)object, mode);
            }
        }
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ this.values.hashCode();
    }
}

