/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.identification.DefaultCoupledResource;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;

final class OperationName
extends DefaultOperationMetadata {
    private static final long serialVersionUID = 7221543581387125873L;

    OperationName(String operationName) {
        this.setOperationName(operationName);
    }

    @Override
    public String toString() {
        return Strings.bracket("OperationMetadata", (Object)this.getOperationName());
    }

    static void resolve(Collection<DefaultOperationMetadata> containsOperations, Collection<DefaultCoupledResource> coupledResources) {
        HashMap<String, DefaultOperationMetadata> byName = new HashMap<String, DefaultOperationMetadata>();
        for (DefaultOperationMetadata operation : containsOperations) {
            OperationName.add(byName, operation.getOperationName(), operation);
        }
        for (DefaultCoupledResource resource : coupledResources) {
            String name;
            DefaultOperationMetadata operation = resource.getOperation();
            if (!(operation instanceof OperationName) || (operation = (DefaultOperationMetadata)byName.get(name = operation.getOperationName())) == null && (operation = (DefaultOperationMetadata)byName.get(name)) == null) continue;
            resource.setOperation(operation);
        }
    }

    private static void add(Map<String, DefaultOperationMetadata> byName, String name, DefaultOperationMetadata operation) {
        boolean exists = byName.containsKey(name);
        DefaultOperationMetadata previous = byName.put(name, operation);
        if (previous != operation && (previous != null || exists)) {
            byName.put(name, null);
        }
    }
}

